package saccubus;

import java.net.URISyntaxException;
import static javax.swing.WindowConstants.*;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.SwingUtilities;

/**
 * <p>
 * タイトル: さきゅばす
 * </p>
 *
 * <p>
 * 説明: ニコニコ動画の動画をコメントつきで保存
 * </p>
 *
 * <p>
 * 著作権: Copyright (c) 2007 PSI
 * </p>
 *
 * <p>
 * 会社名:
 * </p>
 *
 * @author 未入力
 * @version 1.0
 */
public class MainFrame_AboutBox extends JDialog implements ActionListener {

    public static final String VERSION = "いんきゅばす 2.1.0";
    private static final long serialVersionUID = -4256413309312729840L;
    private static final Logger logger = LoggerFactory.getLogger(MainFrame_AboutBox.class);
    private static final String LINE_FEED = System.getProperty("line.separator");
    private final JButton btnOk = new JButton();

    public MainFrame_AboutBox(Frame parent) {
        super(parent);
        try {
            setDefaultCloseOperation(DISPOSE_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            logger.error(null, exception);
        }
    }

    public MainFrame_AboutBox() {
        this(null);
    }

    /**
     * コンポーネントの初期化。
     *
     * @throws java.lang.Exception
     */
    private void jbInit() {
        final JTabbedPane tab = new JTabbedPane(JTabbedPane.BOTTOM);

        final JLabel lblImage = new JLabel();
        final ImageIcon icon = new ImageIcon(saccubus.MainFrame_AboutBox.class.getResource("icon.png"));
        lblImage.setIcon(icon);

        final JTextArea fldProduct = createProductField();
        // Numbus bug 対応
        // http://stackoverflow.com/questions/613603/java-nimbus-laf-with-transparent-text-fields
        fldProduct.setOpaque(false);
        fldProduct.setBorder(BorderFactory.createEmptyBorder());
        fldProduct.setBackground(new Color(0, 0, 0, 0));

        final JButton btnInqubus = new JButton("いんきゅばすホームページへ...");
        btnInqubus.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("http://sourceforge.jp/projects/coroid/wiki/InqubusV2"));
                    } catch (IOException | URISyntaxException ex) {
                        logger.error(null, ex);
                    }
                }
            }
        });

        final JButton btnSaccubus = new JButton("さきゅばすホームページへ...");
        btnSaccubus.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("http://saccubus.sourceforge.jp/"));
                    } catch (IOException | URISyntaxException ex) {
                        logger.error(null, ex);
                    }
                }
            }
        });

        final JPanel pnlAbout = new JPanel();
        GroupLayout glAbout = new GroupLayout(pnlAbout);
        pnlAbout.setLayout(glAbout);
        glAbout.setAutoCreateContainerGaps(true);
        glAbout.setAutoCreateGaps(true);

        glAbout.setHorizontalGroup(glAbout.createParallelGroup(GroupLayout.Alignment.CENTER)
            .addGroup(glAbout.createSequentialGroup()
                .addComponent(lblImage)
                .addPreferredGap(ComponentPlacement.UNRELATED)
                .addComponent(fldProduct)
            )
            .addGroup(glAbout.createSequentialGroup()
                .addComponent(btnInqubus)
                .addComponent(btnSaccubus)
            )
        );

        glAbout.setVerticalGroup(glAbout.createSequentialGroup()
            .addGroup(glAbout.createParallelGroup()
                .addComponent(lblImage)
                .addComponent(fldProduct, 0, GroupLayout.PREFERRED_SIZE, GroupLayout.PREFERRED_SIZE)
            )
            .addGroup(glAbout.createParallelGroup()
                .addComponent(btnInqubus)
                .addComponent(btnSaccubus)
            )
        );

        tab.add("About", pnlAbout);

        final JScrollPane pnlLicense = createLicensePane();
        tab.add("License", pnlLicense);

        btnOk.setText("OK");
        btnOk.addActionListener(this);

        final JPanel pnlBase = new JPanel();
        final GroupLayout glBase = new GroupLayout(pnlBase);
        pnlBase.setLayout(glBase);
        glBase.setAutoCreateContainerGaps(true);
        glBase.setAutoCreateGaps(true);

        glBase.setHorizontalGroup(glBase.createParallelGroup(Alignment.CENTER)
            .addComponent(tab)
            .addComponent(btnOk)
        );

        glBase.setVerticalGroup(glBase.createSequentialGroup()
            .addComponent(tab)
            .addComponent(btnOk)
        );


        setContentPane(pnlBase);

        setTitle("バージョン情報");
        setResizable(true);
        pack();
    }

    private JTextArea createProductField() {
        final JTextArea area = new JTextArea();
        area.append(VERSION);
        area.append(LINE_FEED);
        area.append(LINE_FEED);

        try (BufferedReader reader = new BufferedReader(new InputStreamReader(getClass().getResourceAsStream(
                        "saccubus_description.txt"), "UTF-8"))) {
            String line;
            while ((line = reader.readLine()) != null) {
                area.append(line);
                area.append(LINE_FEED);
            }
        } catch (IOException ex) {
            logger.error(null, ex);
        }

        area.setEditable(false);
        return area;
    }

    private JScrollPane createLicensePane() {
        final JTextArea licenseField = new JTextArea();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(getClass().getResourceAsStream(
                        "LICENSE.txt"), "UTF-8"))) {
            String line;
            while ((line = reader.readLine()) != null) {
                licenseField.append(line);
                licenseField.append(LINE_FEED);
            }
        } catch (IOException ex) {
            logger.error(null, ex);
        }

        licenseField.setCaretPosition(0);
        licenseField.setEditable(false);
        final JScrollPane licensePane = new JScrollPane(licenseField);
        licensePane.setPreferredSize(new Dimension(400, 400));
        return licensePane;
    }

    /**
     * ボタンイベントでダイアログを閉じる
     *
     * @param actionEvent
     *            ActionEvent
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == btnOk) {
            dispose();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                MainFrame_AboutBox frame = new MainFrame_AboutBox();
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}
