package nicobrowser;

/**
 *
 * @author yuki
 */
public class NamePattern {

    private static final String titlePattern = "{title}";
    private static final String idPattern = "{id}";
    private static final String lowPattern = "{low}";
    private final String pattern;
    private String replaceFrom = "";
    private String replaceTo = "";
    private String id = "";
    private String title = "";
    private boolean isNotLow = true;

    public NamePattern(String pattern) {
        this.pattern = pattern;
    }

    /**
     * 保存ファイル名の命名規則.
     * @param pattern 命名パターン.
     * @param replaceFrom 禁則文字を指定する.
     * @param replaceTo 禁則文字をこの文字列に置換する.
     * @param title ファイル名に用いるタイトル文字列.
     */
    public NamePattern(String pattern, String replaceFrom, String replaceTo, String title) {
        this.pattern = pattern;
        this.replaceFrom = replaceFrom;
        this.replaceTo = replaceTo;
        this.title = title;
    }

    public final String createFileName() {
        String res = replacePlaceHolder(pattern);
        return replaceIllegalChar(res);
    }

    public final String createFileName(String id, boolean isNotLow) {
        this.id = id;
        this.isNotLow = isNotLow;

        return createFileName();
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final void setIsNotLow(boolean isNotLow) {
        this.isNotLow = isNotLow;
    }

    public final void setReplaceFrom(String replaceFrom) {
        this.replaceFrom = replaceFrom;
    }

    public final void setReplaceTo(String replaceTo) {
        this.replaceTo = replaceTo;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    protected String replacePlaceHolder(String str) {
        String res = str.replace(titlePattern, title);
        res = res.replace(idPattern, id);
        String low = isNotLow ? "" : "low";
        res = res.replace(lowPattern, low);
        return res;
    }

    private String replaceIllegalChar(String res) {
        // TODO 正規表現で書き直す
        char[] replaceds = new char[replaceFrom.length()];
        replaceFrom.getChars(0, replaceFrom.length(), replaceds, 0);
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < res.length(); i++) {
            char c = res.charAt(i);
            String moji = String.valueOf(c);
            for (char replaced : replaceds) {
                if (c == replaced) {
                    moji = replaceTo;
                }
            }
            str.append(moji);
        }
        return str.toString();
    }
}
