/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.security.SecureSocketFactory;
import org.h2.util.MathUtils;

public class NetUtils {
    private static InetAddress bindAddress;
    static /* synthetic */ Class class$org$h2$util$NetUtils;

    public static Socket createLoopbackSocket(int port, boolean ssl) throws IOException {
        InetAddress address = NetUtils.getBindAddress();
        if (address == null) {
            address = InetAddress.getLocalHost();
        }
        return NetUtils.createSocket(address.getHostAddress(), port, ssl);
    }

    public static Socket createSocket(String server, int defaultPort, boolean ssl) throws IOException {
        int port = defaultPort;
        int startIndex = server.startsWith("[") ? server.indexOf(93) : 0;
        int idx = server.indexOf(58, startIndex);
        if (idx >= 0) {
            port = MathUtils.decodeInt(server.substring(idx + 1));
            server = server.substring(0, idx);
        }
        InetAddress address = InetAddress.getByName(server);
        return NetUtils.createSocket(address, port, ssl);
    }

    public static Socket createSocket(InetAddress address, int port, boolean ssl) throws IOException {
        if (ssl) {
            SecureSocketFactory f = SecureSocketFactory.getInstance();
            return f.createSocket(address, port);
        }
        return new Socket(address, port);
    }

    public static ServerSocket createServerSocket(int port, boolean ssl) throws SQLException {
        try {
            return NetUtils.createServerSocketTry(port, ssl);
        }
        catch (SQLException e) {
            return NetUtils.createServerSocketTry(port, ssl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getBindAddress() throws UnknownHostException {
        String host = SysProperties.BIND_ADDRESS;
        if (host == null || host.length() == 0) {
            return null;
        }
        Class clazz = class$org$h2$util$NetUtils == null ? (class$org$h2$util$NetUtils = NetUtils.class$("org.h2.util.NetUtils")) : class$org$h2$util$NetUtils;
        synchronized (clazz) {
            if (bindAddress == null) {
                bindAddress = InetAddress.getByName(host);
            }
        }
        return bindAddress;
    }

    private static ServerSocket createServerSocketTry(int port, boolean ssl) throws SQLException {
        try {
            if (ssl) {
                SecureSocketFactory f = SecureSocketFactory.getInstance();
                return f.createServerSocket(port);
            }
            InetAddress bindAddress = NetUtils.getBindAddress();
            if (bindAddress == null) {
                return new ServerSocket(port);
            }
            return new ServerSocket(port, 0, bindAddress);
        }
        catch (BindException be) {
            throw Message.getSQLException(90061, new String[]{"" + port, be.toString()}, be);
        }
        catch (IOException e) {
            throw Message.convertIOException(e, "port: " + port + " ssl: " + ssl);
        }
    }

    public static boolean isLoopbackAddress(Socket socket) {
        boolean result = true;
        result = socket.getInetAddress().isLoopbackAddress();
        return result;
    }

    public static ServerSocket closeSilently(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getLocalAddress() {
        InetAddress bind = null;
        try {
            bind = NetUtils.getBindAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return bind == null ? "localhost" : bind.getHostAddress();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

