/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.identitymaps;

import java.util.Vector;
import oracle.toplink.essentials.internal.helper.linkedlist.ExposedNodeLinkedList;
import oracle.toplink.essentials.internal.helper.linkedlist.LinkedNode;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.identitymaps.WeakCacheKey;
import oracle.toplink.essentials.internal.identitymaps.WeakIdentityMap;

public class HardCacheWeakIdentityMap
extends WeakIdentityMap {
    protected ExposedNodeLinkedList referenceCache = new ExposedNodeLinkedList();

    public HardCacheWeakIdentityMap(int size) {
        super(size);
    }

    public CacheKey createCacheKey(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
        return new ReferenceCacheKey(primaryKey, object, writeLockValue, readTime);
    }

    public ExposedNodeLinkedList getReferenceCache() {
        return this.referenceCache;
    }

    public Object buildReference(Object object) {
        return object;
    }

    public boolean hasReference(Object reference) {
        return reference != null;
    }

    protected void put(CacheKey cacheKey) {
        ReferenceCacheKey referenceCacheKey = (ReferenceCacheKey)cacheKey;
        LinkedNode node = this.getReferenceCache().addFirst(this.buildReference(referenceCacheKey.getObject()));
        referenceCacheKey.setReferenceCacheNode(node);
        super.put(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(CacheKey cacheKey) {
        if (cacheKey == null) {
            return null;
        }
        ReferenceCacheKey referenceCacheKey = (ReferenceCacheKey)cacheKey;
        HardCacheWeakIdentityMap hardCacheWeakIdentityMap = this;
        synchronized (hardCacheWeakIdentityMap) {
            this.getReferenceCache().remove(referenceCacheKey.getReferenceCacheNode());
        }
        return super.remove(cacheKey);
    }

    public synchronized void updateMaxSize(int maxSize) {
        this.setMaxSize(maxSize);
        while (this.getReferenceCache().size() > this.getMaxSize()) {
            this.getReferenceCache().removeLast();
        }
    }

    public class ReferenceCacheKey
    extends WeakCacheKey {
        protected LinkedNode referenceNode;

        public ReferenceCacheKey(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
            super(primaryKey, object, writeLockValue, readTime);
        }

        public LinkedNode getReferenceCacheNode() {
            return this.referenceNode;
        }

        public void setReferenceCacheNode(LinkedNode referenceNode) {
            this.referenceNode = referenceNode;
        }

        public ExposedNodeLinkedList getReferenceCache() {
            return HardCacheWeakIdentityMap.this.referenceCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAccess() {
            HardCacheWeakIdentityMap hardCacheWeakIdentityMap = HardCacheWeakIdentityMap.this;
            synchronized (hardCacheWeakIdentityMap) {
                if (!HardCacheWeakIdentityMap.this.hasReference(this.getReferenceCacheNode().getContents())) {
                    this.getReferenceCacheNode().setContents(HardCacheWeakIdentityMap.this.buildReference(this.getObject()));
                }
                this.getReferenceCache().moveFirst(this.getReferenceCacheNode());
                while (this.getReferenceCache().size() > HardCacheWeakIdentityMap.this.getMaxSize()) {
                    this.getReferenceCache().removeLast();
                }
            }
        }
    }
}

