/*$Id: Util.java 283 2010-04-01 06:21:36Z yuki $*/
package nicobrowser.util;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {

    static ResultParse rp = new ResultParse();
    static UserInfo ui = new UserInfo();

    public static String getExtention(String contentType) {
        if ("video/flv".equals(contentType) || "video/x-flv".equals(contentType)) {
            return "flv";
        } else if ("video/mp4".equals(contentType)) {
            return "mp4";
        } else if ("application/x-shockwave-flash".equals(contentType)) {
            return "swf";
        }
        return contentType.split("/")[1];
    }

    public static List<Result> parseSerchResult(InputStream is) {
        return rp.parse(is);
    }

    public static String getNextPage(InputStream is) {
        return rp.getNextPage(is);
    }

    /**
     * ユーザIDを取得する
     * @param is ニコニコ動画のウォッチページストリーム.
     * @return ユーザID. 取得できなければnull.
     */
    public static String getUserId(InputStream is) {
        return ui.getUserId(is);
    }

    /**
     * 違反通報ページURLを取得する.
     * @param is ニコニコ動画のウォッチページストリーム.
     * @return 違反通報ページURL. 取得できなければnull.
     */
    public static URL getNotifierUrl(InputStream is) {
        String res = ui.getNotifierUrl(is);
        if (res == null) {
            return null;
        }

        try {
            return new URL(res);
        } catch (MalformedURLException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /**
     * ユーザ名を取得する.
     * @param is 違反通報ページストリーム.
     * @return ユーザ名. 取得できなければnull.
     */
    public static String getUserName(InputStream is) {
        String userName = ui.getUserName(is);
        if ("".equals(userName)) {
            userName = null;
        }
        return userName;
    }
}
