/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Logger;
import liquibase.FileOpener;
import liquibase.change.AbstractSQLChange;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.SetupException;
import liquibase.log.LogFactory;
import liquibase.util.MD5Util;
import liquibase.util.StreamUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLFileChange
extends AbstractSQLChange {
    private static final Logger log = LogFactory.getLogger();
    private String file;
    private String encoding = null;

    public SQLFileChange() {
        super("sqlFile", "SQL From File");
    }

    public String getPath() {
        return this.file;
    }

    public void setPath(String fileName) {
        this.file = fileName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setUp() throws SetupException {
        if (this.file == null) {
            throw new SetupException("<sqlfile> - No path specified");
        }
        log.fine("SQLFile file:" + this.file);
        boolean loaded = this.loadFromClasspath(this.file);
        if (!loaded) {
            loaded = this.loadFromFileSystem(this.file);
        }
        if (!loaded) {
            throw new SetupException("<sqlfile path=" + this.file + "> - Could not find file");
        }
        log.finer("SQLFile file contents is:" + this.getSql());
    }

    private boolean loadFromFileSystem(String file) throws SetupException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.setSql(StreamUtil.getStreamContents(fis, this.encoding));
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fnfe) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new SetupException("<sqlfile path=" + file + "> -Unable to read file", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromClasspath(String file) throws SetupException {
        InputStream in = null;
        try {
            FileOpener fo = this.getFileOpener();
            if (fo == null) {
                boolean bl = false;
                return bl;
            }
            in = fo.getResourceAsStream(file);
            if (in == null) {
                boolean bl = false;
                return bl;
            }
            this.setSql(StreamUtil.getStreamContents(in, this.encoding));
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            throw new SetupException("<sqlfile path=" + file + "> -Unable to read file", ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    @Override
    public String getMD5Sum() {
        return MD5Util.computeMD5(this.getSql());
    }

    @Override
    public Element createNode(Document currentChangeLogDOM) {
        Element sqlElement = currentChangeLogDOM.createElement("sqlFile");
        sqlElement.setAttribute("path", this.file);
        if (this.encoding != null) {
            sqlElement.setAttribute("encoding", this.encoding);
        }
        return sqlElement;
    }

    @Override
    public String getConfirmationMessage() {
        return "SQL in file " + this.file + " executed";
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }
}

