/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.ObjectUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueShort
extends Value {
    public static final int PRECISION = 5;
    public static final int DISPLAY_SIZE = 6;
    private final short value;

    private ValueShort(short value) {
        this.value = value;
    }

    public Value add(Value v) throws SQLException {
        ValueShort other = (ValueShort)v;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            return this.checkRange(this.value + other.value);
        }
        return ValueShort.get((short)(this.value + other.value));
    }

    private ValueShort checkRange(int value) throws SQLException {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw Message.getSQLException(90110, DataType.getDataType((int)3).name);
        }
        return ValueShort.get((short)value);
    }

    public int getSignum() {
        return this.value == 0 ? 0 : (this.value < 0 ? -1 : 1);
    }

    public Value negate() throws SQLException {
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            return this.checkRange(-this.value);
        }
        return ValueShort.get(-this.value);
    }

    public Value subtract(Value v) throws SQLException {
        ValueShort other = (ValueShort)v;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            return this.checkRange(this.value - other.value);
        }
        return ValueShort.get((short)(this.value - other.value));
    }

    public Value multiply(Value v) throws SQLException {
        ValueShort other = (ValueShort)v;
        if (SysProperties.OVERFLOW_EXCEPTIONS) {
            return this.checkRange(this.value * other.value);
        }
        return ValueShort.get((short)(this.value * other.value));
    }

    public Value divide(Value v) throws SQLException {
        ValueShort other = (ValueShort)v;
        if (other.value == 0) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        return ValueShort.get((short)(this.value / other.value));
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 3;
    }

    public short getShort() {
        return this.value;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueShort v = (ValueShort)o;
        if (this.value == v.value) {
            return 0;
        }
        return this.value > v.value ? 1 : -1;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 5L;
    }

    public int hashCode() {
        return this.value;
    }

    public Object getObject() {
        return ObjectUtils.getShort(this.value);
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setShort(parameterIndex, this.value);
    }

    public static ValueShort get(short i) {
        return (ValueShort)Value.cache(new ValueShort(i));
    }

    public int getDisplaySize() {
        return 6;
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueShort && this.value == ((ValueShort)v).value;
    }
}

