/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.StringUtils;

public class ClassUtils {
    private static final boolean ALLOW_ALL;
    private static final HashSet ALLOWED_CLASS_NAMES;
    private static final String[] ALLOWED_CLASS_NAME_PREFIXES;

    public static Class loadSystemClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public static Class loadUserClass(String className) throws ClassNotFoundException, SQLException {
        if (!ALLOW_ALL && !ALLOWED_CLASS_NAMES.contains(className)) {
            boolean allowed = false;
            for (int i = 0; i < ALLOWED_CLASS_NAME_PREFIXES.length; ++i) {
                String s = ALLOWED_CLASS_NAME_PREFIXES[i];
                if (!className.startsWith(s)) continue;
                allowed = true;
            }
            if (!allowed) {
                throw Message.getSQLException(90134, className);
            }
        }
        return Class.forName(className);
    }

    static {
        ALLOWED_CLASS_NAMES = new HashSet();
        String s = SysProperties.ALLOWED_CLASSES;
        String[] list = StringUtils.arraySplit(s, ',', true);
        ArrayList<String> prefixes = new ArrayList<String>();
        boolean allowAll = false;
        for (int i = 0; i < list.length; ++i) {
            String p = list[i];
            if (p.equals("*")) {
                allowAll = true;
                continue;
            }
            if (p.endsWith("*")) {
                prefixes.add(p.substring(0, p.length() - 1));
                continue;
            }
            ALLOWED_CLASS_NAMES.add(p);
        }
        ALLOW_ALL = allowAll;
        ALLOWED_CLASS_NAME_PREFIXES = new String[prefixes.size()];
        prefixes.toArray(ALLOWED_CLASS_NAME_PREFIXES);
    }
}

