/* $Id: ConvertSetting.java 363 2010-04-12 16:35:06Z yuki $ */
package saccubus.properties;

import java.io.File;
import java.util.Properties;
import saccubus.converter.profile.NgSetting;

/**
 * ϊݒ.
 * @author yuki
 */
public class ConvertSetting {

    private static final String PROP_DISABLE_VHOOK = "VhookDisabled";
    private static final String PROP_SHOW_COMMENT = "ShowCommentNum";
    private static final String PROP_FONT_PATH = "FontPath";
    private static final String PROP_FONT_INDEX = "FontIndex";
    private static final String PROP_SHADOW_INDEX = "ShadowIndex";
    private static final String PROP_SHOW_VIDEO = "ShowVideo";
    private static final String PROP_FIX_FONT_SIZE = "FixFontSize";
    private static final String PROP_OPAQUE_COMMENT = "OpaqueComment";
    private static final String PROP_NG_WORD = "NG_Word";
    private static final String PROP_NG_ID = "NG_ID";
    private final boolean vhookDisabled;
    private final int maxNumOfComment;
    private final File font;
    private final int fontIndex;
    private final int shadowIndex;
    private final boolean showConverting;
    private final boolean selfAdjustFontSize;
    private final boolean commentOpaque;
    private final NgSetting ngSetting;

    public ConvertSetting(boolean vhookDisabled, int maxNumOfComment, File font, int fontIndex, int shadowIndex,
            boolean showConverting, boolean selfAdjustFontSize, boolean commentOpaque, NgSetting ngSetting) {
        this.vhookDisabled = vhookDisabled;
        this.maxNumOfComment = maxNumOfComment;
        this.font = font;
        this.fontIndex = fontIndex;
        this.shadowIndex = shadowIndex;
        this.showConverting = showConverting;
        this.selfAdjustFontSize = selfAdjustFontSize;
        this.commentOpaque = commentOpaque;
        this.ngSetting = ngSetting;
    }

    public boolean isCommentOpaque() {
        return commentOpaque;
    }

    public File getFont() {
        return font;
    }

    public int getFontIndex() {
        return fontIndex;
    }

    public int getMaxNumOfComment() {
        return maxNumOfComment;
    }

    public boolean isSelfAdjustFontSize() {
        return selfAdjustFontSize;
    }

    public int getShadowIndex() {
        return shadowIndex;
    }

    public boolean isShowConverting() {
        return showConverting;
    }

    public boolean isVhookDisabled() {
        return vhookDisabled;
    }

    public NgSetting getNgSetting() {
        return ngSetting;
    }

    public void save(Properties prop) {
        prop.setProperty(PROP_SHOW_COMMENT, Integer.toString(getMaxNumOfComment()));
        prop.setProperty(PROP_FONT_PATH, getFont().getPath());
        prop.setProperty(PROP_FONT_INDEX, Integer.toString(getFontIndex()));
        prop.setProperty(PROP_SHOW_VIDEO, Boolean.toString(isShowConverting()));
        prop.setProperty(PROP_NG_WORD, getNgSetting().getWord());
        prop.setProperty(PROP_NG_ID, getNgSetting().getId());
        prop.setProperty(PROP_FIX_FONT_SIZE, Boolean.toString(isSelfAdjustFontSize()));
        prop.setProperty(PROP_OPAQUE_COMMENT, Boolean.toString(isCommentOpaque()));
        prop.setProperty(PROP_DISABLE_VHOOK, Boolean.toString(isVhookDisabled()));
        prop.setProperty(PROP_SHADOW_INDEX, Integer.toString(getShadowIndex()));
    }

    public static ConvertSetting load(Properties prop) {
        String defaultFont = "";
        String win_dir = System.getenv("windir");
        if (win_dir != null) {
            //windows ̏ꍇ̃ftHgtHgpX
            defaultFont = new File(win_dir, "Fonts" + File.separator + "msgothic.ttc").getPath();
        }


        int maxComment = Integer.parseInt(prop.getProperty(PROP_SHOW_COMMENT, "30"));
        String font = prop.getProperty(PROP_FONT_PATH, defaultFont);
        int fontIndex = Integer.parseInt(prop.getProperty(PROP_FONT_INDEX, "1"));
        boolean showConv = Boolean.parseBoolean(prop.getProperty(PROP_SHOW_VIDEO, "true"));
        String ngWord = prop.getProperty(PROP_NG_WORD, "");
        String ngId = prop.getProperty(PROP_NG_ID, "");
        boolean adjustFont = Boolean.parseBoolean(prop.getProperty(PROP_FIX_FONT_SIZE, "true"));
        boolean opaque = Boolean.parseBoolean(prop.getProperty(PROP_OPAQUE_COMMENT, "false"));
        boolean vhookDisabled = Boolean.parseBoolean(prop.getProperty(PROP_DISABLE_VHOOK, "false"));
        int shadowIndex = Integer.parseInt(prop.getProperty(PROP_SHADOW_INDEX, "1"));

        return new ConvertSetting(vhookDisabled, maxComment, new File(font), fontIndex, shadowIndex, showConv,
                adjustFont, opaque, new NgSetting(ngWord, ngId));
    }
}
