package saccubus.prompt;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import saccubus.ConvertStopFlag;
import saccubus.ConvertStopFlag.State;
import saccubus.converter.Converter;
import saccubus.converter.filegetter.LoginInfo;
import saccubus.converter.profile.CommentGetInfo;
import saccubus.converter.profile.Ffmpeg;
import saccubus.converter.profile.FfmpegOption;
import saccubus.converter.profile.GeneralSetting;
import saccubus.converter.profile.InputFileSetting;
import saccubus.converter.profile.OutputFileSetting;
import saccubus.converter.profile.Profile;
import saccubus.converter.profile.SFile;
import saccubus.properties.SProperties;
import saccubus.net.TextProgressListener;

/**
 * <p>
 * ^Cg: ΂
 * </p>
 * 
 * <p>
 * : jRjR̓Rgŕۑ
 * </p>
 * 
 * <p>
 * 쌠: Copyright (c) 2007 PSI
 * </p>
 * 
 * <p>
 * Ж:
 * </p>
 * 
 * @author 
 * @version 1.0
 */
public class Prompt {

    public static void main(String[] args) throws IOException {
        // 1[AhXƎv͐̂̈łƂ݂Ȃăp[XAs.
        if (args.length > 0 && args[0].contains("@")) {
            doWithOldArguments(args);
            return;
        }

        new Prompt().execute(args);
    }

    public void execute(String[] args) throws IOException {
        execute(args, TextProgressListener.EMPTY_LISTENER, ConvertStopFlag.StateChangeListener.EMPTY_LISTENER);
    }

    public void execute(String[] args, TextProgressListener tpl, ConvertStopFlag.StateChangeListener scl) throws
            IOException {
        Options options = createOptions(args);
        Profile profile;
        try {
            CommandLineParser parser = new BasicParser();
            CommandLine cmd = parser.parse(options, args);
            profile = createExecuteOption(cmd);
        } catch (Exception e) {
            HelpFormatter hf = new HelpFormatter();
            hf.printHelp("java -jar Saccubus.jar [opts]", options);
            System.out.flush();
            throw new IOException(e);
        }

        Converter conv = new Converter("dummy", "", profile, tpl, new ConvertStopFlag(scl));
        ExecutorService es = Executors.newSingleThreadExecutor();
        Future<Boolean> future = es.submit((Callable<Boolean>) conv);
        try {
            boolean res = future.get().booleanValue();
            if (!res) {
                throw new IOException("ffmpegϊɏI܂łB");
            }
        } catch (Exception ex) {
            throw new IOException("擾s", ex);
        }
        System.out.println("Finished.");
    }

    private Options createOptions(String[] args) {
        Options options = new Options();
//        Option id = OptionBuilder.withArgName("mail").hasArg().withDescription("jRjR惍OCID([AhX)").create("id");
//        Option password = OptionBuilder.withArgName("password").hasArg().withDescription("jRjR惍OCpX[h").
//                create("password");
//        Option video = OptionBuilder.withArgName("id").hasArg().withDescription("jRjRrfIID").create("video");
        Option videoFile = OptionBuilder.withArgName("file").hasArg().withDescription("t@C").create("file_video");
        Option commentFile = OptionBuilder.withArgName("file").hasArg().withDescription("Rgt@C").
                create("file_comment");
        Option tcommentFile = OptionBuilder.withArgName("file").hasArg().withDescription("e҃Rgt@C").
                create("file_tcomment");
        Option outputFile = OptionBuilder.withArgName("file").hasArg().withDescription("o̓t@C").create("file_output");
        Option ffmpeg = OptionBuilder.withArgName("option").hasArg().withDescription("ffmpegϊIvV").create("ffmpeg");
//        options.addOption(id);
//        options.addOption(password);
//        options.addOption(video);
        options.addOption(videoFile);
        options.addOption(commentFile);
        options.addOption(tcommentFile);
        options.addOption(outputFile);
        options.addOption(ffmpeg);
        return options;
    }

    private Profile createExecuteOption(CommandLine cmd) throws IOException {
        final String mail = "dmy";
        final String pass = "dmy";
        final String video = cmd.getOptionValue("file_video");
        final String comm = cmd.getOptionValue("file_comment");
        final String tcomm = cmd.getOptionValue("file_tcomment");
        final String output = cmd.getOptionValue("file_output");
        final String ff = cmd.getOptionValue("ffmpeg");

        SProperties setting = SProperties.loadSetting(mail, pass);
        Profile p = setting.toProfile();
        GeneralSetting general = p.getGeneralSetting();
        LoginInfo loginInfo = p.getLoginInfo();
//        InputFileSetting videoSetting = p.getVideoSetting();
//        InputFileSetting commentSetting = p.getCommentSetting();
        CommentGetInfo commentGetInfo = p.getCommentGetInfo();
//        InputFileSetting tcommentSetting = p.getTcommentSetting();
//        OutputFileSetting outputFileSetting = p.getOutputFileSetting();
        Ffmpeg ffmpeg = p.getFfmpeg();

        FfmpegOption newFfmpegOption = new FfmpegOption(ffmpeg.getFfmpegOption().getExtOption(), "", "", ff);
        InputFileSetting newVideoSetting = new InputFileSetting(new SFile(true, new File(video)), false, false);
        InputFileSetting newCommentSetting = new InputFileSetting(new SFile(true, new File(comm)), false, false);
        InputFileSetting newTcommentSetting = new InputFileSetting(new SFile(true, new File(tcomm)), false, false);
        OutputFileSetting newOutputFileSetting = new OutputFileSetting(new SFile(true, new File(output)), true, false,
                true, true);
        Ffmpeg newFfmpeg = new Ffmpeg(ffmpeg.getFfmpeg(), ffmpeg.getVhook(), newFfmpegOption, ffmpeg.isVhookDisabled(), ffmpeg.
                getMaxNumOfComment(), ffmpeg.getFont(), ffmpeg.getFontIndex(), ffmpeg.getShadowIndex(), ffmpeg.
                isShowConverting(), ffmpeg.isSelfAdjustFontSize(), ffmpeg.isCommentOpaque(), ffmpeg.getNgSetting());

        p = new Profile(general, loginInfo, newVideoSetting, newCommentSetting, commentGetInfo, newTcommentSetting,
                newOutputFileSetting, newFfmpeg);

        return p;
    }

    /**
     * ̂̈`ŃvOs.
     */
    private static void doWithOldArguments(String[] args) throws IOException {
        String mail = args[0];
        String pass = args[1];
        String tag = args[2];
        String time = args.length < 4 ? "" : args[3];
        SProperties setting = SProperties.loadSetting(mail, pass);
        Converter conv = new Converter(tag, time, setting.toProfile(), TextProgressListener.EMPTY_LISTENER, new ConvertStopFlag(
                ConvertStopFlag.StateChangeListener.EMPTY_LISTENER));
        System.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        System.out.println("Saccubus on CUI");
        System.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        System.out.println("Mailaddr: " + mail);
        System.out.println("Password: hidden");
        System.out.println("VideoID: " + tag);
        System.out.println("WaybackTime: " + time);
        System.out.println("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        conv.run();
        System.out.println("Finished.");
    }
}
