/* $Id: WebFileInstanciator.java 318 2009-12-21 08:09:18Z yuki $ */
package saccubus.converter.filegetter;

import java.io.IOException;
import java.text.Normalizer;
import saccubus.ConvertStopFlag;
import saccubus.converter.profile.Proxy;
import saccubus.net.NicoClient;
import saccubus.net.VideoInfo;

/**
 * t@C, Rgt@CȂǕKvȃt@Ĉ, 1ł_E[hKvƂꍇ̃CX^XNX.
 * @author yuki
 */
public class WebFileInstanciator extends FileInstanciator {

    private final NicoClient client;
    private final VideoInfo videoInfo;

    WebFileInstanciator(
            ConvertStopFlag stopFlag,
            InstanciationType videoType,
            CommentInstanciationType commentType,
            InstanciationType tcommType,
            LoginInfo li,
            String tag,
            String time) throws IOException {
        super(videoType, commentType, tcommType, tag);

        if (li.getMail() == null || li.getPass() == null || li.getMail().equals("") || li.getPass().equals("")) {
            throw new IllegalArgumentException("[AhXpX[h󔒂łB");
        }

        String host;
        int port;
        if (li.getProxy() != Proxy.NO_PROXY) {
            host = li.getProxy().getHost();
            port = li.getProxy().getPort();
        } else {
            host = null;
            port = -1;
        }
        client = new NicoClient(li.getMail(), li.getPass(), stopFlag, host, port);

        if (!client.isLoggedIn()) {
            throw new IOException("OCɎs");
        }

        try {
            videoInfo = client.getVideoInfo(tag, time);
        } catch (IOException ex) {
            throw new IOException(tag + "̏̎擾Ɏs", ex);
        }

        if (videoType.isDoanload()) {
            setVideoFileGetter(new VideoFileWebGetter(client, videoInfo));
        }

        if (commentType.isDoanload()) {
            setCommentFileGetter(new CommentFileWebGetter(client, videoInfo, commentType.isAutoCommentNum(),
                    commentType.getBackComment()));
        }

        if (tcommType.isDoanload()) {
            setTcommFileGetter(new TcommFileWebGetter(client, videoInfo));
        }
    }

    /**
     * ̃^Cg擾B
     * ۂ̓^Cg̓t@Cɗp邱ƂoȂ܂łꍇ邽߁At@CɓK悤ɕҏWlԂB
     * @return
     */
    @Override
    public String getVideoTitle() {
        String name = videoInfo.getVideoTitle();
        name = Normalizer.normalize(name, Normalizer.Form.NFKC);
        name = name.replaceAll("[\\\\/:*?\"<>|.]", "_");
        name = name.replace('\u2212', '\uff0d'); // | U+2212(MINUS SIGN) -> U+FF0D(FULLWIDTH HYPHEN-MINUS)
        name = name.replace('\u301c', '\uff5e'); // ` U+301C(WAVE DASH) -> U+FF5E(FULLWIDTH TILDE)
        name = name.replace('\u223c', '\uff5e'); // ` U+223C(TILDE OPERATOR) -> U+FF5E(FULLWIDTH TILDE)
        name = name.replace('\u00a2', '\uffe0'); //  U+00A2(CENT SIGN) -> U+FFE0(FULLWIDTH CENT SIGN)
        name = name.replace('\u00a3', '\uffe1'); //  U+00A3(POUND SIGN) -> U+FFE1(FULLWIDTH POUND SIGN)
        name = name.replace('\u00ac', '\uffe2'); //  U+00AC(NOT SIGN) -> U+FFE2(FULLWIDHT NOT SIGN)
        return name;
    }
}
