package saccubus.converter;

import saccubus.converter.profile.Profile;
import saccubus.converter.profile.FfmpegOption;
import saccubus.converter.filegetter.FileInstanciator;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import saccubus.ConvertStopFlag;
import saccubus.net.TextProgressListener;

/**
 * <p>^Cg: ΂</p>
 *
 * <p>: jRjR̓Rgŕۑ</p>
 *
 * <p>쌠: Copyright (c) 2007 PSI</p>
 *
 * <p>Ж: </p>
 *
 * @author 
 * @version 1.0
 */
public class Converter extends AbstractCommand implements Runnable, Callable<Boolean> {

    private static final String VIDEO_URL_PARSER = "http://www.nicovideo.jp/watch/";
    private final Profile Setting;
    private final String Tag;
    private final String Time;

    public Converter(String url, String time, Profile setting,
            TextProgressListener listener, ConvertStopFlag flag) {
        super(listener, flag);
        url = url.trim();
        if (url.startsWith(VIDEO_URL_PARSER)) {
            int index = url.indexOf('?', VIDEO_URL_PARSER.length());
            if (index >= 0) {
                Tag = url.substring(VIDEO_URL_PARSER.length(), index);
            } else {
                Tag = url.substring(VIDEO_URL_PARSER.length());
            }
        } else {
            Tag = url;
        }
        Time = time;
        Setting = setting;
    }

    public Boolean call() throws Exception {
        boolean result = false;
        try {
            result = runConvert();
        } finally {
            getStopFlag().finished();
        }
        return Boolean.valueOf(result);
    }

    public void run() {
        try {
            call();
        } catch (Exception ex) {
            String text = (ex.getMessage() != null) ? ex.getMessage() : "\ȂG[̂ߒf܂B";
            sendText(text);
            ex.printStackTrace();
        }
    }

    private boolean runConvert() throws IOException, InterruptedException {
        if (!Setting.shouldRun()) {
            sendText("邱Ƃ܂");
            return true;
        }

        validSetting();
        final FfmpegOption ov = Setting.getFfmpeg().getFfmpegOption();

        sendText("OC");

        final FileInstanciator fi = createInstanciator();

        stopFlagReturn();

        final File videoFile = fi.getVideoFile(getListener());

        stopFlagReturn();

        File commentFile = fi.getCommentFile(getListener());

        stopFlagReturn();

        File tcommFile = fi.getTcommFile(getListener());

        if (!Setting.needsConvert()) {
            sendText("ERgۑAϊ͍s܂łB");
            return true;
        }

        if (!videoFile.isFile()) {
            throw new IOException("͓t@C݂܂:" + videoFile.getPath());
        }

        if (Setting.getOutputFileSetting().isAddComment()) {
            if (!commentFile.isFile()) {
                throw new IOException("̓Rgt@C݂܂:" + commentFile.getPath());
            }
        } else {
            commentFile = null;
        }

        if (Setting.getOutputFileSetting().isAddTcomment()) {
            if (!tcommFile.isFile()) {
                throw new IOException("͓e҃Rgt@C݂܂" + tcommFile.getPath());
            }
        } else {
            tcommFile = null;
        }

        /*rfI̊m*/
        File convertedVideoFile;
        if (!Setting.getOutputFileSetting().getFile().isFile()) {
            String conv_name = fi.getVideoTitle();
            if (Setting.getOutputFileSetting().isAppendPrefixVideoId()) {
                conv_name = getVideoIDWithBracket() + conv_name;
            }
            convertedVideoFile = new File(Setting.getOutputFileSetting().getFile().getFile(),
                    conv_name + ov.getExtOption());
        } else {
            String filename = Setting.getOutputFileSetting().getFile().getFile().getPath();
            if (!filename.endsWith(ov.getExtOption())) {
                filename = filename.substring(0, filename.lastIndexOf('.')) + ov.getExtOption();
                convertedVideoFile = new File(filename);
            } else {
                convertedVideoFile = Setting.getOutputFileSetting().getFile().getFile();
            }
        }

        boolean res = new FfmpegCommand(getListener(), getStopFlag(), commentFile, tcommFile, videoFile,
                convertedVideoFile, Setting.getFfmpeg(), Setting.getGeneralSetting()).execute();
        if (res) {
            if (Setting.getCommentSetting().isDelete()) {
                commentFile.delete();
            }
            if (Setting.getVideoSetting().isDelete()) {
                videoFile.delete();
            }
            if (Setting.getTcommentSetting().isDelete()) {
                tcommFile.delete();
            }
        }
        return res;
    }

    private FileInstanciator createInstanciator() throws IOException {
        FileInstanciator fi;

        FileInstanciator.InstanciationType videoType = new FileInstanciator.InstanciationType(Setting.getVideoSetting());

        FileInstanciator.CommentInstanciationType commentType = new FileInstanciator.CommentInstanciationType(Setting.
                getCommentSetting(), Setting.getCommentGetInfo().isselfAdjustCommentNum(), Setting.getCommentGetInfo().
                getBackComment());

        FileInstanciator.InstanciationType tcommType = new FileInstanciator.InstanciationType(
                Setting.getTcommentSetting());

        fi = FileInstanciator.create(getStopFlag(), videoType, commentType, tcommType, Setting.getLoginInfo(), Tag, Time);
        return fi;
    }

    /**
     * (lbg[NݒȊO)ݒ؂.
     * @throws IllegalArgumentException ݒɕsꍇ.
     */
    private void validSetting() {
        if (Setting.needsConvert()) {
            File a = Setting.getFfmpeg().getFfmpeg();
            if (!a.canRead()) {
                throw new IllegalArgumentException("FFmpeg܂B");
            }
            if (Setting.getFfmpeg().getVhook().getPath().indexOf(' ') >= 0) {
                throw new IllegalArgumentException("܂BvhookCuɂ͔p󔒂͎g܂B");
            }
            a = Setting.getFfmpeg().getVhook();
            if (!a.canRead()) {
                throw new IllegalArgumentException("VhookCu܂B");
            }
            a = Setting.getFfmpeg().getFont();
            if (!a.canRead()) {
                throw new IllegalArgumentException("tHg܂B");
            }
        } else {
            if (Setting.getVideoSetting().isDelete()) {
                throw new IllegalArgumentException("ϊȂ̂ɁA폜ėǂłH");
            }
            if (Setting.getCommentSetting().isDelete()) {
                throw new IllegalArgumentException("ϊȂ̂ɁARg폜ėǂłH");
            }
            if (Setting.getTcommentSetting().isDelete()) {
                throw new IllegalArgumentException("ϊȂ̂ɁAe҃Rg폜ėǂłH");
            }
        }
    }

    private String getVideoIDWithBracket() {
        return "[" + Tag + "]";
    }

    public boolean isConverted() {
        return getStopFlag().isFinished();
    }

    @Override
    public ConvertStopFlag getStopFlag() {
        return super.getStopFlag();
    }
}
