package saccubus;

import java.io.IOException;
import saccubus.converter.Converter;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import nicobrowser.entity.NicoContent;
import org.apache.commons.lang.StringUtils;
import saccubus.ConvertStopFlag.State;
import saccubus.converter.profile.FfmpegOption;
import saccubus.converter.profile.NgSetting;
import saccubus.net.TextProgressListener;
import saccubus.properties.BasicSetting;
import saccubus.properties.ConvertSetting;
import saccubus.properties.InputCommentSetting;
import saccubus.properties.InputVideoSetting;
import saccubus.properties.SProperties;
import saccubus.properties.InputTcommentSetting;
import saccubus.properties.MovieSetting;
import saccubus.properties.OutputVideoSetting;
import saccubus.util.FileDropTarget;
import saccubus.util.PopupRightClick;
import yukihane.nicovideo.NicoDBFinder;

/**
 * <p>
 * ^Cg: ΂
 * </p>
 * 
 * <p>
 * : jRjR̓Rgŕۑ
 * </p>
 * 
 * <p>
 * 쌠: Copyright (c) 2007 PSI
 * </p>
 * 
 * <p>
 * Ж:
 * </p>
 * 
 * @author 
 * @version 1.0
 */
public class MainFrame extends JFrame {

    private static final long serialVersionUID = 2564486741331062989L;
    public static final String VERSION = "1.22r NicoBrowserg 1.4.0";
    public static final Image WinIcon = Toolkit.getDefaultToolkit().createImage(saccubus.MainFrame.class.getResource(
            "icon32.png"));
    // TODO GUI߃tB[hɕێ.
    private File tempDir;
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JLabel statusBar = new JLabel();
    JTabbedPane MainTabbedPane = new JTabbedPane();
    JPanel SavingInfoTabPanel = new JPanel();
    JPanel FFMpegTabPanel = new JPanel();
    JPanel VideoInfoPanel = new JPanel();
    JTextField VideoID_TextField = new JTextField();
    JButton DoButton = new JButton();
    public static final String DoButtonDefString = "ϊ";
    public static final String DoButtonStopString = "~";
    public static final String DoButtonWaitString = "ҋ@";
    JPanel UserInfoPanel = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel MailAddrLabel = new JLabel();
    JTextField MailAddrField = new JTextField();
    JLabel PasswordLabel = new JLabel();
    JPasswordField PasswordField = new JPasswordField();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    ButtonGroup CommentSaveButtonGroup = new ButtonGroup();
    ButtonGroup ConvSaveButtonGroup = new ButtonGroup();

    public MainFrame() {
        videoSaveInfoPanel = savePanel.getVideoSaveInfoPanel();

        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
            setPopup();
            setDropTarget();
            SProperties setting = SProperties.loadSetting(null,
                    null);
            this.setSetting(setting);
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * R|[lg̏B
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        GridBagConstraints gridBagConstraints74 = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 0, 0, 5), 0, 0);
        gridBagConstraints74.gridwidth = 2;
        GridBagConstraints gridBagConstraints73 = new GridBagConstraints();
        gridBagConstraints73.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints73.gridy = 6;
        gridBagConstraints73.weightx = 1.0;
        gridBagConstraints73.gridwidth = 4;
        gridBagConstraints73.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints73.gridx = 1;
        GridBagConstraints gridBagConstraints72 = new GridBagConstraints();
        gridBagConstraints72.gridx = 0;
        gridBagConstraints72.anchor = GridBagConstraints.WEST;
        gridBagConstraints72.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints72.fill = GridBagConstraints.NONE;
        gridBagConstraints72.gridwidth = 1;
        gridBagConstraints72.gridy = 6;
        ShadowKindLabel = new JLabel();
        ShadowKindLabel.setText("e̎");
        ShadowKindLabel.setDisplayedMnemonic(KeyEvent.VK_UNDEFINED);
        GridBagConstraints gridBagConstraints71 = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 6);
        gridBagConstraints71.fill = GridBagConstraints.BOTH;
        gridBagConstraints71.ipady = 0;
        GridBagConstraints gridBagConstraints70 = new GridBagConstraints();
        gridBagConstraints70.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints70.gridy = 1;
        gridBagConstraints70.ipadx = 0;
        gridBagConstraints70.ipady = 0;
        gridBagConstraints70.weightx = 1.0;
        gridBagConstraints70.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints70.gridx = 1;
        GridBagConstraints gridBagConstraints69 = new GridBagConstraints();
        gridBagConstraints69.gridx = 0;
        gridBagConstraints69.ipadx = 0;
        gridBagConstraints69.ipady = 0;
        gridBagConstraints69.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints69.anchor = GridBagConstraints.WEST;
        gridBagConstraints69.gridy = 1;
        GridBagConstraints gridBagConstraints68 = new GridBagConstraints();
        gridBagConstraints68.fill = GridBagConstraints.BOTH;
        gridBagConstraints68.gridy = 0;
        gridBagConstraints68.ipady = 0;
        gridBagConstraints68.weightx = 1.0;
        gridBagConstraints68.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints68.gridx = 1;
        GridBagConstraints gridBagConstraints67 = new GridBagConstraints();
        gridBagConstraints67.gridx = 0;
        gridBagConstraints67.ipadx = 0;
        gridBagConstraints67.ipady = 0;
        gridBagConstraints67.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints67.anchor = GridBagConstraints.WEST;
        gridBagConstraints67.gridy = 0;
        GridBagConstraints gridBagConstraints66 = new GridBagConstraints();
        gridBagConstraints66.gridx = 0;
        gridBagConstraints66.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints66.anchor = GridBagConstraints.WEST;
        gridBagConstraints66.gridwidth = 2;
        gridBagConstraints66.gridy = 1;
        ViewCommentLabel = new JLabel();
        ViewCommentLabel.setText("\Rg");
        GridBagConstraints gridBagConstraints65 = new GridBagConstraints();
        gridBagConstraints65.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints65.gridy = 1;
        gridBagConstraints65.weightx = 1.0;
        gridBagConstraints65.gridwidth = 6;
        gridBagConstraints65.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints65.gridx = 3;
        GridBagConstraints gridBagConstraints64 = new GridBagConstraints(1, 1,
                1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 0, 0, 5), 0, 0);
        gridBagConstraints64.gridy = 3;
        gridBagConstraints64.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints64.gridx = 4;
        GridBagConstraints gridBagConstraints63 = new GridBagConstraints(0, 4,
                2, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 5), 0, 0);
        gridBagConstraints63.gridy = 7;
        gridBagConstraints63.gridx = 0;
        gridBagConstraints63.gridwidth = 5;
        GridBagConstraints gridBagConstraints62 = new GridBagConstraints(0, 3,
                2, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0);
        gridBagConstraints62.gridy = 5;
        gridBagConstraints62.gridx = 1;
        gridBagConstraints62.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints62.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints62.gridwidth = 4;
        GridBagConstraints gridBagConstraints61 = new GridBagConstraints(0, 2,
                1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0);
        gridBagConstraints61.gridy = 5;
        gridBagConstraints61.gridx = 0;
        gridBagConstraints61.fill = GridBagConstraints.VERTICAL;
        gridBagConstraints61.anchor = GridBagConstraints.WEST;
        gridBagConstraints61.gridwidth = 1;
        GridBagConstraints gridBagConstraints60 = new GridBagConstraints(0, 1,
                1, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 5, 0, 5), 0, 0);
        gridBagConstraints60.gridy = 3;
        gridBagConstraints60.gridx = 1;
        gridBagConstraints60.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints60.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints60.gridwidth = 3;
        GridBagConstraints gridBagConstraints59 = new GridBagConstraints(0, 0,
                2, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0);
        gridBagConstraints59.gridy = 3;
        gridBagConstraints59.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints59.gridx = 0;
        gridBagConstraints59.fill = GridBagConstraints.NONE;
        gridBagConstraints59.anchor = GridBagConstraints.WEST;
        gridBagConstraints59.weightx = 0.0;
        gridBagConstraints59.gridwidth = 1;
        GridBagConstraints gridBagConstraints58 = new GridBagConstraints();
        gridBagConstraints58.gridx = 0;
        gridBagConstraints58.anchor = GridBagConstraints.WEST;
        gridBagConstraints58.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints58.gridwidth = 5;
        gridBagConstraints58.weightx = 1.0;
        gridBagConstraints58.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints58.gridy = 0;
        GridBagConstraints gridBagConstraints57 = new GridBagConstraints();
        gridBagConstraints57.fill = GridBagConstraints.BOTH;
        gridBagConstraints57.gridy = 2;
        gridBagConstraints57.weightx = 1.0;
        gridBagConstraints57.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints57.gridx = 1;
        GridBagConstraints gridBagConstraints56 = new GridBagConstraints();
        gridBagConstraints56.gridx = 0;
        gridBagConstraints56.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints56.anchor = GridBagConstraints.WEST;
        gridBagConstraints56.gridy = 2;
        ExtOptionLabel = new JLabel();
        ExtOptionLabel.setText("o͓̊gq");
        GridBagConstraints gridBagConstraints55 = new GridBagConstraints();
        gridBagConstraints55.gridx = 0;
        gridBagConstraints55.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints55.weightx = 1.0;
        gridBagConstraints55.gridwidth = 2;
        gridBagConstraints55.gridy = 1;
        GridBagConstraints gridBagConstraints54 = new GridBagConstraints(0, 2,
                2, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0);
        gridBagConstraints54.gridwidth = 3;
        GridBagConstraints gridBagConstraints53 = new GridBagConstraints(1, 3,
                2, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 0, 5, 5), 0, 0);
        gridBagConstraints53.gridy = 5;
        gridBagConstraints53.gridheight = 1;
        gridBagConstraints53.weightx = 1.0;
        gridBagConstraints53.gridwidth = 1;
        GridBagConstraints gridBagConstraints52 = new GridBagConstraints(2, 2,
                1, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 0, 5, 5), 0, 0);
        gridBagConstraints52.gridy = 4;
        gridBagConstraints52.gridwidth = 1;
        gridBagConstraints52.weightx = 1.0;
        gridBagConstraints52.gridx = 1;
        GridBagConstraints gridBagConstraints51 = new GridBagConstraints(2, 1,
                1, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 0, 5, 5), 0, 0);
        gridBagConstraints51.gridy = 3;
        gridBagConstraints51.gridwidth = 1;
        gridBagConstraints51.weightx = 1.0;
        gridBagConstraints51.gridx = 1;
        GridBagConstraints gridBagConstraints50 = new GridBagConstraints(0, 3,
                1, 1, 0.0, 0.0, GridBagConstraints.WEST,
                GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0);
        gridBagConstraints50.gridy = 5;
        GridBagConstraints gridBagConstraints49 = new GridBagConstraints(0, 2,
                2, 1, 0.0, 0.0, GridBagConstraints.WEST,
                GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0);
        gridBagConstraints49.gridy = 4;
        gridBagConstraints49.gridwidth = 1;
        GridBagConstraints gridBagConstraints48 = new GridBagConstraints(0, 1,
                1, 1, 0.0, 0.0, GridBagConstraints.WEST,
                GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0);
        gridBagConstraints48.gridy = 3;

        GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
        gridBagConstraints33.gridx = 0;
        gridBagConstraints33.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints33.weightx = 1.0;
        gridBagConstraints33.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints33.gridwidth = 5;
        gridBagConstraints33.gridy = 9;

        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 0;
        gridBagConstraints14.anchor = GridBagConstraints.WEST;
        gridBagConstraints14.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints14.weightx = 1.0;
        gridBagConstraints14.gridwidth = 5;
        gridBagConstraints14.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints14.gridy = 8;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints(0, 0,
                1, 1, 1.0, 1.0, GridBagConstraints.NORTH,
                GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 5), 0, 0);
        gridBagConstraints7.weighty = 0.0;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints6.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints6.anchor = GridBagConstraints.NORTH;
        gridBagConstraints6.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints(0, 1,
                1, 1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 5), 0, 0);
        gridBagConstraints1.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.anchor = GridBagConstraints.NORTH;
        gridBagConstraints1.weighty = 1.0;
        this.setIconImage(WinIcon);
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(borderLayout1);
        setSize(new Dimension(400, 450));
        setTitle("΂ " + VERSION);
        this.addWindowListener(new MainFrame_this_windowAdapter(this));
        statusBar.setText(" ");
        jMenuFile.setText("t@C");
        jMenuFileExit.setText("I");
        jMenuFileExit.addActionListener(new MainFrame_jMenuFileExit_ActionAdapter(
                this));
        jMenuHelp.setText("wv");
        jMenuHelpAbout.setText("o[W");
        jMenuHelpAbout.addActionListener(new MainFrame_jMenuHelpAbout_ActionAdapter(
                this));
        VideoInfoPanel.setLayout(gridBagLayout1);
        VideoID_TextField.setText("http://www.nicovideo.jp/watch/");
        DoButton.setText(DoButtonDefString);
        DoButton.addActionListener(new MainFrame_DoButton_actionAdapter(this));
        SavingInfoTabPanel.setLayout(new GridLayout());
        UserInfoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "[Uݒ"));
        UserInfoPanel.setLayout(gridBagLayout3);
        MailAddrLabel.setText("[AhX");
        PasswordLabel.setText("pX[h");

        setListenerToSavePanelButton();

        FFMpegTabPanel.setLayout(gridBagLayout6);
        PathSettingPanel.setBorder(BorderFactory.createTitledBorder(
                BorderFactory.createEtchedBorder(), "vÖʒu̐ݒ"));
        PathSettingPanel.setLayout(gridBagLayout7);
        FFmpegPathLabel.setText("FFmpeg");
        SettingFFmpegPathButton.setText("Q");
        SettingFFmpegPathButton.addActionListener(new MainFrame_SettingFFmpegPathButton_actionAdapter(
                this));
        VhookPathLabel.setText("gvhookCu");
        SettingVhookPathButton.setText("Q");
        SettingVhookPathButton.addActionListener(new MainFrame_SettingVhookPathButton_actionAdapter(
                this));
        VhookSettingPanel.setLayout(gridBagLayout8);
        VhookSettingPanel.setBorder(BorderFactory.createTitledBorder(
                BorderFactory.createEtchedBorder(), "gvhookCu̐ݒ"));
        FFmpegSettingPanel.setBorder(BorderFactory.createTitledBorder(
                BorderFactory.createEtchedBorder(), "FFmpeg̐ݒ"));
        FFmpegSettingPanel.setLayout(gridBagLayout9);
        FontPathLabel.setText("tHgpX");
        SettingFontPathButton.setText("Q");
        SettingFontPathButton.addActionListener(new MainFrame_SettingFontPathButton_actionAdapter(
                this));
        ShowConvVideoCheckBox.setText("ϊ̉摜\");
        InLabel.setText("̓IvV");
        OutLabel.setText("o̓IvV");
        MainOptionLabel.setText("CIvV");
        FontIndexLabel.setText("tHgԍ");
        VideoID_Label.setText("URL/ID");
        WayBackLabel.setText("ߋO");
        OpPanel.setLayout(new GridBagLayout());

        BasicInfoTabPanel.setLayout(gridBagLayout12);
        jMenuBar1.add(jMenuFile);
        jMenuFile.add(jMenuFileExit);
        jMenuBar1.add(jMenuHelp);
        jMenuHelp.add(jMenuHelpAbout);
        setJMenuBar(jMenuBar1);

        contentPane.add(statusBar, BorderLayout.SOUTH);
        contentPane.add(MainTabbedPane, java.awt.BorderLayout.CENTER);
        contentPane.add(VideoInfoPanel, java.awt.BorderLayout.NORTH);
        UserInfoPanel.add(PasswordField, new GridBagConstraints(1, 1, 1, 1,
                1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                new Insets(0, 5, 5, 5), 0, 0));
        UserInfoPanel.add(MailAddrField, new GridBagConstraints(1, 0, 1, 1,
                1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                new Insets(0, 5, 5, 5), 0, 0));
        UserInfoPanel.add(PasswordLabel, new GridBagConstraints(0, 1, 1, 1,
                0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE,
                new Insets(0, 5, 5, 0), 0, 0));
        UserInfoPanel.add(MailAddrLabel, new GridBagConstraints(0, 0, 1, 1,
                0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE,
                new Insets(0, 5, 5, 0), 0, 0));
        PathSettingPanel.add(FFmpegPathField, new GridBagConstraints(0, 1, 1,
                1, 1.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 5, 0, 5), 0, 0));
        PathSettingPanel.add(SettingFFmpegPathButton, gridBagConstraints74);
        PathSettingPanel.add(FFmpegPathLabel, new GridBagConstraints(0, 0, 2,
                1, 1.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE,
                new Insets(0, 5, 5, 5), 0, 0));
        PathSettingPanel.add(VhookPathField, new GridBagConstraints(0, 3, 1, 1,
                1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                new Insets(0, 5, 5, 5), 0, 0));
        PathSettingPanel.add(SettingVhookPathButton, new GridBagConstraints(1,
                3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER,
                GridBagConstraints.BOTH, new Insets(0, 0, 5, 5), 0, 0));
        PathSettingPanel.add(VhookPathLabel, gridBagConstraints54);
        FFmpegSettingPanel.add(CommandLineOutOptionField, gridBagConstraints53);
        FFmpegSettingPanel.add(CommandLineInOptionField, gridBagConstraints52);
        FFmpegSettingPanel.add(MainOptionField, gridBagConstraints51);
        FFmpegSettingPanel.add(MainOptionLabel, gridBagConstraints48);
        FFmpegSettingPanel.add(InLabel, gridBagConstraints49);
        FFmpegSettingPanel.add(OutLabel, gridBagConstraints50);
        FFmpegSettingPanel.add(getFFmpegOptionComboBoxPanel(),
                gridBagConstraints55);
        FFmpegSettingPanel.add(ExtOptionLabel, gridBagConstraints56);
        FFmpegSettingPanel.add(getExtOptionField(), gridBagConstraints57);
        VideoInfoPanel.add(DoButton, gridBagConstraints71);
        VideoInfoPanel.add(OpPanel, new GridBagConstraints(0, 0, 1, 1, 1.0,
                0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH,
                new Insets(0, 0, 0, 0), 0, 0));
        OpPanel.add(VideoID_Label, gridBagConstraints67);
        OpPanel.add(VideoID_TextField, gridBagConstraints68);
        OpPanel.add(WayBackLabel, gridBagConstraints69);
        OpPanel.add(WayBackField, gridBagConstraints70);

        MainTabbedPane.add(BasicInfoTabPanel, "{ݒ");
        MainTabbedPane.add(SavingInfoTabPanel, "ۑݒ");
        MainTabbedPane.add(FFMpegTabPanel, "ݒ");
        MainTabbedPane.addTab("ϊݒ", null, getConvertingSettingPanel(), null);
        SavingInfoTabPanel.add(savePanel);
        BasicInfoTabPanel.add(UserInfoPanel, gridBagConstraints7);
        BasicInfoTabPanel.add(getProxyInfoPanel(), gridBagConstraints6);
        VhookSettingPanel.add(FontPathLabel, gridBagConstraints59);
        VhookSettingPanel.add(ShowConvVideoCheckBox, gridBagConstraints63);
        VhookSettingPanel.add(FontPathField, gridBagConstraints60);
        VhookSettingPanel.add(FontIndexField, gridBagConstraints62);
        VhookSettingPanel.add(FontIndexLabel, gridBagConstraints61);
        VhookSettingPanel.add(SettingFontPathButton, gridBagConstraints64);
        VhookSettingPanel.add(getFixFontSizeCheckBox(), gridBagConstraints14);
        VhookSettingPanel.add(getOpaqueCommentCheckBox(), gridBagConstraints33);
        VhookSettingPanel.add(getNotUseVhookCheckBox(), gridBagConstraints58);
        VhookSettingPanel.add(getViewCommentField(), gridBagConstraints65);
        VhookSettingPanel.add(ViewCommentLabel, gridBagConstraints66);
        VhookSettingPanel.add(ShadowKindLabel, gridBagConstraints72);
        VhookSettingPanel.add(getShadowComboBox(), gridBagConstraints73);

        FFMpegTabPanel.add(PathSettingPanel, new GridBagConstraints(0, 0, 1, 1,
                1.0, 0.0, GridBagConstraints.NORTHEAST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 5), 0, 0));
        FFMpegTabPanel.add(FFmpegSettingPanel, gridBagConstraints1);
    }

    /**
     * ۑݒpl̃{^ɃANVXi蓖Ă.
     */
    private void setListenerToSavePanelButton() {
        ActionListener al;
        al = new InputVideoPanelButtonListener();
        videoSaveInfoPanel.getShowSavingVideoFolderDialogButton().addActionListener(al);
        videoSaveInfoPanel.getShowSavingVideoFileDialogButton().addActionListener(al);
        videoSaveInfoPanel.getNibrFileChooserButton().addActionListener(al);

        al = new VideoUseRadioButtonListener();
        videoSaveInfoPanel.getVideoNoSaveButton().addActionListener(al);
        videoSaveInfoPanel.getVideoSaveButton().addActionListener(al);
        videoSaveInfoPanel.getVideoUseNiBrButton().addActionListener(al);

        al = new InputCommentPanelButtonListener();
        savePanel.getShowSavingCommentFolderDialogButton().addActionListener(al);
        savePanel.getShowSavingCommentFileDialogButton().addActionListener(al);

        al = new OutputVideoPanelButtonListener();
        savePanel.getShowSavingConvertedVideoFolderDialogButton().addActionListener(al);
        savePanel.getShowSavingConvertedVideoFileDialogButton().addActionListener(al);
    }

    private void setPopup() {
        MainOptionField.addMouseListener(new PopupRightClick(
                this.MainOptionField));
        CommandLineInOptionField.addMouseListener(new PopupRightClick(
                this.CommandLineInOptionField));
        CommandLineOutOptionField.addMouseListener(new PopupRightClick(
                this.CommandLineOutOptionField));
        savePanel.getCommentNumField().addMouseListener(new PopupRightClick(
                savePanel.getCommentNumField()));

        savePanel.getCommentSavedFileField().addMouseListener(new PopupRightClick(
                savePanel.getCommentSavedFileField()));
        savePanel.getCommentSavedFolderField().addMouseListener(new PopupRightClick(
                savePanel.getCommentSavedFolderField()));

        savePanel.getConvertedVideoSavedFileField().addMouseListener(new PopupRightClick(
                savePanel.getConvertedVideoSavedFileField()));
        savePanel.getConvertedVideoSavedFolderField().addMouseListener(new PopupRightClick(
                savePanel.getConvertedVideoSavedFolderField()));

        videoSaveInfoPanel.getVideoSavedFileField().addMouseListener(new PopupRightClick(
                videoSaveInfoPanel.getVideoSavedFileField()));
        videoSaveInfoPanel.getVideoSavedFolderField().addMouseListener(new PopupRightClick(
                videoSaveInfoPanel.getVideoSavedFolderField()));
        videoSaveInfoPanel.getNibrFileField().addMouseListener(
                new PopupRightClick(videoSaveInfoPanel.getNibrFileField()));

        FFmpegPathField.addMouseListener(new PopupRightClick(
                this.FFmpegPathField));
        VhookPathField.addMouseListener(new PopupRightClick(this.VhookPathField));
        VideoID_TextField.addMouseListener(new PopupRightClick(
                this.VideoID_TextField));
        ViewCommentField.addMouseListener(new PopupRightClick(
                this.ViewCommentField));
        FontPathField.addMouseListener(new PopupRightClick(this.FontPathField));
        MailAddrField.addMouseListener(new PopupRightClick(this.MailAddrField));
        PasswordField.addMouseListener(new PopupRightClick(this.PasswordField));
        WayBackField.addMouseListener(new PopupRightClick(this.WayBackField));

        ProxyTextField.addMouseListener(new PopupRightClick(this.ProxyTextField));
        ProxyPortTextField.addMouseListener(new PopupRightClick(
                this.ProxyPortTextField));

        FontIndexField.addMouseListener(new PopupRightClick(this.FontIndexField));

        NGWordTextField.addMouseListener(new PopupRightClick(
                this.NGWordTextField));
        NGIDTextField.addMouseListener(new PopupRightClick(this.NGIDTextField));
    }

    private void setDropTarget() {
        addTarget(videoSaveInfoPanel.getVideoSavedFileField(), false);
        addTarget(videoSaveInfoPanel.getVideoSavedFolderField(), true);
        addTarget(videoSaveInfoPanel.getNibrFileField(), false);

        addTarget(savePanel.getCommentSavedFileField(), false);
        addTarget(savePanel.getCommentSavedFolderField(), true);

        addTarget(savePanel.getConvertedVideoSavedFileField(), false);
        addTarget(savePanel.getConvertedVideoSavedFolderField(), true);

        addTarget(FFmpegPathField, false);
        addTarget(VhookPathField, false);
        addTarget(FontPathField, false);

    }

    /**
     * eLXgtB[hɑ΂hbvsꍇɃt@C̓fBNg̕ݒł悤ɂ.
     * @param c ݒΏۂ̃eLXgtB[hIuWFNg.
     * @param isDir fBNgݒ肷ꍇtrue, t@C̏ꍇfalse.
     * @return hbv^[Qbg(pr).
     */
    private DropTarget addTarget(JTextField c, boolean isDir) {
        return new DropTarget(c, DnDConstants.ACTION_COPY, new FileDropTarget(
                c, isDir), true);
    }
    private File CurrentDir = new File(".");
    JPanel PathSettingPanel = new JPanel();
    JLabel FFmpegPathLabel = new JLabel();
    GridBagLayout gridBagLayout7 = new GridBagLayout();
    JTextField FFmpegPathField = new JTextField();
    JButton SettingFFmpegPathButton = new JButton();
    JLabel VhookPathLabel = new JLabel();
    JTextField VhookPathField = new JTextField();
    JButton SettingVhookPathButton = new JButton();
    JPanel VhookSettingPanel = new JPanel();
    GridBagLayout gridBagLayout8 = new GridBagLayout();
    JPanel FFmpegSettingPanel = new JPanel();
    GridBagLayout gridBagLayout9 = new GridBagLayout();
    JLabel FontPathLabel = new JLabel();
    JTextField FontPathField = new JTextField();
    JButton SettingFontPathButton = new JButton();
    JCheckBox ShowConvVideoCheckBox = new JCheckBox();
    JTextField CommandLineOutOptionField = new JTextField();

    private void showSaveDialog(String title, JTextField field, boolean isSave,
            boolean isDir) {
        JFileChooser chooser = new JFileChooser(CurrentDir);
        chooser.setDialogTitle(title);
        int code = 0;
        if (isDir) {
            chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        }
        if (isSave) {
            code = chooser.showSaveDialog(this);
        } else {
            code = chooser.showOpenDialog(this);
        }
        if (code == JFileChooser.APPROVE_OPTION) {
            if (isDir) {
                CurrentDir = chooser.getCurrentDirectory();
                field.setText(CurrentDir.getAbsolutePath());
            } else {
                File selected = chooser.getSelectedFile();
                CurrentDir = chooser.getCurrentDirectory();
                field.setText(selected.getAbsolutePath());
            }
        }
    }

    private SProperties getSetting() {
        SProperties setting = new SProperties(
                getBasicSetting(),
                getInputVideoSetting(),
                getInputCommentSetting(),
                getTcommentSetting(),
                getOutputVideoSetting(),
                getMovieSetting(),
                getConvertSetting());
        return setting;
    }

    /**
     * ݒʂɔf.
     * @param setting fݒ.
     */
    private void setSetting(SProperties setting) {
        // {ݒ
        final BasicSetting basic = setting.getBasicSetting();
        tempDir = basic.getTempDir();
        MailAddrField.setText(basic.getUser().getMail());
        PasswordField.setText(basic.getUser().getPassword());
        // vLV֘A
        UseProxyCheckBox.setSelected(basic.isProxyUse());
        ProxyTextField.setText(basic.getProxyHost());
        int proxy_port = basic.getProxyPort();
        if (proxy_port >= 0 && proxy_port <= 65535) {
            ProxyPortTextField.setText(Integer.toString(proxy_port));
        } else {
            ProxyPortTextField.setText("");
        }

        // ۑݒ - ͓
        final InputVideoSetting inVideo = setting.getInputVideoSetting();
        JRadioButton activeButton;
        switch (inVideo.getProcessKind()) {
            case NO_SAVE:
                activeButton = videoSaveInfoPanel.getVideoNoSaveButton();
                break;
            case NICOBROWSER:
                activeButton = videoSaveInfoPanel.getVideoUseNiBrButton();
                break;
            case SAVE:
            default:
                activeButton = videoSaveInfoPanel.getVideoSaveButton();
                break;
        }
        activeButton.doClick();

        videoSaveInfoPanel.getVideoSavedFileField().setText(inVideo.getFile().getPath());
        videoSaveInfoPanel.getVideoSavedFolderField().setText(inVideo.getFolder().getPath());
        videoSaveInfoPanel.getDelVideoCheckBox().setSelected(inVideo.isDeleteAfterConvert());
        final boolean videoFixName = inVideo.isAutoNaming();
        videoSaveInfoPanel.getSaveFileRadioButton().setSelected(!videoFixName);
        videoSaveInfoPanel.getSaveFolderRadioButton().setSelected(videoFixName);
        videoSaveInfoPanel.getNibrFileField().setText(inVideo.getNicoBrowserFile().getPath());

        // ۑݒ - ̓Rg
        final InputCommentSetting inputComment = setting.getInputCommentSetting();
        savePanel.getSavingCommentCheckBox().setSelected(inputComment.getProcessKind());
        savePanel.getCommentSavedFileField().setText(inputComment.getFile().getPath());
        savePanel.getDelCommentCheckBox().setSelected(inputComment.isDeleteAfterConvert());
        savePanel.getCommentSavedFolderField().setText(inputComment.getFolder().getPath());
        savePanel.getCommentNumField().setText(Integer.toString(inputComment.getNumOfComment()));
        savePanel.getFixCommentNumCheckBox().setSelected(inputComment.isSelfAdjustNumOfComment());
        boolean commentFixName = inputComment.isAutoNaming();
        savePanel.getCommentSaveFileRadioButton().setSelected(!commentFixName);
        savePanel.getCommentSaveFolderRadioButton().setSelected(commentFixName);

        // e҃Rg
        InputTcommentSetting tcom = setting.getInputTcommentSetting();
        savePanel.setTcommentDownload(tcom.getProcessKind());
        savePanel.setTcommentDelete(tcom.isDeleteAfterConvert());
        savePanel.setTcommentAutoFileName(tcom.isAutoNaming());
        savePanel.setTcommentDirectoryName(tcom.getFolder().getPath());
        savePanel.setTcommentFileName(tcom.getFile().getPath());

        // ۑݒ - o̓Rgt
        final OutputVideoSetting outputVideo = setting.getOutputVideoSetting();
        savePanel.getSavingConvertedVideoCheckBox().setSelected(outputVideo.getProcessKind());
        savePanel.getAddCommentCheckBox().setSelected(outputVideo.isAddComment());
        savePanel.getAddTcommentCheckBox().setSelected(outputVideo.isAddTcomment());
        savePanel.getConvertedVideoSavedFileField().setText(outputVideo.getFile().getPath());
        savePanel.getConvertedVideoSavedFolderField().setText(outputVideo.getFolder().getPath());
        savePanel.getNotAddVideoIdConvVideoCheckBox().setSelected(outputVideo.isCutIdName());
        boolean convFixName = outputVideo.isAutoNaming();
        savePanel.getConvSaveFileRadioButton().setSelected(!convFixName);
        savePanel.getConvSaveFolderRadioButton().setSelected(convFixName);

        // ݒ
        final MovieSetting movie = setting.getMovieSetting();
        FFmpegPathField.setText(movie.getFfmpeg().toString());
        VhookPathField.setText(movie.getVhook().toString());
        ExtOptionField.setText(movie.getFfmpegOption().getExtOption());
        MainOptionField.setText(movie.getFfmpegOption().getMainOption());
        CommandLineOutOptionField.setText(movie.getFfmpegOption().getOutOption());
        CommandLineInOptionField.setText(movie.getFfmpegOption().getInOption());
        FFmpegOptionModel.reload(movie.getOptionFile());

        // ϊݒ
        final ConvertSetting conv = setting.getConvertSetting();
        NotUseVhookCheckBox.setSelected(conv.isVhookDisabled());
        ViewCommentField.setText(Integer.toString(conv.getMaxNumOfComment()));
        FontPathField.setText(conv.getFont().toString());
        FontIndexField.setText(Integer.toString(conv.getFontIndex()));
        ShadowComboBox.setSelectedIndex(conv.getShadowIndex());
        ShowConvVideoCheckBox.setSelected(conv.isShowConverting());
        FixFontSizeCheckBox.setSelected(conv.isSelfAdjustFontSize());
        OpaqueCommentCheckBox.setSelected(conv.isCommentOpaque());
        NGWordTextField.setText(conv.getNgSetting().getWord());
        NGIDTextField.setText(conv.getNgSetting().getId());
    }

    /**
     * [t@C|I] ANVs܂B
     *
     * @param actionEvent
     *            ActionEvent
     */
    void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        SProperties setting = getSetting();
        SProperties.saveSetting(setting);
        System.exit(0);
    }

    /**
     * [wv|o[W] ANVs܂B
     *
     * @param actionEvent
     *            ActionEvent
     */
    void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        MainFrame_AboutBox dlg = new MainFrame_AboutBox(this);
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
    }

    /* ϊEۑ */
    Converter Converter = null;
    JTextField CommandLineInOptionField = new JTextField();
    JLabel InLabel = new JLabel();
    JLabel OutLabel = new JLabel();
    JLabel MainOptionLabel = new JLabel();
    JTextField MainOptionField = new JTextField();
    JLabel FontIndexLabel = new JLabel();
    JTextField FontIndexField = new JTextField();
    JLabel VideoID_Label = new JLabel();
    JLabel WayBackLabel = new JLabel();
    JTextField WayBackField = new JTextField();
    GridBagLayout gridBagLayout10 = new GridBagLayout();
    GridBagLayout gridBagLayout11 = new GridBagLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel OpPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel BasicInfoTabPanel = new JPanel();
    GridBagLayout gridBagLayout12 = new GridBagLayout();
    private JPanel ConvertingSettingPanel = null;
    private JPanel NGWordSettingPanel = null;
    private JLabel NGWordLavel = null;
    private JTextField NGWordTextField = null;
    private JLabel NGIDLabel = null;
    private JTextField NGIDTextField = null;
    private JPanel ProxyInfoPanel = null;
    private JLabel ProxyLabel = null;
    private JTextField ProxyTextField = null;
    private JLabel ProxyPortLabel = null;
    private JTextField ProxyPortTextField = null;
    private JCheckBox UseProxyCheckBox = null;
    private JCheckBox FixFontSizeCheckBox = null;
    private JCheckBox OpaqueCommentCheckBox = null;
    private final SavePanel savePanel = new SavePanel();
    private final VideoSaveInfoPanel videoSaveInfoPanel;
    private JComboBox FFmpegOptionComboBox = null;
    private JButton FFmpegOptionReloadButton = null;
    private JPanel FFmpegOptionComboBoxPanel = null;

    public void DoButton_actionPerformed(ActionEvent e) {
        if (Converter == null || Converter.isConverted()) {
            try {
                executeConvert();
            } catch (Exception ex) {
                String text = ex.getMessage();
                if (StringUtils.isEmpty(text)) {
                    text = "\ȂG[̂ߒf܂B";
                }
                ex.printStackTrace();
                statusBar.setText(text);
            }
        } else { /* JnĂ̂ŁAXgbvB */
            final ConvertStopFlag flag = Converter.getStopFlag();
            if (!flag.needStop()) { /* ܂XgbvĂȂB */
                flag.requestStop();
            }
        }
    }

    private void executeConvert() throws IOException {
        String url;

        // NicoBrowsert@C𗘗pꍇ́At@CrfIID.
        if (videoSaveInfoPanel.getVideoUseNiBrButton().isSelected()) {
            try {
                String fileName = videoSaveInfoPanel.getNibrFileField().getText();
                NicoDBFinder finder = NicoDBFinder.getInstance();
                NicoContent info = finder.findNicoContent(fileName);
                if (info != null) {
                    url = info.getNicoId();
                } else {
                    url = "";
                }
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "G[", JOptionPane.ERROR_MESSAGE);
                return;
            }
        } else {
            url = VideoID_TextField.getText();
        }

        TextProgressListener sl = new TextProgressListener() {

            public void setText(final String text) {
                SwingUtilities.invokeLater(new Runnable() {

                    public void run() {
                        statusBar.setText(text);
                    }
                });
            }
        };

        ConvertStopFlag.StateChangeListener scl = new ConvertStopFlag.StateChangeListener() {

            public void changeState(final State s) {
                SwingUtilities.invokeLater(new Runnable() {

                    public void run() {
                        switch (s) {
                            case STOPPING:
                                DoButton.setText(DoButtonWaitString);
                                break;
                            case FINISHED:
                                DoButton.setText(DoButtonDefString);
                        }
                    }
                });
            }
        };

        Converter = new Converter(url, WayBackField.getText(), getSetting().toProfile(), sl,
                new ConvertStopFlag(scl));
        DoButton.setText(DoButtonStopString);
        new Thread(Converter).start();

    }

    /* FFmpegւ̃pX */
    public void SettingFFmpegPathButton_actionPerformed(ActionEvent e) {
        showSaveDialog("FFmpegւ̃pX", FFmpegPathField, false, false);
    }

    public void SettingVhookPathButton_actionPerformed(ActionEvent e) {
        showSaveDialog("gvhookCuւ̃pX", VhookPathField, false, false);
    }

    public void SettingFontPathButton_actionPerformed(ActionEvent e) {
        showSaveDialog("tHgւ̃pX", FontPathField, false, false);
    }

    public void this_windowClosing(WindowEvent e) {
        this.jMenuFileExit_actionPerformed(null);
    }

    /**
     * This method initializes ConvertingSettingPanel
     *
     * @return javax.swing.JPanel
     */
    private JPanel getConvertingSettingPanel() {
        if (ConvertingSettingPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = GridBagConstraints.NORTH;
            gridBagConstraints11.fill = GridBagConstraints.HORIZONTAL;
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0,
                    2, 1, 1, 1.0, 1.0, GridBagConstraints.NORTH,
                    GridBagConstraints.HORIZONTAL, new Insets(0, 5, 0, 5), 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = GridBagConstraints.CENTER;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridy = 0;
            ConvertingSettingPanel = new JPanel();
            ConvertingSettingPanel.setLayout(new GridBagLayout());
            ConvertingSettingPanel.add(getNGWordSettingPanel(),
                    gridBagConstraints11);
            ConvertingSettingPanel.add(VhookSettingPanel, gridBagConstraints);
        }
        return ConvertingSettingPanel;
    }

    /**
     * This method initializes NGWordSettingPanel
     *
     * @return javax.swing.JPanel
     */
    private JPanel getNGWordSettingPanel() {
        if (NGWordSettingPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = GridBagConstraints.HORIZONTAL;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = GridBagConstraints.WEST;
            gridBagConstraints4.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints4.gridy = 1;
            NGIDLabel = new JLabel();
            NGIDLabel.setText("NG ID");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = GridBagConstraints.HORIZONTAL;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints2.gridy = 0;
            NGWordLavel = new JLabel();
            NGWordLavel.setText("NG[h");
            NGWordSettingPanel = new JPanel();
            NGWordSettingPanel.setLayout(new GridBagLayout());
            NGWordSettingPanel.setBorder(BorderFactory.createTitledBorder(null,
                    "NG[hEIDݒ"));
            NGWordSettingPanel.add(NGWordLavel, gridBagConstraints2);
            NGWordSettingPanel.add(getNGWordTextField(), gridBagConstraints3);
            NGWordSettingPanel.add(NGIDLabel, gridBagConstraints4);
            NGWordSettingPanel.add(getNGIDTextField(), gridBagConstraints5);
        }
        return NGWordSettingPanel;
    }

    /**
     * This method initializes NGWordTextField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getNGWordTextField() {
        if (NGWordTextField == null) {
            NGWordTextField = new JTextField();
        }
        return NGWordTextField;
    }

    /**
     * This method initializes NGIDTextField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getNGIDTextField() {
        if (NGIDTextField == null) {
            NGIDTextField = new JTextField();
        }
        return NGIDTextField;
    }

    /**
     * This method initializes ProxyInfoPanel
     *
     * @return javax.swing.JPanel
     */
    private JPanel getProxyInfoPanel() {
        if (ProxyInfoPanel == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridwidth = 2;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.fill = GridBagConstraints.HORIZONTAL;
            gridBagConstraints13.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints13.gridy = 0;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = GridBagConstraints.HORIZONTAL;
            gridBagConstraints12.gridy = 2;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints12.gridx = 1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints10.gridy = 2;
            ProxyPortLabel = new JLabel();
            ProxyPortLabel.setText("|[gԍ");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = GridBagConstraints.BOTH;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints8.fill = GridBagConstraints.NONE;
            gridBagConstraints8.anchor = GridBagConstraints.EAST;
            gridBagConstraints8.gridy = 1;
            ProxyLabel = new JLabel();
            ProxyLabel.setText("vLV");
            ProxyInfoPanel = new JPanel();
            ProxyInfoPanel.setLayout(new GridBagLayout());
            ProxyInfoPanel.setBorder(BorderFactory.createTitledBorder(null,
                    "vLVݒ"));
            ProxyInfoPanel.add(ProxyLabel, gridBagConstraints8);
            ProxyInfoPanel.add(getProxyTextField(), gridBagConstraints9);
            ProxyInfoPanel.add(ProxyPortLabel, gridBagConstraints10);
            ProxyInfoPanel.add(getProxyPortTextField(), gridBagConstraints12);
            ProxyInfoPanel.add(getUseProxyCheckBox(), gridBagConstraints13);
        }
        return ProxyInfoPanel;
    }

    /**
     * This method initializes ProxyTextField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getProxyTextField() {
        if (ProxyTextField == null) {
            ProxyTextField = new JTextField();
        }
        return ProxyTextField;
    }

    /**
     * This method initializes ProxyPortTextField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getProxyPortTextField() {
        if (ProxyPortTextField == null) {
            ProxyPortTextField = new JTextField();
        }
        return ProxyPortTextField;
    }

    /**
     * This method initializes UseProxyCheckBox
     *
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getUseProxyCheckBox() {
        if (UseProxyCheckBox == null) {
            UseProxyCheckBox = new JCheckBox();
            UseProxyCheckBox.setText("vLVg");
        }
        return UseProxyCheckBox;
    }

    /**
     * This method initializes FixFontSizeCheckBox
     *
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getFixFontSizeCheckBox() {
        if (FixFontSizeCheckBox == null) {
            FixFontSizeCheckBox = new JCheckBox();
            FixFontSizeCheckBox.setText("tHgTCYʂɂ킹Ď");
        }
        return FixFontSizeCheckBox;
    }

    /**
     * This method initializes OpaqueCommentCheckBox
     *
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getOpaqueCommentCheckBox() {
        if (OpaqueCommentCheckBox == null) {
            OpaqueCommentCheckBox = new JCheckBox();
            OpaqueCommentCheckBox.setText("SẴRgsɂ");
        }
        return OpaqueCommentCheckBox;
    }
    /**
     * This method initializes FFmpegOptionComboBox
     *
     * @return javax.swing.JComboBox
     */
    private final OptionComboBoxModel FFmpegOptionModel = new OptionComboBoxModel();
    private JLabel ExtOptionLabel = null;
    private JTextField ExtOptionField = null;
    private JCheckBox NotUseVhookCheckBox = null;
    private JTextField ViewCommentField = null;
    private JLabel ViewCommentLabel = null;
    private JLabel ShadowKindLabel = null;
    private JComboBox ShadowComboBox = null;

    private JComboBox getFFmpegOptionComboBox() {
        if (FFmpegOptionComboBox == null) {
            FFmpegOptionComboBox = new JComboBox(FFmpegOptionModel);
            FFmpegOptionComboBox.addActionListener(new java.awt.event.ActionListener() {

                public void actionPerformed(java.awt.event.ActionEvent e) {
                    if (FFmpegOptionModel.isFile()) {// t@C
                        ExtOptionField.setEnabled(false);
                        MainOptionField.setEnabled(false);
                        CommandLineInOptionField.setEnabled(false);
                        CommandLineOutOptionField.setEnabled(false);
                    } else {// t@CłȂ
                        ExtOptionField.setEnabled(true);
                        MainOptionField.setEnabled(true);
                        CommandLineInOptionField.setEnabled(true);
                        CommandLineOutOptionField.setEnabled(true);
                    }
                }
            });
        }
        return FFmpegOptionComboBox;
    }

    /**
     * This method initializes FFmpegOptionReloadButton
     *
     * @return javax.swing.JButton
     */
    private JButton getFFmpegOptionReloadButton() {
        if (FFmpegOptionReloadButton == null) {
            FFmpegOptionReloadButton = new JButton();
            FFmpegOptionReloadButton.setText("XV");
            FFmpegOptionReloadButton.addActionListener(new java.awt.event.ActionListener() {

                public void actionPerformed(java.awt.event.ActionEvent e) {
                    FFmpegOptionModel.reload();
                }
            });
        }
        return FFmpegOptionReloadButton;
    }

    /**
     * This method initializes FFmpegOptionComboBoxPanel
     *
     * @return javax.swing.JPanel
     */
    private JPanel getFFmpegOptionComboBoxPanel() {
        if (FFmpegOptionComboBoxPanel == null) {
            GridBagConstraints gridBagConstraints47 = new GridBagConstraints();
            gridBagConstraints47.fill = GridBagConstraints.BOTH;
            gridBagConstraints47.gridx = -1;
            gridBagConstraints47.gridy = -1;
            gridBagConstraints47.insets = new Insets(0, 0, 5, 5);
            GridBagConstraints gridBagConstraints46 = new GridBagConstraints();
            gridBagConstraints46.fill = GridBagConstraints.HORIZONTAL;
            gridBagConstraints46.gridwidth = 3;
            gridBagConstraints46.gridx = -1;
            gridBagConstraints46.gridy = -1;
            gridBagConstraints46.weightx = 1.0;
            gridBagConstraints46.insets = new Insets(0, 5, 5, 5);
            FFmpegOptionComboBoxPanel = new JPanel();
            FFmpegOptionComboBoxPanel.setLayout(new GridBagLayout());
            FFmpegOptionComboBoxPanel.add(getFFmpegOptionComboBox(),
                    gridBagConstraints46);
            FFmpegOptionComboBoxPanel.add(getFFmpegOptionReloadButton(),
                    gridBagConstraints47);
        }
        return FFmpegOptionComboBoxPanel;
    }

    /**
     * This method initializes ExtOptionField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getExtOptionField() {
        if (ExtOptionField == null) {
            ExtOptionField = new JTextField();
        }
        return ExtOptionField;
    }

    /**
     * This method initializes NotUseVhookCheckBox
     *
     * @return javax.swing.JCheckBox
     */
    private JCheckBox getNotUseVhookCheckBox() {
        if (NotUseVhookCheckBox == null) {
            NotUseVhookCheckBox = new JCheckBox();
            NotUseVhookCheckBox.setText("gvhookCu𖳌ɂifobOpj");
        }
        return NotUseVhookCheckBox;
    }

    /**
     * This method initializes ViewCommentField
     *
     * @return javax.swing.JTextField
     */
    private JTextField getViewCommentField() {
        if (ViewCommentField == null) {
            ViewCommentField = new JTextField();
        }
        return ViewCommentField;
    }

    /**
     * This method initializes ShadowComboBox
     *
     * @return javax.swing.JComboBox
     */
    private JComboBox getShadowComboBox() {
        if (ShadowComboBox == null) {
            ShadowComboBox = new JComboBox(SProperties.ShadowKindArray);
        }
        return ShadowComboBox;
    }

    private BasicSetting getBasicSetting() {
        String mail = MailAddrField.getText();
        String pass = String.valueOf(PasswordField.getPassword());
        boolean proxyUse = UseProxyCheckBox.isSelected();
        String proxyHost = ProxyTextField.getText();
        int proxyPort;
        try {
            proxyPort = Integer.parseInt(ProxyPortTextField.getText());
        } catch (NumberFormatException e) {
            proxyPort = -1;
        }
        // TODO ƗpfBNg̐ݒGUI
        return new BasicSetting(tempDir, mail, pass, proxyUse, proxyHost, proxyPort);
    }

    private InputVideoSetting getInputVideoSetting() {
        VideoSaveKind kind;
        if (videoSaveInfoPanel.getVideoNoSaveButton().isSelected() == true) {
            kind = VideoSaveKind.NO_SAVE;
        } else if (videoSaveInfoPanel.getVideoUseNiBrButton().isSelected() == true) {
            kind = VideoSaveKind.NICOBROWSER;
        } else {
            kind = VideoSaveKind.SAVE;
        }
        boolean autoNaming = videoSaveInfoPanel.getSaveFolderRadioButton().isSelected();
        String folder = videoSaveInfoPanel.getVideoSavedFolderField().getText();
        String file = videoSaveInfoPanel.getVideoSavedFileField().getText();
        boolean delete = videoSaveInfoPanel.getDelVideoCheckBox().isSelected();
        String nibrFile = videoSaveInfoPanel.getNibrFileField().getText();

        return new InputVideoSetting(kind, autoNaming, new File(folder), new File(file), delete, new File(nibrFile));
    }

    private InputCommentSetting getInputCommentSetting() {
        boolean download = savePanel.getSavingCommentCheckBox().isSelected();
        String file = savePanel.getCommentSavedFileField().getText();
        int back_comment;
        try {
            back_comment = Integer.parseInt(savePanel.getCommentNumField().getText());
        } catch (NumberFormatException ex) {
            back_comment = 500;
        }
        boolean delete = savePanel.getDelCommentCheckBox().isSelected();
        boolean autoNaming = savePanel.getCommentSaveFolderRadioButton().isSelected();
        String folder = savePanel.getCommentSavedFolderField().getText();
        boolean adjustNumOfCom = savePanel.getFixCommentNumCheckBox().isSelected();

        return new InputCommentSetting(download, autoNaming, new File(folder), new File(file), delete, adjustNumOfCom,
                back_comment);
    }

    /**
     * ʓ͒l瓊e҃Rgݒ쐬.
     * @return 쐬e҃Rgݒ.
     */
    private InputTcommentSetting getTcommentSetting() {
        boolean down = savePanel.isTcommentDownload();
        boolean del = savePanel.isTcommentDelete();
        boolean naming = savePanel.isTcommentAutoFileName();
        String dir = savePanel.getTcommentDirectoryName();
        String f = savePanel.getTcommentFileName();
        return new InputTcommentSetting(down, naming, dir, f, del);
    }

    private OutputVideoSetting getOutputVideoSetting() {
        boolean process = savePanel.getSavingConvertedVideoCheckBox().isSelected();
        boolean addComment = savePanel.getAddCommentCheckBox().isSelected();
        boolean addTcomment = savePanel.getAddTcommentCheckBox().isSelected();
        String file = savePanel.getConvertedVideoSavedFileField().getText();
        boolean cutId = savePanel.getNotAddVideoIdConvVideoCheckBox().isSelected();
        boolean autoNaming = savePanel.getConvSaveFolderRadioButton().isSelected();
        String folder = savePanel.getConvertedVideoSavedFolderField().getText();

        return new OutputVideoSetting(process, autoNaming, new File(folder), new File(file), cutId, addComment,
                addTcomment);
    }

    private MovieSetting getMovieSetting() {
        String ffmpeg = FFmpegPathField.getText();
        String vhook = VhookPathField.getText();
        String ext = ExtOptionField.getText();
        String main = MainOptionField.getText();
        String in = CommandLineInOptionField.getText();
        String out = CommandLineOutOptionField.getText();
        File optionFile = FFmpegOptionModel.getSelectedFile();

        FfmpegOption opt = new FfmpegOption(ext, main, in, out);
        return new MovieSetting(new File(ffmpeg), new File(vhook), optionFile, opt);
    }

    private ConvertSetting getConvertSetting() {
        boolean vhookDisabled = NotUseVhookCheckBox.isSelected();
        int maxComment = 30;
        try {
            maxComment = Integer.parseInt(ViewCommentField.getText());
        } catch (NumberFormatException ex) {
        }
        File font = new File(FontPathField.getText());
        int fontIndex = Integer.parseInt(FontIndexField.getText());
        int shadowIndex = ShadowComboBox.getSelectedIndex();
        boolean showConv = ShowConvVideoCheckBox.isSelected();
        boolean adjustFont = FixFontSizeCheckBox.isSelected();
        boolean commentOpaque = OpaqueCommentCheckBox.isSelected();
        NgSetting ngSetting = new NgSetting(NGWordTextField.getText(), NGIDTextField.getText());

        return new ConvertSetting(vhookDisabled, maxComment, font, fontIndex, shadowIndex, showConv, adjustFont,
                commentOpaque, ngSetting);
    }

    private class InputVideoPanelButtonListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            final Object source = e.getSource();
            final VideoSaveInfoPanel panel = videoSaveInfoPanel;
            String title;
            JTextField field;
            boolean isSave;
            boolean isDir;

            if (source == panel.getShowSavingVideoFolderDialogButton()) {
                title = "̕ۑ(tH_)";
                field = panel.getVideoSavedFolderField();
                isSave = true;
                isDir = true;
            } else if (source == panel.getShowSavingVideoFileDialogButton()) {
                title = "̕ۑ(t@C)";
                field = panel.getVideoSavedFileField();
                isSave = true;
                isDir = false;
            } else if (source == panel.getNibrFileChooserButton()) {
                title = "NicoBrowsert@CI";
                field = panel.getNibrFileField();
                isSave = false;
                isDir = false;
            } else {
                return;
            }
            showSaveDialog(title, field, isSave, isDir);
        }
    }

    private class InputCommentPanelButtonListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            final Object source = e.getSource();
            String title;
            JTextField field;
            boolean isSave;
            boolean isDir;
            if (source == savePanel.getShowSavingCommentFolderDialogButton()) {
                title = "Rg̕ۑ(tH_)";
                field = savePanel.getCommentSavedFolderField();
                isSave = true;
                isDir = true;
            } else if (source == savePanel.getShowSavingCommentFolderDialogButton()) {
                title = "Rg̕ۑ(t@C)";
                field = savePanel.getCommentSavedFileField();
                isSave = true;
                isDir = false;
            } else {
                return;
            }
            showSaveDialog(title, field, isSave, isDir);
        }
    }

    private class OutputVideoPanelButtonListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            final Object source = e.getSource();
            String title;
            JTextField field;
            boolean isSave;
            boolean isDir;
            if (source == savePanel.getShowSavingConvertedVideoFolderDialogButton()) {
                title = "Rgt̕ۑ(tH_)";
                field = savePanel.getConvertedVideoSavedFolderField();
                isSave = true;
                isDir = true;
            } else if (source == savePanel.getShowSavingConvertedVideoFileDialogButton()) {
                title = "Rgt̕ۑ(t@C)";
                field = savePanel.getConvertedVideoSavedFileField();
                isSave = true;
                isDir = false;
            } else {
                return;
            }
            showSaveDialog(title, field, isSave, isDir);
        }
    }

    private class VideoUseRadioButtonListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == videoSaveInfoPanel.getVideoUseNiBrButton()) {
                maskExt();
            } else {
                maskBase();
            }
        }

        private void maskBase() {
            mask(true);
        }

        private void maskExt() {
            mask(false);
        }

        private void mask(boolean b) {
            final VideoSaveInfoPanel panel = videoSaveInfoPanel;
            VideoID_TextField.setEditable(b);
            panel.getDelVideoCheckBox().setEnabled(b);

            panel.getSaveFolderRadioButton().setEnabled(b);
            panel.getVideoSavedFolderField().setEnabled(b);
            panel.getShowSavingVideoFolderDialogButton().setEnabled(b);

            panel.getSaveFileRadioButton().setEnabled(b);
            panel.getVideoSavedFileField().setEnabled(b);
            panel.getShowSavingVideoFileDialogButton().setEnabled(b);

            panel.getNibrFileField().setEnabled(!b);
            panel.getNibrFileChooserButton().setEnabled(!b);
        }
    }
}

class MainFrame_this_windowAdapter extends WindowAdapter {

    private MainFrame adaptee;

    MainFrame_this_windowAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        adaptee.this_windowClosing(e);
    }
}

class MainFrame_SettingFontPathButton_actionAdapter implements ActionListener {

    private MainFrame adaptee;

    MainFrame_SettingFontPathButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.SettingFontPathButton_actionPerformed(e);
    }
}

class MainFrame_SettingVhookPathButton_actionAdapter implements ActionListener {

    private MainFrame adaptee;

    MainFrame_SettingVhookPathButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.SettingVhookPathButton_actionPerformed(e);
    }
}

class MainFrame_SettingFFmpegPathButton_actionAdapter implements ActionListener {

    private MainFrame adaptee;

    MainFrame_SettingFFmpegPathButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.SettingFFmpegPathButton_actionPerformed(e);
    }
}

class MainFrame_DoButton_actionAdapter implements ActionListener {

    private MainFrame adaptee;

    MainFrame_DoButton_actionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.DoButton_actionPerformed(e);
    }
}

class MainFrame_jMenuFileExit_ActionAdapter implements ActionListener {

    MainFrame adaptee;

    MainFrame_jMenuFileExit_ActionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        adaptee.jMenuFileExit_actionPerformed(actionEvent);
    }
}

class MainFrame_jMenuHelpAbout_ActionAdapter implements ActionListener {

    MainFrame adaptee;

    MainFrame_jMenuHelpAbout_ActionAdapter(MainFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        adaptee.jMenuHelpAbout_actionPerformed(actionEvent);
    }
}
