function init(){
	// 詳細情報をajaxでリクエスト, 表示する処理を挿入.
	$("div[id^=name]").each(function(){
		var name = this
		var link = $(name).children("a")
		var href = link.attr("href")

		// 標準のリンク動作を止める
		$(link).click(function(event){
			event.preventDefault()
		})
		// 1回目のクリックはサーバへデータ要求
		$(link).bind("click", function(event){
			$.ajax({type:"GET", url:href, cache:false,
			success:function(data,textStatus){
				var place = $(name).children("div[class=detail]")
				place.html(data)
				$(link).unbind()
				
				// 2回目以降のクリック動作. 表示をトグルする.
				$(link).click(function(event){
					event.preventDefault()
				})
				$(link).bind("click", function(event){
					place.toggle()
				})
			},
			error:function(XMLHttpRequest,textStatus,errorThrown){}});
			return false;
		})
	})
	
	// 取得リンク押下時のリクエストを非同期で行う
	$("div[id^=get]").each(function(){
		var get = this
		var pattern = /get(.+)/
		var id = get.id.match(pattern)[1]
		var link = $(get).children("a")
		var href = link.attr("href")
		
		$(link).click(function(event){
			event.preventDefault()
			$(get).hide()
			$.ajax({type:"GET", url:href, cache:false,
			success:function(data,textStatus){
				var place = $("div[id=state"+id+"]")
				$(place).text("◎")
			},
			error:function(XMLHttpRequest,textStatus,errorThrown){}})
			return false
		})
		
	})

	// トランスコードステータスの取得
	$("div[id^=state]").each(function(){
		var state = this
		var pattern = /state(.+)/
		var id = state.id.match(pattern)[1]

		$(state).click(function(event){
			$.ajax({type:"GET", url:"/coroid/nicoContent/state/"+id, cache:false, dataType:'json',
			success:function(data,textStatus){
				$(state).html(data.status)
				if(data.playUrl){
					$('#play'+id).html('<a href="'+data.playUrl+'">&#x25B7;</a>')
				}
			},
			error:function(XMLHttpRequest,textStatus,errorThrown){}})
			return false
		})
	})
}
