/*$Id: NicoContent.java 319 2010-05-24 04:52:59Z yuki $*/
package nicobrowser.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Version;

/**
 * ニコニコ動画コンテンツ情報.
 */
@Entity
public class NicoContent implements java.io.Serializable {

    public enum Status {

        GET_INFO, GET_LOW, GET_FILE
    }
    private static final long serialVersionUID = 1L;
    private Long id;
    private Long version;
    private String nicoId;
    private String pageLink;
    private String title;
    private String fileName;
    private Status status = Status.GET_INFO;
    private int failTimes;
    private boolean convertedMp3;
    private boolean convertedMp4;
    private String author;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Version
    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    @Column(nullable = false)
    public String getNicoId() {
        return nicoId;
    }

    protected void setNicoId(String nicoId) {
        this.nicoId = nicoId;
    }

    public String getPageLink() {
        return pageLink;
    }

    public void setPageLink(String pageLink) {
        this.pageLink = pageLink;
        String[] elm = pageLink.split("/");
        setNicoId(elm[elm.length - 1]);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Column(nullable = false)
    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getFailTimes() {
        return failTimes;
    }

    public void setFailTimes(int failTimes) {
        this.failTimes = failTimes;
    }

    @Column(nullable = false)
    public boolean isConvertedMp3() {
        return convertedMp3;
    }

    public void setConvertedMp3(boolean convertedMp3) {
        this.convertedMp3 = convertedMp3;
    }

    @Column(nullable = false)
    public boolean isConvertedMp4() {
        return convertedMp4;
    }

    public void setConvertedMp4(boolean convertedMp4) {
        this.convertedMp4 = convertedMp4;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof NicoContent)) {
            return false;
        }
        NicoContent other = (NicoContent) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return new String(getTitle() + ": " + getPageLink());
    }
}
