/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.impl.auth.UnsupportedDigestAlgorithmException;
import org.apache.http.message.BasicHeaderValueFormatter;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;

@NotThreadSafe
public class DigestScheme
extends RFC2617Scheme {
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private boolean complete = false;
    private static final String NC = "00000001";
    private static final int QOP_MISSING = 0;
    private static final int QOP_AUTH_INT = 1;
    private static final int QOP_AUTH = 2;
    private int qopVariant = 0;
    private String cnonce;

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        if (this.getParameter("realm") == null) {
            throw new MalformedChallengeException("missing realm in challange");
        }
        if (this.getParameter("nonce") == null) {
            throw new MalformedChallengeException("missing nonce in challange");
        }
        boolean unsupportedQop = false;
        String qop = this.getParameter("qop");
        if (qop != null) {
            StringTokenizer tok = new StringTokenizer(qop, ",");
            while (tok.hasMoreTokens()) {
                String variant = tok.nextToken().trim();
                if (variant.equals("auth")) {
                    this.qopVariant = 2;
                    break;
                }
                if (variant.equals("auth-int")) {
                    this.qopVariant = 1;
                    continue;
                }
                unsupportedQop = true;
            }
        }
        if (unsupportedQop && this.qopVariant == 0) {
            throw new MalformedChallengeException("None of the qop methods is supported");
        }
        this.cnonce = null;
        this.complete = true;
    }

    public boolean isComplete() {
        String s = this.getParameter("stale");
        if ("true".equalsIgnoreCase(s)) {
            return false;
        }
        return this.complete;
    }

    public String getSchemeName() {
        return "digest";
    }

    public boolean isConnectionBased() {
        return false;
    }

    public void overrideParamter(String name, String value) {
        this.getParameters().put(name, value);
    }

    private String getCnonce() {
        if (this.cnonce == null) {
            this.cnonce = DigestScheme.createCnonce();
        }
        return this.cnonce;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.getParameters().put("methodname", request.getRequestLine().getMethod());
        this.getParameters().put("uri", request.getRequestLine().getUri());
        String charset = this.getParameter("charset");
        if (charset == null) {
            charset = AuthParams.getCredentialCharset(request.getParams());
            this.getParameters().put("charset", charset);
        }
        String digest = this.createDigest(credentials);
        return this.createDigestHeader(credentials, digest);
    }

    private static MessageDigest createMessageDigest(String digAlg) throws UnsupportedDigestAlgorithmException {
        try {
            return MessageDigest.getInstance(digAlg);
        }
        catch (Exception e) {
            throw new UnsupportedDigestAlgorithmException("Unsupported algorithm in HTTP Digest authentication: " + digAlg);
        }
    }

    private String createDigest(Credentials credentials) throws AuthenticationException {
        String serverDigestValue;
        String charset;
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String nonce = this.getParameter("nonce");
        String method = this.getParameter("methodname");
        String algorithm = this.getParameter("algorithm");
        if (uri == null) {
            throw new IllegalStateException("URI may not be null");
        }
        if (realm == null) {
            throw new IllegalStateException("Realm may not be null");
        }
        if (nonce == null) {
            throw new IllegalStateException("Nonce may not be null");
        }
        if (algorithm == null) {
            algorithm = "MD5";
        }
        if ((charset = this.getParameter("charset")) == null) {
            charset = "ISO-8859-1";
        }
        if (this.qopVariant == 1) {
            throw new AuthenticationException("Unsupported qop in HTTP Digest authentication");
        }
        String digAlg = algorithm;
        if (digAlg.equalsIgnoreCase("MD5-sess")) {
            digAlg = "MD5";
        }
        MessageDigest digester = DigestScheme.createMessageDigest(digAlg);
        String uname = credentials.getUserPrincipal().getName();
        String pwd = credentials.getPassword();
        StringBuilder tmp = new StringBuilder(uname.length() + realm.length() + pwd.length() + 2);
        tmp.append(uname);
        tmp.append(':');
        tmp.append(realm);
        tmp.append(':');
        tmp.append(pwd);
        String a1 = tmp.toString();
        if (algorithm.equalsIgnoreCase("MD5-sess")) {
            algorithm = "MD5";
            String cnonce = this.getCnonce();
            String tmp2 = DigestScheme.encode(digester.digest(EncodingUtils.getBytes((String)a1, (String)charset)));
            StringBuilder tmp3 = new StringBuilder(tmp2.length() + nonce.length() + cnonce.length() + 2);
            tmp3.append(tmp2);
            tmp3.append(':');
            tmp3.append(nonce);
            tmp3.append(':');
            tmp3.append(cnonce);
            a1 = tmp3.toString();
        }
        String hasha1 = DigestScheme.encode(digester.digest(EncodingUtils.getBytes((String)a1, (String)charset)));
        String a2 = null;
        if (this.qopVariant != 1) {
            a2 = method + ':' + uri;
        }
        String hasha2 = DigestScheme.encode(digester.digest(EncodingUtils.getAsciiBytes(a2)));
        if (this.qopVariant == 0) {
            StringBuilder tmp2 = new StringBuilder(hasha1.length() + nonce.length() + hasha1.length());
            tmp2.append(hasha1);
            tmp2.append(':');
            tmp2.append(nonce);
            tmp2.append(':');
            tmp2.append(hasha2);
            serverDigestValue = tmp2.toString();
        } else {
            String qopOption = this.getQopVariantString();
            String cnonce = this.getCnonce();
            StringBuilder tmp2 = new StringBuilder(hasha1.length() + nonce.length() + NC.length() + cnonce.length() + qopOption.length() + hasha2.length() + 5);
            tmp2.append(hasha1);
            tmp2.append(':');
            tmp2.append(nonce);
            tmp2.append(':');
            tmp2.append(NC);
            tmp2.append(':');
            tmp2.append(cnonce);
            tmp2.append(':');
            tmp2.append(qopOption);
            tmp2.append(':');
            tmp2.append(hasha2);
            serverDigestValue = tmp2.toString();
        }
        String serverDigest = DigestScheme.encode(digester.digest(EncodingUtils.getAsciiBytes((String)serverDigestValue)));
        return serverDigest;
    }

    private Header createDigestHeader(Credentials credentials, String digest) {
        CharArrayBuffer buffer = new CharArrayBuffer(128);
        if (this.isProxy()) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": Digest ");
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String nonce = this.getParameter("nonce");
        String opaque = this.getParameter("opaque");
        String response = digest;
        String algorithm = this.getParameter("algorithm");
        String uname = credentials.getUserPrincipal().getName();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(20);
        params.add(new BasicNameValuePair("username", uname));
        params.add(new BasicNameValuePair("realm", realm));
        params.add(new BasicNameValuePair("nonce", nonce));
        params.add(new BasicNameValuePair("uri", uri));
        params.add(new BasicNameValuePair("response", response));
        if (this.qopVariant != 0) {
            params.add(new BasicNameValuePair("qop", this.getQopVariantString()));
            params.add(new BasicNameValuePair("nc", NC));
            params.add(new BasicNameValuePair("cnonce", this.getCnonce()));
        }
        if (algorithm != null) {
            params.add(new BasicNameValuePair("algorithm", algorithm));
        }
        if (opaque != null) {
            params.add(new BasicNameValuePair("opaque", opaque));
        }
        for (int i = 0; i < params.size(); ++i) {
            BasicNameValuePair param = (BasicNameValuePair)params.get(i);
            if (i > 0) {
                buffer.append(", ");
            }
            boolean noQuotes = "nc".equals(param.getName()) || "qop".equals(param.getName());
            BasicHeaderValueFormatter.DEFAULT.formatNameValuePair(buffer, (NameValuePair)param, !noQuotes);
        }
        return new BufferedHeader(buffer);
    }

    private String getQopVariantString() {
        String qopOption = this.qopVariant == 1 ? "auth-int" : "auth";
        return qopOption;
    }

    private static String encode(byte[] binaryData) {
        int n = binaryData.length;
        char[] buffer = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }

    public static String createCnonce() {
        MessageDigest md5Helper = DigestScheme.createMessageDigest("MD5");
        String cnonce = Long.toString(System.currentTimeMillis());
        cnonce = DigestScheme.encode(md5Helper.digest(EncodingUtils.getAsciiBytes((String)cnonce)));
        return cnonce;
    }
}

