/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.url;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.cssj.resolver.SourceValidity;
import jp.cssj.resolver.helpers.AbstractSource;
import jp.cssj.resolver.url.URLSourceValidity;

public class URLSource
extends AbstractSource {
    private static final Logger LOG = Logger.getLogger(URLSource.class.getName());
    private final URL url;
    private final String encoding;
    private String mimeType = null;
    private transient URLConnection conn = null;
    private transient InputStream in = null;
    private long timestamp = -1L;

    public URLSource(URI uri, URL url, String mimeType, String encoding) {
        super(uri);
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    public URLSource(URL url, String mimeType, String encoding) throws URISyntaxException {
        this(new URI(url.toString()), url, mimeType, encoding);
    }

    public URLSource(URL url, String mimeType) throws URISyntaxException {
        this(url, mimeType, null);
    }

    public URLSource(URL url) throws URISyntaxException {
        this(url, null);
    }

    public URLSource(URI uri, String mimeType, String encoding) throws MalformedURLException {
        this(uri, uri.toURL(), mimeType, encoding);
    }

    public URLSource(URI uri, String mimeType) throws MalformedURLException {
        this(uri, uri.toURL(), mimeType, null);
    }

    public URLSource(URI uri) throws MalformedURLException {
        this(uri, uri.toURL(), null, null);
    }

    @Override
    public String getMimeType() throws IOException {
        if (this.mimeType == null) {
            String filename;
            int dot;
            if (this.isFile() && (dot = (filename = this.getFile().getName()).indexOf(46)) != -1) {
                String suffix = filename.substring(dot, filename.length());
                if (suffix.equalsIgnoreCase(".html") || suffix.equalsIgnoreCase(".htm")) {
                    this.mimeType = "text/html";
                } else if (suffix.equalsIgnoreCase(".xml") || suffix.equalsIgnoreCase(".xhtml") || suffix.equalsIgnoreCase(".xht")) {
                    this.mimeType = "text/xml";
                }
                if (this.mimeType != null) {
                    return this.mimeType;
                }
            }
            try {
                if (this.conn == null) {
                    this.connect();
                }
                this.mimeType = this.conn.getContentType();
                return this.mimeType;
            }
            catch (IOException e) {
                this.conn = null;
            }
        }
        return this.mimeType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public boolean exists() throws IOException {
        if (this.isFile()) {
            return this.getFile().exists();
        }
        return true;
    }

    @Override
    public boolean isFile() throws IOException {
        return "file".equals(this.uri.getScheme());
    }

    @Override
    public boolean isInputStream() throws IOException {
        return true;
    }

    @Override
    public boolean isReader() throws IOException {
        return this.encoding != null;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.in != null) {
            this.in = null;
            this.conn = null;
            this.timestamp = -1L;
        }
        if (this.isFile()) {
            this.in = new FileInputStream(this.getFile());
            return this.in;
        }
        if (this.conn == null) {
            this.connect();
        }
        this.in = this.conn.getInputStream();
        return this.in;
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.encoding == null) {
            throw new UnsupportedOperationException();
        }
        return new InputStreamReader(this.getInputStream(), this.encoding);
    }

    @Override
    public synchronized void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "URL\u3078\u306e\u63a5\u7d9a\u3092\u4e2d\u65ad\u3057\u305f\u969b\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
            }
            finally {
                this.in = null;
                this.conn = null;
                this.timestamp = -1L;
            }
        }
    }

    private void connect() throws IOException {
        this.conn = this.url.openConnection();
        this.timestamp = this.conn.getLastModified();
    }

    @Override
    public File getFile() {
        String path = this.uri.getPath();
        if (path == null) {
            path = this.uri.getSchemeSpecificPart();
        }
        return new File(path);
    }

    @Override
    public long getLength() throws IOException {
        if (this.isFile()) {
            return this.getFile().length();
        }
        if (this.conn == null) {
            this.connect();
        }
        return this.conn.getContentLength();
    }

    @Override
    public SourceValidity getValidity() throws IOException {
        this.connect();
        return new URLSourceValidity(this.timestamp, this.url);
    }
}

