/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.cssj.resolver.Source;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;

class SourceBody
extends AbstractContentBody {
    protected final Source source;

    public SourceBody(Source source) throws IOException {
        super(source.getMimeType() == null ? ContentType.APPLICATION_OCTET_STREAM : ContentType.create(source.getMimeType()));
        this.source = source;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = this.source.getInputStream();){
            IOUtils.copy(in, out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getFilename() {
        return null;
    }

    @Override
    public String getCharset() {
        try {
            return this.source.getEncoding();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public long getContentLength() {
        try {
            return this.source.getLength();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public String getTransferEncoding() {
        return "8bit";
    }
}

