/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.rest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.TranscoderException;
import jp.cssj.cti2.helpers.AbstractCTISession;
import jp.cssj.cti2.message.MessageHandler;
import jp.cssj.cti2.progress.ProgressListener;
import jp.cssj.cti2.results.Results;
import jp.cssj.driver.rest.SourceBody;
import jp.cssj.resolver.MetaSource;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.file.FileSource;
import jp.cssj.resolver.helpers.MetaSourceImpl;
import jp.cssj.rsr.RandomBuilder;
import jp.cssj.rsr.Sequential;
import jp.cssj.rsr.helpers.RandomBuilderOutputStream;
import jp.cssj.rsr.helpers.SequentialOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RestSession
extends AbstractCTISession
implements CTISession {
    protected static final String CHARSET = "UTF-8";
    protected static final ContentType NIO_CHARSET = ContentType.DEFAULT_TEXT.withCharset("UTF-8");
    protected final String uri;
    protected final String user;
    protected final String password;
    protected Results results = null;
    protected SourceResolver resolver = null;
    protected boolean continuous = false;
    protected MessageHandler messageHandler = null;
    protected ProgressListener progressListener = null;
    protected List<NameValuePair> props = new ArrayList<NameValuePair>();
    protected int state = 1;
    protected RandomBuilder builder = null;
    protected HttpClient client;
    protected final DocumentBuilder docBuilder;
    protected final String sessionId;
    protected long srcRead = 0L;
    protected long srcLength = 0L;
    protected Collection<URI> resultSet = new HashSet<URI>();

    public RestSession(URI uri, String user, String password) throws IOException {
        HttpGet method;
        Element message;
        String code;
        this.uri = uri.toString();
        this.user = user;
        this.password = password;
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (uri.getScheme().equals("https")) {
            try {
                SSLContext ssl;
                if (System.getProperty("jp.cssj.driver.tls.trust", "true").equalsIgnoreCase("true")) {
                    ssl = SSLContextBuilder.create().loadTrustMaterial(new TrustSelfSignedStrategy()).build();
                    builder.setSSLContext(ssl);
                    SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(ssl, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    builder.setSSLSocketFactory(sslsf);
                } else {
                    ssl = SSLContextBuilder.create().build();
                    builder.setSSLContext(ssl);
                }
            }
            catch (Exception e) {
                RestSession.IOException(e);
            }
        }
        this.client = builder.build();
        try {
            this.docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        if (this.user != null) {
            list.add(new BasicNameValuePair("rest.user", this.user));
        }
        if (this.password != null) {
            list.add(new BasicNameValuePair("rest.password", this.password));
        }
        if (!"1012".equals(code = (message = this.getMessage(method = new HttpGet(String.valueOf(this.uri) + "open?" + URLEncodedUtils.format(list, CHARSET)))).getAttribute("code"))) {
            throw new SecurityException(message.getFirstChild().getNodeValue());
        }
        this.sessionId = message.getFirstChild().getNodeValue();
    }

    public void setHttpClient(HttpClient client) {
        this.client = client;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    private static IOException IOException(Throwable cause) throws IOException {
        IOException e = new IOException();
        e.initCause(cause);
        return e;
    }

    private Reader getReader(HttpUriRequest req) throws IOException {
        return new InputStreamReader(this.getInputStream(req), CHARSET);
    }

    private InputStream getInputStream(HttpUriRequest req) throws IOException {
        HttpResponse res = this.client.execute(req);
        HttpEntity entity = res.getEntity();
        return entity.getContent();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document parseResponse(HttpUriRequest req) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Reader reader = this.getReader(req);){
            InputSource source = new InputSource(reader);
            source.setSystemId(req.getURI().toString());
            Document document = this.docBuilder.parse(source);
            {
                catch (SAXException e) {
                    req.abort();
                    throw RestSession.IOException(e);
                }
            }
            return document;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private Element getMessage(HttpUriRequest method) throws IOException {
        Document doc = this.parseResponse(method);
        NodeList nl = doc.getElementsByTagName("message");
        if (nl == null || nl.getLength() == 0) {
            throw new IOException();
        }
        return (Element)nl.item(0);
    }

    @Override
    public InputStream getServerInfo(URI uri) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        list.add(new BasicNameValuePair("rest.id", this.sessionId));
        list.add(new BasicNameValuePair("rest.uri", uri.toString()));
        HttpGet req = new HttpGet(String.valueOf(this.uri) + "info?" + URLEncodedUtils.format(list, CHARSET));
        return this.getInputStream(req);
    }

    @Override
    public void setResults(Results results) throws IOException {
        this.results = results;
    }

    @Override
    public void setMessageHandler(MessageHandler eh) {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.messageHandler = eh;
    }

    @Override
    public void setProgressListener(ProgressListener l) {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.progressListener = l;
    }

    @Override
    public void property(String key, String value) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.props.add(new BasicNameValuePair(key, value));
    }

    @Override
    public void setSourceResolver(SourceResolver resolver) throws IOException {
        this.resolver = resolver;
    }

    @Override
    public void setContinuous(boolean continuous) throws IOException {
        this.continuous = continuous;
    }

    private void resourceNotFound(URI uri) throws IOException {
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        list.add(new BasicNameValuePair("rest.id", this.sessionId));
        list.add(new BasicNameValuePair("rest.uri", uri.toString()));
        list.add(new BasicNameValuePair("rest.notFound", "yes"));
        HttpGet method = new HttpGet(String.valueOf(this.uri) + "resources?" + URLEncodedUtils.format(list, CHARSET));
        Element message = this.getMessage(method);
        String code = message.getAttribute("code");
        if (!"1011".equals(code)) {
            throw new IOException(message.getFirstChild().getNodeValue());
        }
    }

    @Override
    public OutputStream resource(final MetaSource metaSource) throws IOException {
        final File file = File.createTempFile("copper-rest-rsrc-", ".dat");
        file.deleteOnExit();
        return new FilterOutputStream(new FileOutputStream(file)){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try (FileSource source = new FileSource(file, metaSource.getURI(), metaSource.getMimeType(), metaSource.getEncoding());){
                        RestSession.this.resource(source);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                finally {
                    file.delete();
                }
            }
        };
    }

    @Override
    public void resource(Source source) throws IOException {
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        list.add(new BasicNameValuePair("rest.id", this.sessionId));
        list.add(new BasicNameValuePair("rest.uri", source.getURI().toString()));
        if (source.getMimeType() != null) {
            list.add(new BasicNameValuePair("rest.mimeType", source.getMimeType()));
        }
        if (source.getEncoding() != null) {
            list.add(new BasicNameValuePair("rest.encoding", source.getEncoding()));
        }
        HttpPost method = new HttpPost(String.valueOf(this.uri) + "resources?" + URLEncodedUtils.format(list, CHARSET));
        HttpEntity entity = MultipartEntityBuilder.create().addPart("rest.resource", new SourceBody(source)).build();
        method.setEntity(entity);
        Element message = this.getMessage(method);
        String code = message.getAttribute("code");
        if (!"1011".equals(code)) {
            throw new IOException(message.getFirstChild().getNodeValue());
        }
    }

    private void waitResults() throws IOException, TranscoderException {
        Element message;
        do {
            Attr arg;
            NodeList progressList;
            URI uri;
            String[] args;
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            list.add(new BasicNameValuePair("rest.id", this.sessionId));
            list.add(new BasicNameValuePair("rest.wait", "5000"));
            HttpPost method = new HttpPost(String.valueOf(this.uri) + "messages?" + URLEncodedUtils.format(list, CHARSET));
            Document doc = this.parseResponse(method);
            NodeList messages = doc.getElementsByTagName("message");
            message = (Element)messages.item(0);
            if (this.messageHandler != null) {
                int i = 1;
                while (i < messages.getLength()) {
                    Attr arg2;
                    Element m = (Element)messages.item(i);
                    short code = (short)Integer.parseInt(m.getAttribute("code"), 16);
                    Text textNode = (Text)m.getFirstChild();
                    ArrayList<String> argsList = new ArrayList<String>();
                    int j = 0;
                    while ((arg2 = m.getAttributeNode("arg" + j)) != null) {
                        argsList.add(arg2.getValue());
                        ++j;
                    }
                    args = argsList.toArray(new String[argsList.size()]);
                    String text = textNode == null ? null : textNode.getNodeValue();
                    this.messageHandler.message(code, args, text);
                    ++i;
                }
            }
            if (this.resolver != null) {
                NodeList resources = doc.getElementsByTagName("resource");
                int i = 0;
                while (i < resources.getLength()) {
                    Source source;
                    Element resource = (Element)resources.item(i);
                    uri = URI.create(resource.getAttribute("uri"));
                    try {
                        source = this.resolver.resolve(uri);
                    }
                    catch (IOException e) {
                        this.resourceNotFound(uri);
                        source = null;
                    }
                    if (source != null) {
                        try {
                            if (source.exists()) {
                                this.resource(source);
                            } else {
                                this.resourceNotFound(uri);
                            }
                        }
                        finally {
                            this.resolver.release(source);
                        }
                    }
                    ++i;
                }
            }
            if (this.progressListener != null && (progressList = doc.getElementsByTagName("progressList")).getLength() > 0) {
                long srcRead;
                Attr read;
                long srcLength;
                Element progress = (Element)progressList.item(0);
                Attr length = progress.getAttributeNode("length");
                if (length != null && this.srcLength != (srcLength = Long.parseLong(length.getValue()))) {
                    this.srcLength = srcLength;
                    this.progressListener.sourceLength(this.srcLength);
                }
                if ((read = progress.getAttributeNode("read")) != null && this.srcRead != (srcRead = Long.parseLong(read.getValue()))) {
                    this.srcRead = srcRead;
                    this.progressListener.progress(this.srcLength);
                }
            }
            NodeList results = doc.getElementsByTagName("result");
            int i = 0;
            while (i < results.getLength()) {
                Element result = (Element)results.item(i);
                uri = URI.create(result.getAttribute("uri"));
                if (!this.resultSet.contains(uri)) {
                    this.resultSet.add(uri);
                    Attr mimeType = result.getAttributeNode("mimeType");
                    Attr encoding = result.getAttributeNode("encoding");
                    Attr length = result.getAttributeNode("length");
                    MetaSourceImpl metaSource = new MetaSourceImpl(uri, mimeType == null ? null : mimeType.getValue(), encoding == null ? null : encoding.getValue(), length == null ? -1L : Long.parseLong(length.getValue()));
                    RandomBuilder builder = this.results.nextBuilder(metaSource);
                    this.result(builder, uri);
                }
                ++i;
            }
            NodeList interruptedList = doc.getElementsByTagName("interrupted");
            if (interruptedList.getLength() <= 0) continue;
            Element m = (Element)interruptedList.item(0);
            short code = (short)Integer.parseInt(m.getAttribute("code"), 16);
            Text text = (Text)m.getFirstChild();
            args = new ArrayList();
            int j = 0;
            while ((arg = m.getAttributeNode("arg" + j)) != null) {
                args.add(arg.getValue());
                ++j;
            }
            throw new TranscoderException(results.getLength() > 0 ? (byte)1 : 2, code, args.toArray(new String[args.size()]), text == null ? null : text.getNodeValue());
        } while ("1013".equals(message.getAttribute("code")));
    }

    private void result(RandomBuilder builder, URI uri) throws IOException {
        OutputStream out = builder instanceof Sequential ? new SequentialOutputStream((Sequential)builder) : new RandomBuilderOutputStream(builder, 0);
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        list.add(new BasicNameValuePair("rest.id", this.sessionId));
        list.add(new BasicNameValuePair("rest.uri", uri.toString()));
        HttpGet req = new HttpGet(String.valueOf(this.uri) + "result?" + URLEncodedUtils.format(list, CHARSET));
        HttpResponse res = this.client.execute(req);
        HttpEntity entity = res.getEntity();
        Throwable throwable = null;
        Object var9_10 = null;
        try (InputStream in = entity.getContent();){
            IOUtils.copy(in, out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void transcode(URI uri) throws IOException, TranscoderException {
        if (this.results == null) {
            throw new IllegalStateException("Results\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.state = 2;
        try {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            list.add(new BasicNameValuePair("rest.id", this.sessionId));
            list.add(new BasicNameValuePair("rest.async", "true"));
            if (this.resolver != null) {
                list.add(new BasicNameValuePair("rest.requestResource", "true"));
            }
            if (this.continuous) {
                list.add(new BasicNameValuePair("rest.continuous", "true"));
            }
            HttpPost method = new HttpPost(String.valueOf(this.uri) + "transcode?" + URLEncodedUtils.format(list, CHARSET));
            list.clear();
            list.addAll(this.props);
            this.props.clear();
            list.add(new BasicNameValuePair("rest.mainURI", uri.toString()));
            method.setEntity(new UrlEncodedFormEntity(list, CHARSET));
            Element message = this.getMessage(method);
            String code = message.getAttribute("code");
            if (!"1011".equals(code)) {
                throw new IOException(message.getFirstChild().getNodeValue());
            }
            this.resultSet.clear();
            this.waitResults();
        }
        finally {
            this.state = 1;
        }
    }

    @Override
    public OutputStream transcode(final MetaSource metaSource) throws IOException, TranscoderException {
        final File file = File.createTempFile("copper-rest-main-", ".dat");
        file.deleteOnExit();
        return new FilterOutputStream(new FileOutputStream(file)){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try (FileSource source = new FileSource(file, metaSource.getURI(), metaSource.getMimeType(), metaSource.getEncoding());){
                        RestSession.this.transcode(source);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                finally {
                    file.delete();
                }
            }
        };
    }

    @Override
    public void transcode(Source source) throws IOException, TranscoderException {
        if (this.results == null) {
            throw new IllegalStateException("Results\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.state = 2;
        try {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            list.add(new BasicNameValuePair("rest.id", this.sessionId));
            list.add(new BasicNameValuePair("rest.async", "true"));
            if (this.resolver != null) {
                list.add(new BasicNameValuePair("rest.requestResource", "true"));
            }
            if (this.continuous) {
                list.add(new BasicNameValuePair("rest.continuous", "true"));
            }
            HttpPost method = new HttpPost(String.valueOf(this.uri) + "transcode?" + URLEncodedUtils.format(list, CHARSET));
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            int i = 0;
            while (i < this.props.size()) {
                BasicNameValuePair param = (BasicNameValuePair)this.props.get(i);
                builder.addPart(param.getName(), new StringBody(param.getValue(), NIO_CHARSET));
                ++i;
            }
            this.props.clear();
            builder.addPart("rest.uri", new StringBody(source.getURI().toString(), NIO_CHARSET));
            if (source.getMimeType() != null) {
                builder.addPart("rest.mimeType", new StringBody(source.getMimeType(), NIO_CHARSET));
            }
            if (source.getEncoding() != null) {
                builder.addPart("rest.encoding", new StringBody(source.getEncoding(), NIO_CHARSET));
            }
            builder.addPart("rest.main", new SourceBody(source));
            method.setEntity(builder.build());
            Element message = this.getMessage(method);
            String code = message.getAttribute("code");
            if (!"1011".equals(code)) {
                throw new IOException(message.getFirstChild().getNodeValue());
            }
            this.resultSet.clear();
            this.waitResults();
        }
        finally {
            this.state = 1;
        }
    }

    @Override
    public void join() throws IOException {
        if (this.results == null) {
            throw new IllegalStateException("Results\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.state = 2;
        try {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            list.add(new BasicNameValuePair("rest.id", this.sessionId));
            HttpGet method = new HttpGet(String.valueOf(this.uri) + "join?" + URLEncodedUtils.format(list, CHARSET));
            Element message = this.getMessage(method);
            String code = message.getAttribute("code");
            if (!"1011".equals(code)) {
                throw new IOException(message.getFirstChild().getNodeValue());
            }
            this.waitResults();
        }
        finally {
            this.state = 1;
        }
    }

    @Override
    public void abort(byte mode) throws IOException {
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        list.add(new BasicNameValuePair("rest.id", this.sessionId));
        list.add(new BasicNameValuePair("rest.mode", String.valueOf(mode)));
        HttpGet method = new HttpGet(String.valueOf(this.uri) + "abort?" + URLEncodedUtils.format(list, CHARSET));
        Element message = this.getMessage(method);
        String code = message.getAttribute("code");
        if (!"1011".equals(code)) {
            throw new IOException(message.getFirstChild().getNodeValue());
        }
    }

    @Override
    public void reset() throws IOException {
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        list.add(new BasicNameValuePair("rest.id", this.sessionId));
        HttpGet method = new HttpGet(String.valueOf(this.uri) + "reset?" + URLEncodedUtils.format(list, CHARSET));
        Element message = this.getMessage(method);
        String code = message.getAttribute("code");
        if (!"1011".equals(code)) {
            throw new IOException(message.getFirstChild().getNodeValue());
        }
        this.resolver = null;
        this.continuous = false;
        this.results = null;
        this.state = 1;
        this.builder = null;
        this.props.clear();
        this.resultSet.clear();
        this.srcRead = 0L;
        this.srcLength = 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.state >= 3) {
            return;
        }
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        list.add(new BasicNameValuePair("rest.id", this.sessionId));
        HttpGet method = new HttpGet(String.valueOf(this.uri) + "close?" + URLEncodedUtils.format(list, CHARSET));
        Element message = this.getMessage(method);
        String code = message.getAttribute("code");
        if (!"1011".equals(code)) {
            throw new IOException(message.getFirstChild().getNodeValue());
        }
        this.state = 3;
    }
}

