/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip.v1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.helpers.AbstractCTISession;
import jp.cssj.cti2.message.MessageHandler;
import jp.cssj.cti2.progress.ProgressListener;
import jp.cssj.cti2.results.Results;
import jp.cssj.driver.ctip.v1.V1ContentProducer;
import jp.cssj.driver.ctip.v1.V1RequestConsumer;
import jp.cssj.driver.ctip.v1.V1RequestConsumerOutputStream;
import jp.cssj.resolver.MetaSource;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.helpers.MetaSourceImpl;
import jp.cssj.rsr.RandomBuilder;

public class V1Session
extends AbstractCTISession
implements CTISession {
    public static final int BUFFER_SIZE = 1024;
    private final byte[] buff1 = new byte[1024];
    private final byte[] buff2 = new byte[1024];
    protected final URI uri;
    protected final String encoding;
    protected final String user;
    protected final String password;
    protected V1ContentProducer producer = null;
    protected V1RequestConsumer request = null;
    protected Results results = null;
    protected RandomBuilder builder = null;
    protected MessageHandler messageHandler = null;
    protected ProgressListener progressListener = null;
    protected int state = 1;
    protected long srcPos = 0L;

    public V1Session(URI uri, String encoding, String user, String password) throws IOException {
        this.uri = uri;
        this.encoding = encoding;
        this.user = user == null ? "" : user;
        this.password = password == null ? "" : password;
    }

    protected void init() throws IOException {
        if (this.producer == null) {
            this.producer = new V1ContentProducer(this.uri, this.encoding);
            this.request = this.producer.connect();
            this.request.setCTIPSession(this);
            this.request.property("ctip.auth", "PLAIN:" + this.user + '\n' + this.password);
            this.producer.next();
            if (this.producer.getType() != 3) {
                throw new IOException("\u4e0d\u6b63\u306a\u30ec\u30b9\u30dd\u30f3\u30b9\u3067\u3059:" + this.producer.getType());
            }
            String[] response = this.producer.getArgs();
            if (!response[0].equals("OK")) {
                throw new SecurityException("\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + response);
            }
            this.srcPos = 0L;
        }
    }

    @Override
    public InputStream getServerInfo(URI uri) throws IOException {
        return new ByteArrayInputStream("CTIP/1.0".getBytes("ISO-8859-1"));
    }

    @Override
    public void setResults(Results results) throws IOException {
        this.results = results;
    }

    @Override
    public void setMessageHandler(MessageHandler eh) {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.messageHandler = eh;
    }

    @Override
    public void setProgressListener(ProgressListener l) {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.progressListener = l;
    }

    @Override
    public void property(String key, String value) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.init();
        this.request.property(key, value);
    }

    @Override
    public OutputStream resource(MetaSource metaSource) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.init();
        this.request.resource(metaSource.getURI(), metaSource.getMimeType(), metaSource.getEncoding());
        return new V1RequestConsumerOutputStream(this.request);
    }

    @Override
    public void resource(Source source) throws IOException {
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.init();
        this.request.resource(source.getURI(), source.getMimeType(), source.getEncoding());
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = source.getInputStream();){
            int len = in.read(this.buff1, 0, this.buff1.length);
            while (len != -1) {
                this.request.write(this.buff1, 0, len);
                len = in.read(this.buff1, 0, this.buff1.length);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OutputStream transcode(MetaSource metaSource) throws IOException {
        if (this.results == null) {
            throw new IllegalStateException("Results\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.state >= 2) {
            throw new IllegalStateException("\u65e2\u306b\u672c\u4f53\u304c\u5909\u63db\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.init();
        this.request.main(metaSource.getURI(), metaSource.getMimeType(), metaSource.getEncoding());
        this.state = 2;
        this.builder = this.results.nextBuilder(null);
        return new V1RequestConsumerOutputStream(this.request){

            @Override
            public void close() throws IOException {
                try {
                    V1Session.this.request.end();
                    while (V1Session.this.buildNext()) {
                    }
                    V1Session.this.builder.finish();
                }
                finally {
                    V1Session.this.builder.dispose();
                    V1Session.this.state = 3;
                }
            }
        };
    }

    @Override
    public void transcode(URI uri) throws IOException {
        this.property("ctip.main", uri.toString());
        this.state = 2;
        this.request.end();
        this.builder = this.results.nextBuilder(null);
        try {
            while (this.buildNext()) {
            }
            this.builder.finish();
        }
        finally {
            this.builder.dispose();
        }
        this.state = 3;
    }

    @Override
    public void transcode(Source source) throws IOException {
        if (this.results == null) {
            throw new IllegalStateException("Results\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.init();
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream out = this.transcode(new MetaSourceImpl(source));){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (InputStream in = source.getInputStream();){
                int len = in.read(this.buff1);
                while (len != -1) {
                    out.write(this.buff1, 0, len);
                    len = in.read(this.buff1);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public void setContinuous(boolean continuous) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void join() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean buildNext() throws IOException {
        if (this.producer.next()) {
            switch (this.producer.getType()) {
                case 1: {
                    this.builder.addBlock();
                    break;
                }
                case 2: {
                    int anchorId = this.producer.getAnchorId();
                    this.builder.insertBlockBefore(anchorId);
                    break;
                }
                case 4: {
                    long srcPos;
                    int id = this.producer.getId();
                    if (this.progressListener != null && this.srcPos != (srcPos = this.producer.getProgress())) {
                        this.progressListener.progress(srcPos);
                        this.srcPos = srcPos;
                    }
                    int len = this.producer.read(this.buff2, 0, this.buff2.length);
                    while (len != -1) {
                        this.builder.write(id, this.buff2, 0, len);
                        len = this.producer.read(this.buff2, 0, this.buff2.length);
                    }
                    break;
                }
                case 3: {
                    if (this.messageHandler == null) break;
                    short code = this.producer.getCode();
                    String mes = this.producer.getMessage();
                    String[] args = this.producer.getArgs();
                    this.messageHandler.message(code, args, mes);
                    break;
                }
                default: {
                    throw new IOException("\u4e0d\u6b63\u306a\u30ec\u30b9\u30dd\u30f3\u30b9\u3067\u3059\u3002");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void setSourceResolver(SourceResolver resolver) {
        throw new UnsupportedOperationException();
    }

    public void sendResource(Source source) throws IOException {
        this.init();
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream out = this.resource(new MetaSourceImpl(source));){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (InputStream in = source.getInputStream();){
                int len = in.read(this.buff1);
                while (len != -1) {
                    out.write(this.buff1, 0, len);
                    len = in.read(this.buff1);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public void abort(byte mode) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() throws IOException {
        this.close();
        this.producer = null;
        this.request = null;
        this.state = 1;
    }

    @Override
    public void close() throws IOException {
        if (this.state >= 3) {
            return;
        }
        if (this.producer != null) {
            this.producer.close();
        }
        this.state = 3;
    }
}

