require File.expand_path('CTI/Driver', File.dirname(__FILE__))
=begin rdoc
:main:CTI
= CTI driver for Ruby
Version::   $Id: CTI.rb 902 2013-04-23 05:07:04Z miyabe $

RubyでCopper PDF 2.1以降にアクセスするためのドライバです。
以下のドキュメントを参照してください。

http://dl.cssj.jp/docs/copper/3.0/html/3424_ctip2_ruby.html
=end
module CTI
  module_function
=begin rdoc
指定されたURIに接続するためのドライバを返します。
 
uri:: 接続先アドレス

返り値:: CTI::Driver オブジェクト
=end
  def get_driver(uri)
    return Driver.new
  end

=begin rdoc
指定されたURIに接続し、セッションを返します。
 
uri:: 接続先アドレス
options:: 接続オプション

返り値:: CTI::Session オブジェクト
=end
  def get_session(uri, options = {}, &block)
    get_driver(uri).get_session(uri, options, &block)
  end
end