/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.HttpContext;

@Immutable
public class RequestAuthCache
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        if (authCache == null) {
            context.setAttribute("http.auth.auth-cache", new BasicAuthCache());
        } else {
            AuthScheme authScheme;
            HttpHost proxy;
            AuthScheme authScheme2;
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            HttpHost target = (HttpHost)context.getAttribute("http.target_host");
            if (target != null && (authScheme2 = authCache.get(target)) != null) {
                this.doPreemptiveAuth(target, authScheme2, (AuthState)context.getAttribute("http.auth.target-scope"), credsProvider);
            }
            if ((proxy = (HttpHost)context.getAttribute("http.proxy_host")) != null && (authScheme = authCache.get(proxy)) != null) {
                this.doPreemptiveAuth(proxy, authScheme, (AuthState)context.getAttribute("http.auth.proxy-scope"), credsProvider);
            }
        }
    }

    private void doPreemptiveAuth(HttpHost host, AuthScheme authScheme, AuthState authState, CredentialsProvider credsProvider) {
        Credentials creds;
        String schemeName = authScheme.getSchemeName();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Re-using cached '" + schemeName + "' auth scheme for " + host));
        }
        if ((creds = credsProvider.getCredentials(new AuthScope(host.getHostName(), host.getPort(), schemeName))) != null) {
            authState.setAuthScheme(authScheme);
            authState.setCredentials(creds);
        } else {
            this.log.debug((Object)"No credentials for preemptive authentication");
        }
    }
}

