/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.cti2.helpers;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import jp.cssj.cti2.helpers.CTIMessageCodes;
import jp.cssj.cti2.helpers.StreamMessageHandler;
import jp.cssj.cti2.message.MessageHandler;

public final class CTIMessageHelper {
    public static final MessageHandler STDOUT = new StreamMessageHandler(System.out);
    public static final MessageHandler STDERR = new StreamMessageHandler(System.err);
    public static final MessageHandler NULL = new MessageHandler(){

        public void message(short code, String[] args, String mes) {
        }
    };
    public static final short INFO = 1;
    public static final short WARN = 2;
    public static final short ERROR = 3;
    public static final short FATAL = 4;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(CTIMessageCodes.class.getName());

    private CTIMessageHelper() {
    }

    public static MessageHandler createStreamMessageHandler(PrintStream out) {
        return new StreamMessageHandler(out);
    }

    public static final short getLevel(short code) {
        return (short)(code >> 12 & 0xF);
    }

    public static String getFormat(short code) {
        String str = Integer.toHexString(code).toUpperCase();
        str = BUNDLE.getString(str);
        return str;
    }

    public static String toString(short code, String[] args) {
        String str = CTIMessageHelper.getFormat(code);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || args[i].length() <= 2083) continue;
                args[i] = args[i].substring(0, 2080) + "...";
            }
        }
        str = MessageFormat.format(str, args);
        return str;
    }
}

