/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.rsr.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.cssj.rsr.RandomBuilder;
import jp.cssj.rsr.helpers.IntList;

public abstract class AbstractRandomAccessFileBuilder
implements RandomBuilder {
    private static final Logger LOG = Logger.getLogger(AbstractRandomAccessFileBuilder.class.getName());
    private static final int SEGMENT_SIZE = 8192;
    private final int blockBufferSize;
    private final int totalBufferSize;
    private final int threshold;
    protected RandomAccessFile raf = null;
    protected File file = null;
    protected List frgs = null;
    protected Block first = null;
    protected Block last = null;
    protected long length = 0L;
    protected long onMemory = 0L;
    protected int segment = 0;
    private byte[] buff = null;

    public AbstractRandomAccessFileBuilder(int fragmentBufferSize, int totalBufferSize, int threshold) {
        this.blockBufferSize = fragmentBufferSize;
        this.totalBufferSize = totalBufferSize;
        this.threshold = threshold;
    }

    public AbstractRandomAccessFileBuilder() {
        this(8192, 0x200000, 1024);
    }

    protected int nextId() throws IOException {
        if (this.frgs == null) {
            this.frgs = new ArrayList();
            this.file = File.createTempFile("cssj-rsr-", ".frgs");
            this.file.deleteOnExit();
            this.raf = new RandomAccessFile(this.file, "rw");
        }
        return this.frgs.size();
    }

    protected Block getBlock(int id) throws IOException {
        return (Block)this.frgs.get(id);
    }

    protected void putBlock(int id, Block frg) {
        assert (id == this.frgs.size());
        this.frgs.add(frg);
    }

    public RandomBuilder.PositionInfo getPositionInfo() {
        final long[] idToPosition = new long[this.frgs.size()];
        long position = 0L;
        Block frg = this.first;
        while (frg != null) {
            idToPosition[frg.getId()] = position;
            position += (long)frg.getLength();
            frg = frg.next;
        }
        return new RandomBuilder.PositionInfo(){

            public long getPosition(int id) {
                long position = idToPosition[id];
                return position;
            }
        };
    }

    public boolean supportsPositionInfo() {
        return true;
    }

    public void addBlock() throws IOException {
        int id = this.nextId();
        Block bk = new Block(id);
        if (this.first == null) {
            this.first = bk;
        } else {
            this.last.next = bk;
            bk.prev = this.last;
        }
        this.putBlock(id, bk);
        this.last = bk;
    }

    public void insertBlockBefore(int anchorId) throws IOException {
        int id = this.nextId();
        Block anchor = this.getBlock(anchorId);
        Block bk = new Block(id);
        this.putBlock(id, bk);
        bk.prev = anchor.prev;
        bk.next = anchor;
        anchor.prev.next = bk;
        anchor.prev = bk;
        if (this.first == anchor) {
            this.first = bk;
        }
    }

    public void write(int id, byte[] b, int off, int len) throws IOException {
        Block frg = this.getBlock(id);
        frg.write(b, off, len);
        this.length += (long)len;
    }

    public void closeBlock(int id) throws IOException {
        Block frg = this.getBlock(id);
        frg.close();
    }

    protected void finish(OutputStream out) throws IOException {
        if (this.first == null) {
            this.clean();
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            int total = this.frgs.size();
            int onMemory = 0;
            for (int i = 0; i < total; ++i) {
                Block f = (Block)this.frgs.get(i);
                if (f.segments != null) continue;
                ++onMemory;
            }
            LOG.fine(total + "\u500b\u306e\u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u304c\u751f\u6210\u3055\u308c\u307e\u3057\u305f\u3002");
            LOG.fine("\u3046\u3061" + onMemory + "\u500b\u304c\u30aa\u30f3\u30e1\u30e2\u30ea\u30fc\u3067\u3001" + (total - onMemory) + "\u500b\u304c\u30c7\u30a3\u30b9\u30af\u4e0a\u306b\u3042\u308a\u307e\u3059\u3002");
        }
        Block bk = this.first;
        while (bk != null) {
            bk.writeTo(out);
            bk.dispose();
            bk = bk.next;
        }
        this.clean();
    }

    public long getLength() {
        return this.length;
    }

    private void clean() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("\u30ea\u30bd\u30fc\u30b9\u3092\u7247\u4ed8\u3051\u307e\u3059\u3002");
        }
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u3092\u30af\u30ed\u30fc\u30ba\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", e);
            }
            this.raf = null;
        }
        if (this.file != null) {
            try {
                this.file.delete();
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "\u4e00\u6642\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", e);
            }
            this.file = null;
        }
        this.first = null;
        this.last = null;
        this.frgs = null;
        this.length = 0L;
        this.onMemory = 0L;
        this.segment = 0;
    }

    public void dispose() {
        this.clean();
    }

    protected void finalize() throws IOException {
        if (this.first != null || this.raf != null || this.file != null) {
            this.dispose();
        }
    }

    static /* synthetic */ byte[] access$302(AbstractRandomAccessFileBuilder x0, byte[] x1) {
        x0.buff = x1;
        return x1;
    }

    protected class Block {
        public Block prev = null;
        public Block next = null;
        private final int id;
        private int len = 0;
        private byte[] buffer = null;
        private IntList segments;
        private int segLen = 0;

        public Block(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public int getLength() {
            return this.len;
        }

        public void write(byte[] buff, int pos, int len) throws IOException {
            if (this.segments == null && this.len + len < AbstractRandomAccessFileBuilder.this.blockBufferSize && AbstractRandomAccessFileBuilder.this.onMemory + (long)AbstractRandomAccessFileBuilder.this.blockBufferSize <= (long)AbstractRandomAccessFileBuilder.this.totalBufferSize) {
                if (this.buffer == null) {
                    this.buffer = new byte[AbstractRandomAccessFileBuilder.this.blockBufferSize];
                    AbstractRandomAccessFileBuilder.this.onMemory += (long)AbstractRandomAccessFileBuilder.this.blockBufferSize;
                }
                System.arraycopy(buff, pos, this.buffer, this.len, len);
            } else {
                if (this.buffer != null) {
                    this.rafWrite(this.buffer, 0, this.len);
                    AbstractRandomAccessFileBuilder.this.onMemory -= (long)AbstractRandomAccessFileBuilder.this.blockBufferSize;
                    this.buffer = null;
                }
                this.rafWrite(buff, pos, len);
            }
            this.len += len;
        }

        private void rafWrite(byte[] buff, int off, int len) throws IOException {
            if (this.segments == null) {
                this.segments = new IntList(10);
                this.segments.add(AbstractRandomAccessFileBuilder.this.segment++);
            }
            while (len > 0) {
                if (this.segLen == 8192) {
                    this.segments.add(AbstractRandomAccessFileBuilder.this.segment++);
                    this.segLen = 0;
                }
                int seg = this.segments.get(this.segments.size() - 1);
                int wlen = Math.min(len, 8192 - this.segLen);
                long wpos = (long)seg * 8192L + (long)this.segLen;
                AbstractRandomAccessFileBuilder.this.raf.seek(wpos);
                AbstractRandomAccessFileBuilder.this.raf.write(buff, off, wlen);
                this.segLen += wlen;
                off += wlen;
                len -= wlen;
            }
        }

        public void close() throws IOException {
            if (this.buffer != null) {
                if (this.len >= AbstractRandomAccessFileBuilder.this.threshold) {
                    this.rafWrite(this.buffer, 0, this.len);
                    AbstractRandomAccessFileBuilder.this.onMemory -= (long)AbstractRandomAccessFileBuilder.this.blockBufferSize;
                    this.buffer = null;
                } else if (this.len < this.buffer.length) {
                    byte[] temp = new byte[this.len];
                    System.arraycopy(this.buffer, 0, temp, 0, temp.length);
                    AbstractRandomAccessFileBuilder.this.onMemory -= (long)(this.buffer.length - this.len);
                    this.buffer = temp;
                }
            }
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.segments == null) {
                if (this.buffer != null) {
                    out.write(this.buffer, 0, this.len);
                }
            } else {
                if (AbstractRandomAccessFileBuilder.this.buff == null) {
                    AbstractRandomAccessFileBuilder.access$302(AbstractRandomAccessFileBuilder.this, new byte[8192]);
                }
                byte[] buff = AbstractRandomAccessFileBuilder.this.buff;
                for (int i = 0; i < this.segments.size() - 1; ++i) {
                    int seg = this.segments.get(i);
                    long rpos = (long)seg * 8192L;
                    AbstractRandomAccessFileBuilder.this.raf.seek(rpos);
                    AbstractRandomAccessFileBuilder.this.raf.readFully(buff);
                    out.write(buff);
                }
                int seg = this.segments.get(this.segments.size() - 1);
                long rpos = (long)seg * 8192L;
                AbstractRandomAccessFileBuilder.this.raf.seek(rpos);
                AbstractRandomAccessFileBuilder.this.raf.readFully(buff, 0, this.segLen);
                out.write(buff, 0, this.segLen);
            }
        }

        public void dispose() {
            this.buffer = null;
        }
    }
}

