/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip.v2;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import jp.cssj.cti2.TranscoderException;
import jp.cssj.driver.ctip.common.TcpUtils;
import jp.cssj.driver.ctip.v2.V2Session;

public class V2RequestConsumer {
    private final String charset;
    private final byte[] buff = new byte[8197];
    private final ByteChannel channel;
    private int pos = 0;
    private V2Session session;

    V2RequestConsumer(ByteChannel channel, String charset) throws IOException {
        this.channel = channel;
        this.charset = charset;
    }

    protected void setCTIPSession(V2Session session) {
        this.session = session;
    }

    protected void connect(String user, String password) throws IOException {
        String message = "PLAIN: " + user + " " + password + "\n";
        byte[] data = message.getBytes(this.charset);
        ByteBuffer src = ByteBuffer.allocate(data.length);
        src.put(data);
        TcpUtils.writeAll(this.channel, src);
        data = TcpUtils.readBytes(this.channel, 4);
        String response = new String(data, this.charset);
        if (response.equals("NG \n")) {
            throw new SecurityException("\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        if (!response.equals("OK \n")) {
            throw new IOException("\u4e0d\u6b63\u306a\u30ec\u30b9\u30dd\u30f3\u30b9\u3067\u3059:" + response);
        }
    }

    public void property(String name, String value) throws IOException {
        this.flush();
        byte[] nameBytes = TcpUtils.toBytes(name, this.charset);
        byte[] valueBytes = TcpUtils.toBytes(value, this.charset);
        int payload = 3 + nameBytes.length + 2 + valueBytes.length;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)1);
        src.putShort((short)nameBytes.length);
        src.put(nameBytes);
        src.putShort((short)valueBytes.length);
        src.put(valueBytes);
        TcpUtils.writeAll(this.channel, src);
    }

    public void clientResource(boolean on) throws IOException {
        this.flush();
        int payload = 2;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)4);
        src.put((byte)(on ? 1 : 0));
        src.position(0);
        this.channel.write(src);
    }

    public void startMain(URI uri, String mimeType, String encoding, long length) throws IOException {
        this.flush();
        byte[] uriBytes = TcpUtils.toBytes(uri.toString(), this.charset);
        byte[] mimeTypeBytes = TcpUtils.toBytes(mimeType, this.charset);
        byte[] encodingBytes = TcpUtils.toBytes(encoding, this.charset);
        int payload = 3 + uriBytes.length + 2 + mimeTypeBytes.length + 2 + encodingBytes.length + 8;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)2);
        src.putShort((short)uriBytes.length);
        src.put(uriBytes);
        src.putShort((short)mimeTypeBytes.length);
        src.put(mimeTypeBytes);
        src.putShort((short)encodingBytes.length);
        src.put(encodingBytes);
        src.putLong(length);
        TcpUtils.writeAll(this.channel, src);
    }

    public void serverMain(URI uri) throws IOException {
        this.flush();
        byte[] uriBytes = TcpUtils.toBytes(uri.toString(), this.charset);
        int payload = 3 + uriBytes.length;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)3);
        src.putShort((short)uriBytes.length);
        src.put(uriBytes);
        TcpUtils.writeAll(this.channel, src);
    }

    public void data(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            if (this.pos >= 8192) {
                this.flush();
            }
            this.buff[this.pos++ + 4 + 1] = b[i + off];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws IOException, TranscoderException {
        if (this.pos > 0) {
            int payload = 1 + this.pos;
            ByteBuffer src = ByteBuffer.wrap(this.buff, 0, 4 + payload);
            src.putInt(payload);
            src.put((byte)17);
            src.position(0);
            SelectableChannel channel = (SelectableChannel)((Object)this.channel);
            AbstractSelector selector = channel.provider().openSelector();
            try {
                channel.configureBlocking(false);
                SelectionKey key = channel.register(selector, 5);
                try {
                    do {
                        selector.select();
                        if (src.remaining() > 0 && key.isWritable()) {
                            this.channel.write(src);
                        }
                        if (!key.isReadable()) continue;
                        this.session.buildNext();
                    } while (src.remaining() > 0);
                }
                finally {
                    key.cancel();
                }
            }
            finally {
                ((Selector)selector).close();
                channel.configureBlocking(true);
            }
            this.pos = 0;
        }
    }

    public void startResource(URI uri, String mimeType, String encoding, long length) throws IOException {
        this.flush();
        byte[] uriBytes = TcpUtils.toBytes(uri.toString(), this.charset);
        byte[] mimeTypeBytes = TcpUtils.toBytes(mimeType, this.charset);
        byte[] encodingBytes = TcpUtils.toBytes(encoding, this.charset);
        int payload = 3 + uriBytes.length + 2 + mimeTypeBytes.length + 2 + encodingBytes.length + 8;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)33);
        src.putShort((short)uriBytes.length);
        src.put(uriBytes);
        src.putShort((short)mimeTypeBytes.length);
        src.put(mimeTypeBytes);
        src.putShort((short)encodingBytes.length);
        src.put(encodingBytes);
        src.putLong(length);
        TcpUtils.writeAll(this.channel, src);
    }

    public void missingResource(URI uri) throws IOException {
        this.flush();
        byte[] uriBytes = TcpUtils.toBytes(uri.toString(), this.charset);
        int payload = 3 + uriBytes.length;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)34);
        src.putShort((short)uriBytes.length);
        src.put(uriBytes);
        TcpUtils.writeAll(this.channel, src);
    }

    public void eof() throws IOException {
        this.flush();
        int payload = 1;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)49);
        src.position(0);
        this.channel.write(src);
    }

    public void continuous(boolean continuous) throws IOException {
        this.flush();
        int payload = 2;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)5);
        src.put((byte)(continuous ? 1 : 0));
        src.position(0);
        this.channel.write(src);
    }

    public void join() throws IOException {
        int payload = 1;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)51);
        src.position(0);
        this.channel.write(src);
    }

    public void abort(byte mode) throws IOException {
        this.flush();
        int payload = 2;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)50);
        src.put(mode);
        src.position(0);
        this.channel.write(src);
    }

    public void reset() throws IOException {
        this.flush();
        int payload = 1;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)65);
        src.position(0);
        this.channel.write(src);
    }

    public void close() throws IOException {
        this.flush();
        int payload = 1;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)66);
        src.position(0);
        this.channel.write(src);
    }

    public void serverInfo(URI uri) throws IOException {
        this.flush();
        byte[] uriBytes = TcpUtils.toBytes(uri.toString(), this.charset);
        int payload = 3 + uriBytes.length;
        ByteBuffer src = ByteBuffer.allocate(4 + payload);
        src.putInt(payload);
        src.put((byte)81);
        src.putShort((short)uriBytes.length);
        src.put(uriBytes);
        TcpUtils.writeAll(this.channel, src);
    }
}

