/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.cti2.examples;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.cssj.cti2.CTIDriverManager;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.helpers.CTIHttpServletResponseWrapper;
import jp.cssj.cti2.helpers.ServletHelper;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.url.URLSource;

public class SampleHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private static final URI SERVER_URI = URI.create("ctip://127.0.0.1:8099/");
    private static final String USER = "user";
    private static final String PASSWORD = "kappa";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        CTISession session = CTIDriverManager.getSession(SERVER_URI, USER, PASSWORD);
        try {
            ServletHelper.setServletResponse(session, (ServletResponse)res);
            session.setSourceResolver(new ServletContextResolver(this.getServletContext()));
            String path = req.getPathInfo();
            CTIHttpServletResponseWrapper ctiRes = new CTIHttpServletResponseWrapper(res, session, URI.create(path));
            try {
                req.getRequestDispatcher(path).forward((ServletRequest)req, (ServletResponse)ctiRes);
            }
            finally {
                ctiRes.close();
            }
        }
        finally {
            session.close();
        }
    }

    static class ServletContextResolver
    implements SourceResolver {
        protected final ServletContext context;

        public ServletContextResolver(ServletContext context) {
            this.context = context;
        }

        public Source resolve(URI uri) throws IOException {
            URL url = this.context.getResource(uri.toString());
            if (url == null) {
                throw new FileNotFoundException(uri.toString());
            }
            try {
                return new URLSource(url);
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }

        public void release(Source source) {
            ((URLSource)source).close();
        }
    }
}

