package jp.cssj.cti2.examples;

import java.io.IOException;
import java.net.URI;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.cssj.cti2.CTIDriverManager;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.helpers.CTIHttpServletResponseWrapper;
import jp.cssj.cti2.helpers.ServletHelper;

public class SampleHttpServlet extends HttpServlet {
	private static final long serialVersionUID = 0L;

	/** 接続先。 */
	private static final URI SERVER_URI = URI.create("ctip://127.0.0.1:8099/");

	/** ユーザー。 */
	private static final String USER = "user";

	/** パスワード。 */
	private static final String PASSWORD = "kappa";

	protected void doGet(HttpServletRequest req, HttpServletResponse res)
			throws ServletException, IOException {
		CTISession session = CTIDriverManager.getSession(SERVER_URI, USER,
				PASSWORD);
		try {
			ServletHelper.setServletResponse(session, res);
			String path = ((HttpServletRequest) req).getPathInfo();
			CTIHttpServletResponseWrapper ctiRes = new CTIHttpServletResponseWrapper(
					res, session, URI.create("."));
			try {
				req.getRequestDispatcher(path).forward(req, ctiRes);
			} finally {
				ctiRes.close();
			}
		} finally {
			session.close();
		}
	}

}
