/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.composite;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.data.DataSourceResolver;
import jp.cssj.resolver.file.FileSourceResolver;
import jp.cssj.resolver.http.HttpSourceResolver;
import jp.cssj.resolver.url.URLSourceResolver;

public class CompositeSourceResolver
implements SourceResolver {
    private Map schemeToResolver = new HashMap();
    private SourceResolver defaultResolver = new URLSourceResolver();
    private String defaultScheme = "file";

    public static CompositeSourceResolver createGenericCompositeSourceResolver() {
        CompositeSourceResolver resolver = new CompositeSourceResolver();
        resolver.addSourceResolver("file", new FileSourceResolver());
        HttpSourceResolver httpSourceResolver = new HttpSourceResolver();
        resolver.addSourceResolver("http", httpSourceResolver);
        resolver.addSourceResolver("https", httpSourceResolver);
        resolver.addSourceResolver("data", new DataSourceResolver());
        return resolver;
    }

    public void addSourceResolver(String scheme, SourceResolver resolver) {
        this.schemeToResolver.put(scheme.trim().toLowerCase(), resolver);
    }

    public void removeSourceResolver(String scheme) {
        this.schemeToResolver.remove(scheme.trim().toLowerCase());
    }

    public SourceResolver getSourceResolver(String scheme) {
        return (SourceResolver)this.schemeToResolver.get(scheme.trim().toLowerCase());
    }

    public Collection getSchemata() {
        return this.schemeToResolver.keySet();
    }

    public void setDefaultSourceResolver(SourceResolver defaultResolver) {
        this.defaultResolver = defaultResolver;
    }

    public SourceResolver getDefaultSourceResolver() {
        return this.defaultResolver;
    }

    public void setDefaultScheme(String defaultScheme) {
        this.defaultScheme = defaultScheme;
    }

    public String getDefaultSchema() {
        return this.defaultScheme;
    }

    protected SourceResolver getSourceResolver(URI uri) {
        SourceResolver resolver;
        String scheme = uri.getScheme();
        if (scheme == null) {
            scheme = this.defaultScheme;
        }
        if ((resolver = this.getSourceResolver(scheme)) == null) {
            return this.defaultResolver;
        }
        return resolver;
    }

    public Source resolve(URI uri) throws IOException {
        SourceResolver resolver = this.getSourceResolver(uri);
        return resolver.resolve(uri);
    }

    public void release(Source source) {
        SourceResolver resolver = this.getSourceResolver(source.getURI());
        resolver.release(source);
    }

    public String toString() {
        return super.toString() + "[defaultSchema=" + this.defaultScheme + ",defaultResolver=" + this.defaultResolver + ",map=" + this.schemeToResolver + "]";
    }
}

