/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.cache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.cssj.resolver.MetaSource;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceResolver;
import jp.cssj.resolver.cache.CachedSource;
import org.apache.commons.io.IOUtils;

public class CachedSourceResolver
implements SourceResolver {
    private final Map uriToSource = new HashMap();

    public File putFile(MetaSource metaSource) throws IOException {
        URI uri = metaSource.getURI().normalize();
        CachedSourceInfo info = (CachedSourceInfo)this.uriToSource.get(uri);
        if (info != null) {
            info.file.delete();
        }
        String mimeType = metaSource.getMimeType();
        String encoding = metaSource.getEncoding();
        File file = File.createTempFile("cssj-cache-", ".dat");
        file.deleteOnExit();
        info = new CachedSourceInfo(uri, mimeType, encoding, file);
        this.uriToSource.put(uri, info);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSource(Source source) throws IOException {
        File file = this.putFile(source);
        InputStream in = source.getInputStream();
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                IOUtils.copy(in, (OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            in.close();
        }
    }

    public Source resolve(URI uri) throws IOException, SecurityException {
        CachedSourceInfo info = (CachedSourceInfo)this.uriToSource.get(uri = uri.normalize());
        if (info != null) {
            return new CachedSource(info.uri, info.mimeType, info.encoding, info.file);
        }
        throw new FileNotFoundException(uri.toString());
    }

    public void release(Source source) {
        ((CachedSource)source).close();
    }

    public void reset() {
        Iterator i = this.uriToSource.values().iterator();
        while (i.hasNext()) {
            CachedSourceInfo info = (CachedSourceInfo)i.next();
            info.file.delete();
        }
        this.uriToSource.clear();
    }

    public void dispose() {
        this.reset();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    protected static class CachedSourceInfo {
        public final URI uri;
        public final String mimeType;
        public final String encoding;
        public final File file;

        public CachedSourceInfo(URI uri, String mimeType, String encoding, File file) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.encoding = encoding;
            this.file = file;
        }
    }
}

