/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.cti2.examples;

import java.io.File;
import java.net.URI;
import jp.cssj.cti2.CTIDriverManager;
import jp.cssj.cti2.CTISession;
import jp.cssj.cti2.helpers.CTIMessageHelper;
import jp.cssj.cti2.helpers.CTISessionHelper;
import jp.cssj.resolver.url.URLSourceResolver;

public class ClientResource {
    private static final URI SERVER_URI = URI.create("ctip://127.0.0.1:8099/");
    private static final String USER = "user";
    private static final String PASSWORD = "kappa";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CTISession session = CTIDriverManager.getSession(SERVER_URI, USER, PASSWORD);
        try {
            File file = new File("test.pdf");
            CTISessionHelper.setResultFile(session, file);
            session.setMessageHandler(CTIMessageHelper.createStreamMessageHandler(System.err));
            session.setSourceResolver(new URLSourceResolver());
            session.property("output.pdf.version", "1.7");
            session.property("output.pdf.encryption", "v2");
            session.property("output.pdf.encryption.user-password", "test1");
            session.property("output.pdf.encryption.permissions.print", "false");
            session.property("output.pdf.encryption.permissions.modify", "false");
            session.property("output.pdf.encryption.permissions.copy", "false");
            session.property("output.pdf.encryption.permissions.add", "false");
            session.property("output.pdf.encryption.permissions.fill", "false");
            session.property("output.pdf.hyperlinks", "true");
            session.property("output.pdf.bookmarks", "true");
            session.property("output.meta.0.name", "DESCRIPTION");
            session.property("output.meta.0.value", "Copper PDF \u306e\u30b5\u30f3\u30d7\u30eb");
            file = new File("examples/files/test.jpeg");
            session.property("output.pdf.attachments.0.uri", file.toURI().toASCIIString());
            session.property("output.pdf.attachments.0.name", "beatle.jpeg");
            session.property("output.pdf.attachments.0.description", "\u30ab\u30d6\u30c8\u30e0\u30b7");
            CTISessionHelper.sendResourceFile(session, file, "image/jpeg", null);
            File mainFile = new File("examples/files/test.html");
            CTISessionHelper.transcodeFile(session, mainFile, "text/html", null);
        }
        finally {
            session.close();
        }
    }
}

