#!/usr/bin/perl
=head1 NAME

サーバー側リソース変換サンプル

=head2 概要

http://www.cssj.jp/を変換します。

=cut
use strict;
use lib '../code';
use CSSJ::Driver;

print "Content-Type: application/pdf\n";

my $driver = CSSJ::Driver::create_driver_for('localhost', 8099, 'UTF-8');
my $session = $driver->create_session('user', 'kappa');
$session->set_property('output.pdf.compression', 'ascii');
$session->set_content_length_func (sub {
	my $length = shift;
	print "Content-Length: $length\n\n";
	binmode(STDOUT);
});

$session->include_resource('http://copper-pdf.com/**');
$session->format_main('http://copper-pdf.com/');

$session->close();
