#!/usr/bin/perl
=head1 NAME

コンテンツ変換サンプル

=head2 概要

start_mainとend_mainの間の出力結果をPDFに変換します。

=cut
use strict;
use lib '../code';
# ドライバのインポート
use CSSJ::Driver;

# ドライバの作成
my $driver = CSSJ::Driver::create_driver_for('localhost', 8099, 'UTF-8');
# 接続
my $session = $driver->create_session('user', 'kappa');

# Content-Lengthヘッダの送信
$session->set_content_length_func (sub {
	my $length = shift;
	print "Content-Length: $length\n\n";
	binmode(STDOUT);
});

# Content-Typeヘッダの送信
print "Content-Type: application/pdf\n";

# リソースの送信
$session->start_resource(*STDOUT, 'file:/skin.css');
print << 'EOF';
  p {
  	background-color: Gray;
  }
EOF
$session->end_resource(*STDOUT);

# 本体の送信
$session->start_main(*STDOUT, 'file:/test.html', 'text/html', 'UTF-8');
print << 'EOF';
<html>
  <head>
    <title>テストドキュメント</title>
    <link rel="StyleSheet" type="text/css" href="skin.css">
  </head>
  <body>
    <p>こんにちは</p>
  </body>
</html>
EOF
$session->end_main(*STDOUT);

# セッションを閉じる
$session->close();
