package osm.jp;

import java.io.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.areaweb.tools.database.*;

public class DbBusstop {
	File inputFile;
	String filter = "";
	int iCounter = 0;
	String urlStr = "";
	Connection con;
	String timeStampStr = null;
	File dir = null;

	/** メイン
	 * @throws IOException
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws FileNotFoundException */
	public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, IOException, SQLException 
	{
		Connection con = null;
		try {
			con = DatabaseTool.openDb("database");
			DbBusstop.export(con);
		}
		finally {
			if (con != null) {
				DatabaseTool.closeDb(con);
			}
		}
	}

	/**
	 * 'table.BUS_STOP'を新規に作る
	 * @param con
	 * @throws SQLException
	 */
	public static void create(Connection con) throws SQLException {
		String createSt = "CREATE TABLE bus_stop (idref VARCHAR(12) NOT NULL, name VARCHAR(128), lat DOUBLE, lon DOUBLE, fixed INT, ifile VARCHAR(128), CONSTRAINT bus_stop_pk PRIMARY KEY(idref));";
		PreparedStatement ps = con.prepareStatement(createSt);
		ps.executeUpdate();
		ps.close();
	}

	/**
	 * 'table.BUS_STOP'を削除する
	 * @param con
	 * @throws SQLException
	 */
	public static void drop(Connection con) throws SQLException {
		String createSt = "DROP TABLE bus_stop;";
		PreparedStatement ps = con.prepareStatement(createSt);
		ps.executeUpdate();
		ps.close();
	}
	
	/**
	 * 'table.BUS_STOP'の内容をCSV形式にして標準出力に出力する
	 * @param con
	 */
	public static void export(Connection con) {
		try {
			System.out.println("TABLE: BUS_STOP");
			System.out.println("\"name\",\"lat\",\"lon\",\"fixed\",\"ifile\"");
			PreparedStatement ps8 = con.prepareStatement("SELECT name,lat,lon,fixed,ifile FROM bus_stop");
			ResultSet rset8 = ps8.executeQuery();
			while (rset8.next()) {
				String name = rset8.getString(1);
				Double lat = rset8.getDouble(2);
				Double lon = rset8.getDouble(3);
				int fixed = rset8.getInt(4);
				String ifile = rset8.getString(5);
				System.out.println("\""+ name +"\","+ lat +","+ lon +","+ fixed +",\""+ ifile +"\"");
			}
			rset8.close();
		}
		catch (SQLException e) {
			e.printStackTrace();
		}
	}
}