package osm.jp;

import java.io.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import jp.co.areaweb.tools.database.*;
import jp.co.areaweb.tools.csv.*;

public class DbAddr {
	File inputFile;
	String filter = "";
	int iCounter = 0;
	String urlStr = "";
	Connection con;
	String timeStampStr = null;
	File dir = null;

	/** メイン
	 * @throws IOException
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws FileNotFoundException */
	public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, IOException, SQLException 
	{
		Connection con = null;
		try {
			con = DatabaseTool.openDb("database");
			
			PreparedStatement ps7 = con.prepareStatement("SELECT prefecturecode,prefecture,municipalitycode,municipality,namecode,name,lat,lon,typecode,year FROM ISJ_CHO ORDER BY municipalitycode");
			ResultSet rset7 = ps7.executeQuery();
			while (rset7.next()) {
				CsvRecord rec = getRecord(rset7);
				System.out.println(rec.toString());
			}
			rset7.close();			
		}
		finally {
			if (con != null) {
				DatabaseTool.closeDb(con);
			}
		}
	}

	/**
	 * 'table.ISJ_CHO'を新規に作る
	 * 
	 * 	1: "都道府県コード",		prefecturecode	VARCHAR(10)
	 * 	2: "都道府県名",			prefecture			VARCHAR(32)
	 * 	3: "市区町村コード",		municipalitycode	VARCHAR(20)
	 * 	4: "市区町村名",			municipality 		VARCHAR(128)
	 * 	5: "大字町丁目コード",	namecode	VARCHAR(20)
	 * 	6: "大字町丁目名",		name VARCHAR(128)
	 * 	7: "緯度",				lat DOUBLE
	 * 	8: "経度",				lon DOUBLE
	 * 	9: "原典資料コード",
	 * 	10: "大字・字・丁目区分コード"		typecode	INT
	 * 		1 = 大字 = quarter
	 * 		2 = 字 = neighbourhood
	 * 		3 = 丁目 = neighbourhood
	 * 		4 = 不明 = locality
	 * 	11: "位置参照情報の整備年",	year INT
	 * 
	 * 既にテーブルが存在する時には何もしない
	 * @param con
	 * @throws SQLException
	 */
	public static void create(Connection con) throws SQLException {
		String createSt = "create table ISJ_CHO (prefecturecode VARCHAR(10) NOT NULL, prefecture VARCHAR(32), " +
				"municipalitycode	VARCHAR(20), municipality VARCHAR(128), " +
				"namecode	VARCHAR(20), name VARCHAR(128), " +
				"lat DOUBLE, lon DOUBLE, typecode INT, year INT, " +
                "CONSTRAINT ISJ_CHO_pk PRIMARY KEY(prefecturecode,municipalitycode,namecode));";
		ConvAddr.logger.info(createSt);
		PreparedStatement ps = con.prepareStatement(createSt);
		try {
			ps.executeUpdate();
		}
		catch (SQLException e) {
			if (!(e.toString().startsWith("Table already exists:"))) {
				throw e;
			}
		}
		finally {
			ps.close();
		}
	}

	/**
	 * 'table.ISJ_CHO'を削除する
	 * @param con
	 * @throws SQLException
	 */
	public static void drop(Connection con) throws SQLException {
		String createSt = "DROP TABLE ISJ_CHO;";
		ConvAddr.logger.info(createSt);
		PreparedStatement ps = con.prepareStatement(createSt);
		ps.executeUpdate();
		ps.close();
	}
	
	/**
	 * 'table.ISJ_CHO'を空にする
	 * 
	 * @param con
	 * @throws SQLException
	 */
	public static long clear(Connection con) throws SQLException {
		Statement stmt = con.createStatement();
		long count = stmt.executeUpdate("delete from ISJ_CHO");
	   stmt.close();
	   return count;
	}
	
	/**
	 * CSVレコードを'table.ISJ_CHO'に書き込む
	 * 
	 * @param con
	 */
	public static int insert(Connection con, CsvRecord csvRec, int year) {
		String sql = ("INSERT INTO ISJ_CHO (prefecturecode,prefecture,municipalitycode,municipality,namecode,name,lat,lon,typecode,year)" +
				" VALUES (?,?,?,?,?,?,?,?,?,?)");
		try {
			PreparedStatement pstmt = con.prepareStatement(sql);
			pstmt.setString(1, csvRec.get(0));		// 1: "都道府県コード",		prefecturecode
			pstmt.setString(2, csvRec.get(1));		// 2: "都道府県名",			prefecture			VARCHAR(32)
			pstmt.setString(3, csvRec.get(2));		// 3: "市区町村コード",		municipalitycode	VARCHAR(20)
			pstmt.setString(4, csvRec.get(3));		// 4: "市区町村名",			municipality 		VARCHAR(128)
			pstmt.setString(5, csvRec.get(4));		// 5: "大字町丁目コード",	namecode	VARCHAR(20)
			pstmt.setString(6, csvRec.get(5));		// 6: "大字町丁目名",		name VARCHAR(128)
			pstmt.setDouble(7, Double.parseDouble(csvRec.get(6)));	// 7: "緯度",	lat DOUBLE
			pstmt.setDouble(8, Double.parseDouble(csvRec.get(7)));	// 8: "経度",	lon DOUBLE
			pstmt.setInt(9, Integer.parseInt(csvRec.get(9)));		// 10: "大字・字・丁目区分コード"	typecode	INT
			pstmt.setInt(10, year);					// 11: "位置参照情報の整備年"		year	INT
			pstmt.executeUpdate();
			pstmt.close();
			return 1;
		}
		catch (Exception e) {
			e.printStackTrace();
			return 0;
		}
	}
	
	/**
	 * 'table.ISJ_CHO'の内容をCSV形式にして標準出力に出力する
	 * @param con
	 * @throws SQLException 
	 */
	public static CsvRecord getRecord(ResultSet rset) throws SQLException {
		CsvRecord rec = new CsvRecord();
		rec.add(rset.getString(1));		// prefecturecode
		rec.add(rset.getString(2));		// prefecture
		rec.add(rset.getString(3));		// municipalitycode
		rec.add(rset.getString(4));		// municipality
		rec.add(rset.getString(5));		// namecode
		rec.add(rset.getString(6));		// name
		rec.add(rset.getString(7));		// lat
		rec.add(rset.getString(8));		// lon
		rec.add(rset.getString(9));		// typecode
		rec.add(rset.getString(10));	// year
		return rec;
	}
}