/**
 * ConnectTuatwin32p[U[C^[tF[X
 */

#include "../src/CTSettings.hpp"
#include "../src/CTConnectionThread.hpp"

#include <windows.h>
#include <process.h>
#include "resource.h"

// j[pID
#define ID_MNU_EXIT 1000
#define ID_MNU_EDIT 1002
#define ID_MNU_CANCEL 1001

// ^XNgC̃ACRɊւ郁bZ[W
#define WM_TASKTRAY_ICON WM_USER+100

// ڑ`FbN^C}[ID
#define TIMER_ID     100

HINSTANCE hInstance;

// ^XNgCACR\邽߂̃EBhE
HWND hWnd;
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

// ^XNgCp̃ACR
NOTIFYICONDATA connectingIcon;
NOTIFYICONDATA errorIcon;
NOTIFYICONDATA errorOtherClientIcon;

// ^XNgC̃j[
HMENU tasktrayMenu;
bool  tasktrayMenuShowed = false;

// [U[ύX_CAO֘A
HWND  userInfoDialog;
bool  userInfoDialogShowed = false;
void  ShowUserInfoDialog();
BOOL CALLBACK UserInfoDialogProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam);

// ڑIuWFNg
CTConnectionThread connection;

/**
 * j[̍쐬
 */
void BuildMenu()
{
    tasktrayMenu = CreatePopupMenu();
    AppendMenu(tasktrayMenu, MF_ENABLED, ID_MNU_EXIT, "ConnectTUAT̏I(&E)");
    AppendMenu(tasktrayMenu, MF_SEPARATOR, ID_MNU_EDIT, "");
    AppendMenu(tasktrayMenu, MF_ENABLED, ID_MNU_EDIT, "[U[/pX[h̕ҏW(&M)");
    AppendMenu(tasktrayMenu, MF_ENABLED, ID_MNU_CANCEL, "̃j[(&C)");
}

/**
 * C[`
 */
int WINAPI WinMain(HINSTANCE _hInstance, HINSTANCE, LPSTR, int)
{
    hInstance = _hInstance;

    // ݒt@C̓ǂݍ
    CTSettings settings;
    settings.load();

    // Âݒt@C폜
    DeleteFile("settings.xml");

    // RlNV̍쐬
    connection.setSettings(settings);
    connection.start();

    // CEBhE̓o^A쐬
    char szClassName[] = "ConnectTuat_DummyWimdow";

    WNDCLASS wc;

    wc.style         = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc   = WndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1));
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = (LPCSTR)szClassName;

    if (!RegisterClass(&wc))
    {
        // Ƃ͗]vȂƂɏIقǂȂ
        MessageBox(NULL,"RegisterClass()ɎsBI܂B","ConnectTuat - G[",MB_OK);
        return FALSE;
    }

    hWnd = CreateWindow(szClassName,
                        "ConnectTuat DummyWindow",	// ^Cg
                        0,							// EBhE̎
                        CW_USEDEFAULT,				// XW
                        CW_USEDEFAULT,				// YW
                        CW_USEDEFAULT,				// 
                        CW_USEDEFAULT,				// 
                        NULL,						// eEBhẼnh
                        NULL,						// j[nh
                        hInstance,					// CX^Xnh
                        NULL);						//
    if ( !hWnd )
    {
        // Ƃ͗]vȂƂɏIقǂȂ
        MessageBox(NULL,"CreateWindow()ɎsBI܂B","ConnectTuat - G[",MB_OK);
        return FALSE;
    }

    // EBhE̕\
    ShowWindow(hWnd, SW_HIDE);
    UpdateWindow(hWnd);

    // ^XNgCp̃ACR̍쐬
    connectingIcon.cbSize = sizeof(connectingIcon);
    connectingIcon.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON2));
    connectingIcon.hWnd = hWnd;
    connectingIcon.uCallbackMessage = WM_TASKTRAY_ICON;
    connectingIcon.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
    strcpy(connectingIcon.szTip, "ڑ");

    errorIcon.cbSize = sizeof(errorIcon);
    errorIcon.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON3));
    errorIcon.hWnd = hWnd;
    errorIcon.uCallbackMessage = WM_TASKTRAY_ICON;
    errorIcon.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
    strcpy(errorIcon.szTip, "G[͖ڑ");

    errorOtherClientIcon.cbSize = sizeof(errorOtherClientIcon);
    errorOtherClientIcon.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON4));
    errorOtherClientIcon.hWnd = hWnd;
    errorOtherClientIcon.uCallbackMessage = WM_TASKTRAY_ICON;
    errorOtherClientIcon.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
    strcpy(errorOtherClientIcon.szTip, "ʂ̃vO̐ڑLł");

    Shell_NotifyIcon(NIM_ADD, &errorIcon);

    // j[̍쐬
    BuildMenu();

    // ڑmFp^C}[̍쐬
    SetTimer(hWnd, TIMER_ID, 5000, NULL);

    // EBhEvV[W
    MSG msg;
    while (GetMessage (&msg,NULL,0,0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    // I
    KillTimer(hWnd, TIMER_ID);
    return (int)msg.wParam;
}

/**
 * EBhEvV[W
 */
LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
    switch ( msg )
    {
    case WM_TIMER:
        // ڑmF
        if ( wp != TIMER_ID )
        {
            break;
        }

        // ڑ̏Ԃɉă^XNgCACR̕ύX
        switch (connection.getStatus())
        {
        case CT_ERROR:
            switch (connection.getLastError())
            {
            case CT_ERROR_OTHER_CLIENT:
                Shell_NotifyIcon(NIM_MODIFY, &errorOtherClientIcon);
                break;
            case CT_ERROR_AUTH:
                ShowUserInfoDialog();
                break;
            default:
                Shell_NotifyIcon(NIM_MODIFY, &errorIcon);
                break;
            }
            break;
        case CT_CONNECTING:
            Shell_NotifyIcon(NIM_MODIFY, &connectingIcon);
            break;
        default:
            Shell_NotifyIcon(NIM_MODIFY, &errorIcon);
            break;
        }

        break;
    case WM_COMMAND:
        // j[I񂾍ۂ̏
        switch (LOWORD(wp))
        {
        case ID_MNU_EXIT:
            // I{^
            Shell_NotifyIcon(NIM_DELETE, &connectingIcon);
            PostQuitMessage(0);
            break;
        case ID_MNU_EDIT:
            // [U[̕ҏW{^
            ShowUserInfoDialog();
            break;
        }
        break;

    case WM_TASKTRAY_ICON:
        // ^XNgCACRNbNۂ̏Bj[\
        switch (lp)
        {
        case WM_LBUTTONDOWN:
        case WM_RBUTTONDOWN:
        {
            POINT pt;
            GetCursorPos(&pt);
            SetForegroundWindow(hWnd);
            SetActiveWindow(hWnd);
            TrackPopupMenu(tasktrayMenu, TPM_TOPALIGN | TPM_LEFTALIGN | TPM_RIGHTBUTTON,
                           pt.x, pt.y, 0, hWnd, NULL);
            tasktrayMenuShowed = true;
        }
        break;
        }
        break;

    case WM_NCACTIVATE:
        // ANeBuꂽ烁j[
        if ((BOOL)wp == FALSE)
        {
            if (tasktrayMenuShowed)
            {
                // XXX Ƃ@͂ *********
                DestroyMenu(tasktrayMenu);
                BuildMenu();
                tasktrayMenuShowed = false;
            }
        }
    case WM_CLOSE:
        break;
    case WM_DESTROY:
        break;
    }

    // ǂ̂ł傤H
    //	return 0L;
    return (DefWindowProc(hWnd, msg, wp, lp));

}
/**
 * [U[ύXp_CAO
 */
BOOL CALLBACK UserInfoDialogProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
    switch (Msg)
    {
    case WM_INITDIALOG:
    {
        userInfoDialogShowed  = true;
        CTSettings settings = connection.getSettings();

        SetDlgItemText(hDlg, IDC_USERID, settings.get("userid").c_str());
        SetDlgItemText(hDlg, IDC_PASSWORD, settings.get("password").c_str());

        // ݒ_CAOɕ\
        SendMessage(GetDlgItem(hDlg, IDC_USERTYPE), CB_INSERTSTRING, (WPARAM)0, (LPARAM)"st");
        SendMessage(GetDlgItem(hDlg, IDC_USERTYPE), CB_INSERTSTRING, (WPARAM)1, (LPARAM)"cc");
        SendMessage(GetDlgItem(hDlg, IDC_USERTYPE), CB_INSERTSTRING, (WPARAM)2, (LPARAM)"guest");

        SetDlgItemText(hDlg, IDC_USERTYPE, settings.get("usertype").c_str());

        SetFocus(GetDlgItem(hDlg, IDC_USERID));
    }
    break;
    case WM_COMMAND:
        switch (LOWORD(wParam))
        {
        case IDOK:
        {
            // OK{^

            // uṽx\
            HWND processing = GetDlgItem(hDlg, IDC_PROC);
            ShowWindow(processing, SW_SHOWNORMAL);
            UpdateWindow(processing);

            // _CAOɓ͂ꂽf[^̎擾
            const unsigned int BUFFER_SIZE = 4096; // XXX̍񂾂Ȃ
            char userid[BUFFER_SIZE];
            char password[BUFFER_SIZE];
            char usertype[BUFFER_SIZE];

            memset(userid, 0, sizeof(userid));
            memset(usertype, 0, sizeof(usertype));
            memset(password, 0, sizeof(password));

            GetDlgItemText(hDlg,IDC_USERID, (LPTSTR)userid, sizeof(userid)-1);
            GetDlgItemText(hDlg,IDC_PASSWORD, (LPTSTR)password, sizeof(password)-1);
            GetDlgItemText(hDlg,IDC_USERTYPE, (LPTSTR)usertype, sizeof(usertype)-1);

            {
                // ݒ̏
                CTSettings settings = connection.getSettings();
                if (settings.get("userid") != userid ||
                        settings.get("password") != password ||
                        settings.get("usertype") != usertype)
                {
                    settings.set("userid", userid);
                    settings.set("password", password);
                    settings.set("usertype", usertype);
                    settings.save();
                    connection.setSettings(settings);
                    connection.join();
                    connection.start();
                }
            }
            // _CAȌI
            userInfoDialogShowed  = false;
            EndDialog(hDlg, 0);
            return TRUE;
        }
        case IDCANCEL:
            // LZ{^
            userInfoDialogShowed  = false;
            EndDialog(hDlg, 0);
            return TRUE;
        }
        break;

    case WM_CLOSE:
        userInfoDialogShowed = false;
        EndDialog(hDlg, 0);
        return TRUE;
    }

    return FALSE;
}

/**
 * [U[ύX_CAO̕\
 */
void ShowUserInfoDialog()
{
    // XbhZ[tł͂Ȃ
    if (!userInfoDialogShowed)
    {
        // XXX CreateDialog()֐gƃ^u󂯕tĂȂ?
        //dialog = CreateDialog(hInstance , MAKEINTRESOURCE(IDD_DIALOG1), NULL, DlgProc);
        DialogBox((HINSTANCE)GetWindowLong(hWnd,GWL_HINSTANCE),MAKEINTRESOURCE(IDD_DIALOG1) , hWnd , UserInfoDialogProc);
        return;
    }
    return;
}
