
#include "CTConnection.hpp"

//#include <unistd.h>
#include <exception>
#include <iostream>
#include <windows.h>
int main()
{
    using namespace std;

    CTSettings settings;
    settings.load();

    CTConnection conn;
    conn.setSettings(settings);

    cout << "ConnectTuat start" << endl;

    while (true)
    {
        Sleep(3000);
        CTSTATUS s = conn.process();
        CTERROR e = conn.getLastError();
        switch (s)
        {
        case CT_NOT_STARTED:
            cout << "x" << flush;
            break;
        case CT_CONNECTING:
            cout << "o" << flush;
            break;
        case CT_ERROR:
            switch (e)
            {
            case CT_ERROR_NET:
                cout << CT_ERROR_NET << flush;
                break;
            case CT_ERROR_OTHER_CLIENT:
                cout << CT_ERROR_OTHER_CLIENT << flush;
                break;
            case CT_ERROR_AUTH:
                cout << CT_ERROR_AUTH << flush;
                break;
            case CT_ERROR_MISC:
                cout << CT_ERROR_MISC << flush;
                break;
            case CT_ERROR_NOT_INITIALIZED:
                cout << CT_ERROR_NOT_INITIALIZED << flush;
                break;
            default:
                cout << "[default error]" << flush;
                break;
            }
            break;
        default:
            cout << "[default]" << flush;
            break;
        }
    }
    cout << endl << "Exited normally" << endl;
    return 0;
}
