
#include "CTSettings.hpp"
#include <list>
#include <boost/array.hpp>

using namespace std;

const char* OLD_CONFIG_FILE_NAME = "settings.xml";

string get_user_config_file_name()
{
    return string("user.xml");
}
string get_app_config_file_name()
{
    return string("config.xml");
}

CTSettings::CTSettings()
{}

CTSettings::CTSettings(const CTSettings& _settings)
{
    this->data = _settings.data;
}

void CTSettings::load()
{
    using namespace std;
    // user settings
    {
        TiXmlDocument doc(::get_user_config_file_name().c_str());
        doc.LoadFile();
        TiXmlHandle docHandle(&doc);
        TiXmlElement* elem =docHandle.FirstChild("connecttuat").FirstChild("data").Element();

        for (; elem; elem=elem->NextSiblingElement())
        {
            string key = elem->Attribute("key");
            string value = elem->Attribute("value");
            set(key, value);
        }
    }
    // app settings
    {
        TiXmlDocument doc(::get_app_config_file_name().c_str());
        doc.LoadFile();
        TiXmlHandle docHandle(&doc);
        TiXmlElement* elem =docHandle.FirstChild("connecttuat").FirstChild("data").Element();

        for (; elem; elem=elem->NextSiblingElement())
        {
            string key = elem->Attribute("key");
            string value = elem->Attribute("value");
            set(key, value);
        }
    }

    // ------------------------------
    // for backward compatibility
    bool load_from_old_file = false;
    TiXmlDocument doc(OLD_CONFIG_FILE_NAME);

    doc.LoadFile();

    TiXmlHandle docHandle(&doc);
    TiXmlElement* elem_userid = docHandle.FirstChild("connecttuat").FirstChild("userid").Element();
    if (get("userid") == string() && elem_userid && elem_userid->Attribute("val"))
    {
        set("userid", elem_userid->Attribute("val"));
        load_from_old_file = true;
    }
    else
    {
        //return false;
    }
    TiXmlElement* elem_password=docHandle.FirstChild("connecttuat").FirstChild("password").Element();
    if (get("password") == string() && elem_password && elem_password->Attribute("val"))
    {
        set("password",elem_password->Attribute("val"));
        load_from_old_file = true;
    }
    else
    {
        //return false;
    }
    TiXmlElement* elem_usertype=docHandle.FirstChild("connecttuat").FirstChild("usertype").Element();
    if (get("usertype") == string() && elem_usertype && elem_usertype->Attribute("val"))
    {
        set("usertype", elem_usertype->Attribute("val"));
        load_from_old_file = true;
    }
    else
    {
        //return false;
    }
    save();
}

void CTSettings::save()
{
    TiXmlDocument userXmlDoc;
    TiXmlDocument appXmlDoc;

    TiXmlElement userXml("connecttuat");
    TiXmlElement appXml("connecttuat");

    using namespace std;

    for (map<string, string>::iterator itr = data.begin()
            ; itr != data.end(); itr++)
    {
        TiXmlElement e("data");
        e.SetAttribute("key", itr->first.c_str());
        e.SetAttribute("value", itr->second.c_str());
        if (itr->first == "userid" || itr->first == "usertype" || itr->first == "password")
        {
            userXml.InsertEndChild(e);
        }
        else
        {
            appXml.InsertEndChild(e);
        }
    }

    appXmlDoc.InsertEndChild(appXml);
    appXmlDoc.SaveFile(::get_app_config_file_name().c_str());

    userXmlDoc.InsertEndChild(userXml);
    userXmlDoc.SaveFile(::get_user_config_file_name().c_str());
}
std::string CTSettings::get(std::string key) const
    {
        std::map<std::string, std::string>::const_iterator i = data.find(key);
        if (i == data.end())
        {
            return std::string();
        }
        return i->second;
    }
void CTSettings::set(std::string key, std::string value)
{
    data[key] = value;
}
