#include "CTConnectionThread.hpp"

CTConnectionThread::CTConnectionThread(void)
{
    setStatus(CT_NOT_STARTED);
}

CTConnectionThread::~CTConnectionThread(void)
{}

void CTConnectionThread::start(void)
{
    using namespace boost;
    try
    {
        threadObject = shared_ptr<thread>(new thread(bind(&CTConnectionThread::run, this))) ;
    }
    catch (boost::thread_resource_error)
    {
        // whatever ..
        status = CT_ERROR;
        return;
    }
}
void CTConnectionThread::join(void)
{
    setStatus(CT_NOT_STARTED);
    {
        boost::mutex::scoped_lock lk(exitRequestMutex);
        exitRequest = true;
    }
    threadObject->join();
    setStatus(CT_NOT_STARTED);
}
CTSettings CTConnectionThread::getSettings(void)
{
    CTSettings _settings;
    {
        boost::mutex::scoped_lock lk(settingsMutex);
        _settings = settings;
    }
    return _settings;
}
CTSTATUS CTConnectionThread::getStatus(void)
{
    CTSTATUS _status;
    {
        boost::mutex::scoped_lock lk(statusMutex);
        _status = status;
    }
    return _status;
}
CTERROR CTConnectionThread::getLastError(void)
{
    CTERROR _lastError;
    {
        boost::mutex::scoped_lock lk(lastErrorMutex);
        _lastError = lastError;
    }
    return _lastError;
}
void CTConnectionThread::run(void)
{
    CTConnection connection;
    connection.setSettings(settings);
    while (true)
    {
        boost::xtime xt;
        boost::xtime_get(&xt, boost::TIME_UTC);
        xt.sec += 1;
        boost::thread::sleep(xt);
        {
            boost::mutex::scoped_lock lk(exitRequestMutex);
            if (exitRequest)
            {
                exitRequest = false;
                break;
            }
        }
        CTSTATUS s = connection.process();
        CTERROR e = connection.getLastError();
        setStatus(s);
        setLastError(e);
    }
}

void CTConnectionThread::setSettings(CTSettings _settings)
{
    boost::mutex::scoped_lock lk(settingsMutex);
    settings = _settings;
}

void CTConnectionThread::setStatus(CTSTATUS _status)
{
    boost::mutex::scoped_lock lk(statusMutex);
    status = _status;
}
void CTConnectionThread::setLastError(CTERROR _lastError)
{
    boost::mutex::scoped_lock lk(lastErrorMutex);
    lastError = _lastError;
}
