
#ifndef __CTCONNECTION_HPP__
#define __CTCONNECTION_HPP__

#include "common.hpp"
#include "CTSettings.hpp"

#include <sstream>
#include <exception>
#include <stdexcept>
#include <string>
#include <cstring>

#include <openssl/crypto.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rand.h>
#include <openssl/bio.h>

/**
 * CTConnection
 * ڑsNXB莞Ԗprocess()֐ĂяoĂB
 */
class CTConnection
{
public:
    /// ڑ
    CTSTATUS process();
    /// process()̖߂luG[v\̂ꍇ̃G[̎ނԂB
    CTERROR getLastError() const;
    /// ڑ̃Zbg
    void reset();
    /// ݒf[^̓o^
    void setSettings(const CTSettings _settings);
    /// ݂̐ݒf[^̎擾
    CTSettings getSettings() const;

    CTConnection();
    ~CTConnection();
private:
    BIO* javaEmulationBio;
    BIO* getJavaEmulationBIO(const std::string endpoint) const;
    CTERROR lastError;
    CTConnection(const CTConnection&);
    CTConnection& operator=(const CTConnection&);
    std::string connectNetworkAuthentication() const;
    std::string getEndpoint(const std::string& res) const;
    std::string getRequestString() const;
    CTSettings settings;
};

#endif
