
#include "CTConnection.hpp"
#include "CTException.hpp"
#include <boost/thread.hpp>
#include <boost/regex.hpp>

using namespace std;

// char[]̃TCYɍƂ͂g
const unsigned int GENERAL_ENOUGH_BUFFER_SIZE = 4096;

/**
 * nonblocking bioɃf[^
 */
bool CT_NBIO_write(BIO* nonblocking_bio, string data)
{
    // XXXǂݍ񂾒ɏނƃG[N̂łƂ肠҂
    boost::xtime xt;
    boost::xtime_get(&xt, boost::TIME_UTC);
    xt.sec += 3;
    boost::thread::sleep(xt);

    // f[^
    char msg_buf[GENERAL_ENOUGH_BUFFER_SIZE];
    strncpy(msg_buf,data.c_str(),  sizeof(msg_buf));
    int off=0;
    int len=data.size();

    while (true)
    {
        int i = BIO_write(nonblocking_bio,&(msg_buf[off]),len);
        if (i <= 0)
        {
            if (BIO_should_retry(nonblocking_bio))
            {
                continue;
            }
            else
            {
                break;
            }
        }
        off+=i;
        len-=i;
        if (len <= 0)
        {
            return true;
        }
    }

    return false;
}

/**
 * F؃f[^POSTۂɋAĂhtml͂Aڑ𓾂
 */
string CTConnection::getEndpoint(const string& res) const
{
    using namespace boost;

    THROW_CTEXCEPTION_IF(regex_search(res,regex(settings.get("regex_isAuthenticationError"))), CT_ERROR_AUTH, res);
    THROW_CTEXCEPTION_IF(regex_search(res,regex(settings.get("regex_isOtherClientError"))), CT_ERROR_OTHER_CLIENT, res);
    THROW_CTEXCEPTION_IF(!regex_search(res,regex(settings.get("regex_isAuthenticationSuccess"))), CT_ERROR_NET, res);

    boost::smatch m;
    string port;

    THROW_CTEXCEPTION_IF(!regex_search(res,m,regex(settings.get("regex_getPort"))), CT_ERROR_NET,res);
    port = m.str(1);

    stringstream _endpoint;
    _endpoint << settings.get("keep_server") << ":" << port;
    _debug_out << "endpoint: " << _endpoint.str() << std::endl;
    return _endpoint.str();
}

/**
 * ݒ񂩂POSTphttprequestf[^𓾂
 */
std::string CTConnection::getRequestString() const
{
    string userid = settings.get("userid");
    string password = settings.get("password");
    string usertype = settings.get("usertype");

    string post = settings.get("postdata");

    using namespace boost;
    post = regex_replace(post, regex("%password%"), password, format_all);
    post = regex_replace(post, regex("%userid%"), userid, format_all);
    post = regex_replace(post, regex("%usertype%"), usertype, format_all);

    string req = settings.get("request");
    stringstream content_length;
    content_length << post.size();
    req = regex_replace(req, regex("%content_length%"), content_length.str(), format_all);
    req += post;
    req += "\n";

    return req;
}

/**
 * lbg[NF؂ɐڑAڑp̂߂̐ڑ𓾂
 */
std::string CTConnection::connectNetworkAuthentication() const
{
    using namespace std;
    string userid = settings.get("userid");
    string password = settings.get("password");
    string usertype = settings.get("usertype");
    SSL* ssl = NULL;

    try
    {
        // ------------------------- prepare SSL -------------------------
        SSL_CTX *ctx = NULL;
        RAND_poll();
        while ( RAND_status() == 0 )
        {
            unsigned short rand_ret = rand() % 65536;
            RAND_seed(&rand_ret, sizeof(rand_ret));
        }
        ctx = SSL_CTX_new(SSLv3_client_method());

        THROW_CTEXCEPTION_IF(ctx == NULL, CT_ERROR_NET, "");

        SSL_CTX_set_timeout(ctx, 5);
        ssl = SSL_new(ctx);
        if ( ssl == NULL )
        {
            SSL_CTX_free(ctx);
            THROW_CTEXCEPTION(CT_ERROR_NET,"");
        }
        SSL_CTX_free(ctx);
        BIO* bio = NULL;
        {
            stringstream endpoint;
            endpoint << settings.get("auth_server") << ":" << settings.get("auth_server_port");
            char* endpoint_nonconst = strdup(endpoint.str().c_str());
            THROW_CTEXCEPTION_IF(endpoint_nonconst == NULL, CT_ERROR_MISC, "");
            bio = BIO_new_connect(endpoint_nonconst);
            free(endpoint_nonconst);
        }

        THROW_CTEXCEPTION_IF(bio == NULL, CT_ERROR_NET, "");

        THROW_CTEXCEPTION_IF(BIO_do_connect(bio) <= 0, CT_ERROR_NET, "");

        SSL_set_bio(ssl, bio, bio);
        // SSL_set_mode(ssl, SSL_MODE_AUTO_RETRY);
        THROW_CTEXCEPTION_IF(SSL_connect(ssl) != 1, CT_ERROR_NET, "");

        // -------------------- check certs ---------------------
        X509* x509 = SSL_get_peer_certificate(ssl);
        THROW_CTEXCEPTION_IF(!x509, CT_ERROR_NET, "");
        char name[256];
        //char issuer[256];
        memset(name, 0, sizeof name);
        //memset(issuer, 0, sizeof issuer);
        // XXX
        //X509_NAME_get_text_by_NID(X509_get_subject_name(x509), NID_commonName, name, sizeof name-1);
        //X509_NAME_get_text_by_NID(X509_get_issuer_name(x509), NID_commonName, issuer, sizeof issuer-1);
        //if (!(strcmp(name, Common_Name)==0 ))
        //{
        //    X509_free(x509);
        //    THROW_CTEXCEPTION(CT_ERROR_NET);
        //}
        X509_free(x509);

        // ------------------------- Send request -------------------------
        string req = getRequestString();
        if ( SSL_write(ssl, req.c_str(),req.length()) < 1 )
        {
            //ERR_print_errors_fp(stderr);
            //SSL_free(ssl);
            THROW_CTEXCEPTION(CT_ERROR_NET,"can't send http request");
        }

        // ---------------------- Reseive response ------------------------
        string res;
        char buf[GENERAL_ENOUGH_BUFFER_SIZE];
        memset(buf, 0, sizeof(buf));
        while (true)
        {
            int read_size = 0;
            read_size = SSL_read(ssl, buf,sizeof(buf) - 1);
            if ( read_size > 0 )
            {
                res += buf;
            }
            else if ( read_size == 0 )
            {
				THROW_CTEXCEPTION_IF(res.size() == 0, CT_ERROR_NET,"");
                break;
            }
            else
            {
                THROW_CTEXCEPTION(CT_ERROR_NET,res);
            }
        }
        return getEndpoint(res);
    }
    catch (CTException e)
    {
        if (ssl != NULL)
        {
            int ret = SSL_shutdown(ssl);
            if (ret == 0)
            {
                ret = SSL_shutdown(ssl);
                if (ret == -1)
                {
                    //SSL_free(ssl);
                }
            }
            else if (ret == -1)
            {
                //SSL_free(ssl);
            }
            else
            {
                //SSL_free(ssl);
            }
            SSL_free(ssl);
        }
        throw(e);
    }

    // illegal program path.
    abort();
    return string();
}

/**
 * F،̐ڑp̂߂̐ڑ悩
 * JavaAvbg̃G~[g(ڑp)pAopenssllbg[NBIO𓾂
 */
BIO* CTConnection::getJavaEmulationBIO(const std::string endpoint) const
{
    BIO *newBio = NULL;

    try
    {
        // ------------------------- BIO -------------------------
        {
            // constObiȍ
            char* endpoint_nonconst = strdup(endpoint.c_str());
            if (endpoint_nonconst == NULL)
            {
                THROW_CTEXCEPTION(CT_ERROR_MISC, "");
            }
            newBio = BIO_new_connect(endpoint_nonconst);
            BIO_set_nbio(newBio, 1); // non-blocking
            free(endpoint_nonconst);
        }

        // ڑ
        while (true)
        {
            int result = BIO_do_connect(newBio);

            if (result == 1)
            {
                // The connection was established successfully.
                break;
            }
            else if (result <= 0)
            {
                // The connection could not be established
                THROW_CTEXCEPTION_IF(!BIO_should_retry(newBio), CT_ERROR_NET,"");
            }
        }

        // [U[̑M
        if (!::CT_NBIO_write(newBio, settings.get("userid") + "\r\n\r\n"))
        {
            THROW_CTEXCEPTION(CT_ERROR_NET,"");
        }

        // M
        {
            string response;
            while (true)
            {
                char buf[GENERAL_ENOUGH_BUFFER_SIZE];
                memset(buf,0,sizeof(buf));
                int i=BIO_read(newBio,buf,sizeof(buf)-1);

                if (i > 0)
                {
                    // ɎM
                    response = response + buf;
                    _debug_out<<"server: " << response << endl;
                    break; //XXX
                }
                else if (BIO_should_retry(newBio))
                {
                    // gCv
                }
                else
                {
                    // ُ
                    THROW_CTEXCEPTION(CT_ERROR_NET, "");
                }
            }
        }

        // p(hello)̑M
        if (!::CT_NBIO_write(newBio, "hello\r\n\r\n"))
        {
            THROW_CTEXCEPTION(CT_ERROR_NET, "");
        }

        return newBio;
    }
    catch (CTException e)
    {
        BIO_free(newBio);
        throw e;
    }
}


/**
 * ڑōs
 */
CTSTATUS CTConnection::process()
{
    try
    {
        // ڑppopenssllbg[NbioĂȂꍇ
        if (javaEmulationBio == NULL)
        {
            // F؂sAڑpp̐ڑ𓾂
            std::string endpoint = connectNetworkAuthentication();
            // ڑppopenssllbg[Nbio𓾂
            javaEmulationBio = getJavaEmulationBIO(endpoint);
        }

        // ڑp(JAVAAvbg̃G~[g)
        while (true)
        {
            // pǂݍ
            string response;
            while (true)
            {
                char buf[GENERAL_ENOUGH_BUFFER_SIZE];
                memset(buf,0,sizeof(buf));
                int length=BIO_read(javaEmulationBio,buf,sizeof(buf)-1);

                if (length > 0)
                {
                    // MAݏɈڍs
                    // XXX{͍Ō܂ŎMȂ΂ȂȂǁAʓ|̂Ŏɐi
                    response = response + buf;
                    _debug_out << "server: " << response << endl;
                    break;
                }
                else if (BIO_should_retry(javaEmulationBio))
                {
                    // gCv
                    // xreturnAprocess()֐ǂݍ܂ꂽۂɃgC
                    return CT_CONNECTING;
                }
                else
                {
                    // ُ
                    THROW_CTEXCEPTION(CT_ERROR_NET, "");
                }
            }

            // p񏑂
            if (!::CT_NBIO_write(javaEmulationBio, "hello\r\n\r\n"))
            {
                THROW_CTEXCEPTION(CT_ERROR_NET, "");
            }
        }
    }
    catch (CTException e)
    {
        // G[N
        lastError = e.error;
        reset();
        _debug_out << "line: " << e.position  << ", err: " << e.error << ", desc: " << e.description << std::endl;
        return CT_ERROR;
    }
}

void CTConnection::reset()
{
    if (javaEmulationBio != NULL)
    {
        BIO_free(javaEmulationBio);
        javaEmulationBio = NULL;
    }
}

CTConnection::CTConnection()
        : javaEmulationBio(NULL)
{
    SSL_library_init();
}
CTConnection::~CTConnection()
{
    reset();
}
void CTConnection::setSettings(const CTSettings _settings)
{
    settings = _settings;
}
CTSettings CTConnection::getSettings() const
{
    return settings;
}

CTERROR CTConnection::getLastError(void) const
{
    return lastError;
}
