/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.searcher.widget;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.plugin.SearcherPlugin;
import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.plugin.searcher.data.ConjunctionType;
import jp.sourceforge.concierge.plugin.searcher.data.WordCondition;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.XPathString;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordComposite
extends Composite {
    private static Image addImage = null;
    private static Image delImage = null;
    private static Image delImage_not = null;
    private Group wordGp = null;
    private ArrayList<WordComposite> wordCompList = new ArrayList();
    private Button rbtAND;
    private Button rbtOR;
    private Action updateAction = null;
    private KeyListener keyListener = null;
    private ModifyListener modListener = null;

    static {
        addImage = SearcherPlugin.getImageDescriptor("icons/catplus_b.png").createImage();
        delImage = SearcherPlugin.getImageDescriptor("icons/catminus_b.png").createImage();
        delImage_not = SearcherPlugin.getImageDescriptor("icons/catminus_g.png").createImage();
    }

    public void setUpdateAction(Action act) {
        this.updateAction = act;
    }

    public KeywordComposite(Composite comp, int style) {
        super(comp, style);
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.setLayout((Layout)gl);
        this.wordGp = new Group((Composite)this, 0);
        this.wordGp.setLayoutData((Object)new GridData(1808));
        this.wordGp.setLayout((Layout)new GridLayout(1, false));
        this.wordGp.setText("Search words");
        Composite toggleCp = new Composite((Composite)this.wordGp, 0);
        toggleCp.setLayoutData((Object)new GridData(768));
        toggleCp.setLayout((Layout)new GridLayout(2, false));
        this.rbtAND = new Button(toggleCp, 16);
        this.rbtAND.setText("AND");
        this.rbtAND.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (KeywordComposite.this.updateAction != null) {
                    KeywordComposite.this.updateAction.run();
                }
            }
        });
        this.rbtAND.setLayoutData((Object)new GridData(0));
        this.rbtOR = new Button(toggleCp, 16);
        this.rbtOR.setText("OR");
        this.rbtOR.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (KeywordComposite.this.updateAction != null) {
                    KeywordComposite.this.updateAction.run();
                }
            }
        });
        this.rbtOR.setLayoutData((Object)new GridData(0));
        Label rbtbl = new Label(toggleCp, 258);
        GridData lgd = new GridData(768);
        lgd.horizontalSpan = 2;
        rbtbl.setLayoutData((Object)lgd);
        this.setAND();
        this.addWordComposite("All type", "All item", "", WordCondition.ConditionType.ALLWORDS);
    }

    private void addWordComposite(String type, String item, String str, WordCondition.ConditionType condition) {
        WordComposite comp = new WordComposite((Composite)this.wordGp, 0);
        comp.setType(type);
        comp.setItem(item);
        comp.setText(str);
        comp.setCondition(condition);
        this.wordCompList.add(comp);
        if (this.updateAction != null) {
            this.updateAction.run();
        }
    }

    private void deleteWordComposite(WordComposite comp) {
        this.wordCompList.remove((Object)comp);
        comp.dispose();
        if (this.updateAction != null) {
            this.updateAction.run();
        }
    }

    private void setAND() {
        this.rbtAND.setSelection(true);
        this.rbtOR.setSelection(false);
    }

    private void setOR() {
        this.rbtAND.setSelection(false);
        this.rbtOR.setSelection(true);
    }

    public boolean isAnd() {
        return this.rbtAND.getSelection();
    }

    public ArrayList<WordCondition> getWordConditions() {
        ArrayList<WordCondition> wcs = new ArrayList<WordCondition>();
        int i = 0;
        while (i < this.wordCompList.size()) {
            WordComposite wc = this.wordCompList.get(i);
            WordCondition w = new WordCondition();
            w.type = wc.getType();
            w.item = wc.getItem();
            w.text = wc.getText();
            w.condition = wc.getCondition();
            wcs.add(w);
            ++i;
        }
        return wcs;
    }

    public void setWordConditions(ArrayList<WordCondition> wcs) {
        int i = 0;
        while (i < this.wordCompList.size()) {
            this.wordCompList.get(i).dispose();
            ++i;
        }
        this.wordCompList.clear();
        i = 0;
        while (i < wcs.size()) {
            WordCondition wc = wcs.get(i);
            this.addWordComposite(wc.type, wc.item, wc.text, wc.condition);
            ++i;
        }
        if (wcs.size() == 0) {
            this.addWordComposite("All type", "All item", "", WordCondition.ConditionType.ALLWORDS);
        }
        this.wordGp.layout();
    }

    public void save(Element info) {
        ArrayList<WordCondition> wcs = this.getWordConditions();
        Configure.setKeywords(info, wcs);
        if (this.isAnd()) {
            Configure.setConjunction(info, ConjunctionType.AND);
        } else {
            Configure.setConjunction(info, ConjunctionType.OR);
        }
    }

    public void load(Element info) {
        ArrayList<WordCondition> wcs = Configure.getKeywords(info);
        this.setWordConditions(wcs);
        ConjunctionType ct = Configure.getConjunction(info);
        if (ct == ConjunctionType.AND) {
            this.setAND();
        } else {
            this.setOR();
        }
    }

    public void update() {
        WordComposite comp;
        int i = 0;
        while (i < this.wordCompList.size()) {
            comp = this.wordCompList.get(i);
            comp.update();
            ++i;
        }
        if (this.wordCompList.size() == 1) {
            WordComposite comp2 = this.wordCompList.get(0);
            comp2.setEnabledDelButton(false);
        } else {
            i = 0;
            while (i < this.wordCompList.size()) {
                comp = this.wordCompList.get(i);
                comp.setEnabledDelButton(true);
                ++i;
            }
        }
    }

    public String getXPath() {
        String inj = "";
        inj = this.rbtAND.getSelection() ? " and " : " or ";
        String xp = "";
        int i = 0;
        while (i < this.wordCompList.size()) {
            String wxp = this.wordCompList.get(i).getXPath();
            if (wxp.length() != 0) {
                if (xp.length() > 0) {
                    xp = String.valueOf(xp) + inj;
                }
                xp = String.valueOf(xp) + "(" + wxp + ")";
            }
            ++i;
        }
        return xp;
    }

    public void addKeyListener(KeyListener listener) {
        this.keyListener = listener;
    }

    public void addModifyListener(ModifyListener listener) {
        this.modListener = listener;
    }

    public class WordComposite
    extends Composite {
        private final String[] WORD_CONDITIONS;
        private static final String ALL_TYPES = "All type";
        private static final String ALL_ITEMS = "All item";
        private static final String ONLY_FILE = "File name";
        private static final String ONLY_FILEINFO = "File information";
        private static final int BACK_COLOR = 15;
        private Composite parent;
        private Combo types;
        private Combo items;
        private Text inputText;
        private Combo suffixCombo;
        private ImageHyperlink delcatbtn;

        private String getTypePredicate(String type) {
            return "data[" + XPathString.getAttributeEqualsPredicate((String)"name", (String)type) + "]";
        }

        private String getAllWordsXPath() {
            String v = this.inputText.getText().trim();
            if (v.length() == 0) {
                return "";
            }
            String pred = this.isAllType() ? "" : String.valueOf(this.getTypePredicate(this.types.getText())) + " and ";
            String[] words = v.split(" ");
            ArrayList<String> ws = new ArrayList<String>();
            int i = 0;
            while (i < words.length) {
                ws.add(words[i]);
                ++i;
            }
            String predstr = "[" + XPathString.getElementContainsPredicate(ws, (String)" and ", (boolean)true, (boolean)false) + "]";
            pred = this.isFileSearch() ? String.valueOf(pred) + XPathString.getAttributeContainsPredicate((String)"filename", ws, (String)" and ", (boolean)false) : (this.isFileInformation() ? String.valueOf(pred) + "fileinfo" + predstr : (this.isAllItem() ? String.valueOf(pred) + "data" + predstr + " or " + "fileinfo" + predstr : String.valueOf(pred) + "data" + "/" + this.items.getText() + predstr));
            return pred;
        }

        private String getPhraseXPath() {
            String v = this.inputText.getText().trim();
            if (v.length() == 0) {
                return "";
            }
            String pred = this.isAllType() ? "" : String.valueOf(this.getTypePredicate(this.types.getText())) + " and ";
            String predstr = "[" + XPathString.getElementContainsPredicate((String)v, (boolean)true) + "]";
            pred = this.isFileSearch() ? String.valueOf(pred) + XPathString.getAttributeContainsPredicate((String)"filename", (String)v) : (this.isFileInformation() ? String.valueOf(pred) + "fileinfo" + predstr : (this.isAllItem() ? String.valueOf(pred) + "data" + predstr + " or " + "fileinfo" + predstr : String.valueOf(pred) + "data" + "/" + this.items.getText() + predstr));
            return pred;
        }

        private String getAtLeastXPath() {
            String v = this.inputText.getText().trim();
            if (v.length() == 0) {
                return "";
            }
            String pred = this.isAllType() ? "" : String.valueOf(this.getTypePredicate(this.types.getText())) + " and ";
            String[] words = v.split(" ");
            ArrayList<String> ws = new ArrayList<String>();
            int i = 0;
            while (i < words.length) {
                ws.add(words[i]);
                ++i;
            }
            String predstr = "[" + XPathString.getElementContainsPredicate(ws, (String)" or ", (boolean)true, (boolean)false) + "]";
            pred = this.isFileSearch() ? String.valueOf(pred) + XPathString.getAttributeContainsPredicate((String)"filename", ws, (String)" or ", (boolean)false) : (this.isFileInformation() ? String.valueOf(pred) + "fileinfo" + predstr : (this.isAllItem() ? String.valueOf(pred) + "data" + predstr + " or " + "fileinfo" + predstr : String.valueOf(pred) + "data" + "/" + this.items.getText() + predstr));
            return pred;
        }

        private String getNoneXPath() {
            String v = this.inputText.getText().trim();
            if (v.length() == 0) {
                return "";
            }
            String pred = this.isAllType() ? "" : String.valueOf(this.getTypePredicate(this.types.getText())) + " and ";
            String[] words = v.split(" ");
            ArrayList<String> ws = new ArrayList<String>();
            int i = 0;
            while (i < words.length) {
                ws.add(words[i]);
                ++i;
            }
            String predstr = "[" + XPathString.getElementContainsPredicate(ws, (String)" or ", (boolean)true, (boolean)true) + "]";
            pred = this.isFileSearch() ? String.valueOf(pred) + XPathString.getAttributeContainsPredicate((String)"filename", ws, (String)" or ", (boolean)true) : (this.isFileInformation() ? String.valueOf(pred) + "fileinfo" + predstr : (this.isAllItem() ? String.valueOf(pred) + "data" + predstr + " and " + "fileinfo" + predstr : String.valueOf(pred) + "data" + "/" + this.items.getText() + predstr));
            return pred;
        }

        public Composite getParent() {
            return this.parent;
        }

        public String getType() {
            return this.types.getText();
        }

        public void setType(String type) {
            this.types.setText(type);
        }

        public String getItem() {
            return this.items.getText();
        }

        public void setItem(String item) {
            this.items.setText(item);
        }

        public String getText() {
            return this.inputText.getText();
        }

        public void setText(String text) {
            this.inputText.setText(text);
        }

        public WordCondition.ConditionType getCondition() {
            switch (this.suffixCombo.getSelectionIndex()) {
                case 0: {
                    return WordCondition.ConditionType.ALLWORDS;
                }
                case 1: {
                    return WordCondition.ConditionType.PHRASE;
                }
                case 2: {
                    return WordCondition.ConditionType.ATLEAST;
                }
                case 3: {
                    return WordCondition.ConditionType.NONE;
                }
            }
            return WordCondition.ConditionType.ALLWORDS;
        }

        public void setCondition(WordCondition.ConditionType condition) {
            switch (condition) {
                case ALLWORDS: {
                    this.suffixCombo.select(0);
                    break;
                }
                case PHRASE: {
                    this.suffixCombo.select(1);
                    break;
                }
                case ATLEAST: {
                    this.suffixCombo.select(2);
                    break;
                }
                case NONE: {
                    this.suffixCombo.select(3);
                }
            }
        }

        public boolean isFileSearch() {
            return this.items.getSelectionIndex() == 1;
        }

        public boolean isAllType() {
            return this.types.getSelectionIndex() == 0;
        }

        public boolean isAllItem() {
            return this.items.getSelectionIndex() == 0;
        }

        public boolean isFileInformation() {
            return this.items.getSelectionIndex() == 2;
        }

        public void setEnabledDelButton(boolean b) {
            this.delcatbtn.setEnabled(b);
            if (b) {
                this.delcatbtn.setImage(delImage);
            } else {
                this.delcatbtn.setImage(delImage_not);
            }
        }

        private void resetItemCombo() {
            this.items.removeAll();
            this.items.add(ALL_ITEMS);
            this.items.add(ONLY_FILE);
            this.items.add(ONLY_FILEINFO);
            this.items.select(0);
        }

        public WordComposite(Composite comp, int style) {
            super(comp, style);
            this.WORD_CONDITIONS = new String[]{"all these words", "this exact wording or phrase", "one or more of these words", "none of these words"};
            this.parent = null;
            this.types = null;
            this.items = null;
            this.inputText = null;
            this.suffixCombo = null;
            this.delcatbtn = null;
            this.parent = comp;
            GridLayout gl = new GridLayout(6, false);
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            this.setLayout((Layout)gl);
            this.setLayoutData(new GridData(768));
            this.types = new Combo((Composite)this, 12);
            this.types.setLayoutData((Object)new GridData(0));
            this.types.add(ALL_TYPES);
            ArrayList<String> tnames = SearcherPlugin.getAllTypeNames();
            int i = 0;
            while (i < tnames.size()) {
                this.types.add(tnames.get(i));
                ++i;
            }
            this.types.select(0);
            this.types.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    WordComposite.this.resetItemCombo();
                    if (WordComposite.this.types.getSelectionIndex() == 0) {
                        return;
                    }
                    Document doc = SearcherPlugin.getTypeDocument(WordComposite.this.types.getText());
                    ArrayList elems = TypeDomImpl.getAllElements((Document)doc);
                    int i = 0;
                    while (i < elems.size()) {
                        WordComposite.this.items.add(TypeDomImpl.getElementName((Element)((Element)elems.get(i))));
                        ++i;
                    }
                }
            });
            this.items = new Combo((Composite)this, 0x80000C);
            GridData itgd = new GridData(0);
            itgd.horizontalSpan = 5;
            itgd.horizontalAlignment = 16384;
            this.items.setLayoutData((Object)itgd);
            this.resetItemCombo();
            this.inputText = new Text((Composite)this, 2180);
            this.inputText.setSize(100, 18);
            GridData igd = new GridData(768);
            igd.horizontalSpan = 3;
            this.inputText.setLayoutData((Object)igd);
            this.inputText.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (KeywordComposite.this.keyListener != null) {
                        KeywordComposite.this.keyListener.keyPressed(e);
                    }
                }

                public void keyReleased(KeyEvent e) {
                    if (KeywordComposite.this.keyListener != null) {
                        KeywordComposite.this.keyListener.keyReleased(e);
                    }
                }
            });
            this.inputText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (KeywordComposite.this.modListener != null) {
                        KeywordComposite.this.modListener.modifyText(e);
                    }
                }
            });
            this.suffixCombo = new Combo((Composite)this, 8);
            int i2 = 0;
            while (i2 < this.WORD_CONDITIONS.length) {
                this.suffixCombo.add(this.WORD_CONDITIONS[i2]);
                ++i2;
            }
            this.suffixCombo.select(0);
            ImageHyperlink addcatbtn = new ImageHyperlink((Composite)this, 0x800000);
            addcatbtn.setLayoutData((Object)new GridData(128));
            addcatbtn.setImage(addImage);
            GraphicUtil.setBackground((Control)addcatbtn, (int)15);
            addcatbtn.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent e) {
                    KeywordComposite.this.addWordComposite(WordComposite.ALL_TYPES, WordComposite.ALL_ITEMS, "", WordCondition.ConditionType.ALLWORDS);
                    WordComposite.this.parent.getParent().getParent().layout();
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }
            });
            this.delcatbtn = new ImageHyperlink((Composite)this, 0x800000);
            this.delcatbtn.setLayoutData((Object)new GridData(128));
            this.delcatbtn.setImage(delImage);
            GraphicUtil.setBackground((Control)this.delcatbtn, (int)15);
            this.delcatbtn.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent e) {
                    WordComposite comp = WordComposite.this;
                    KeywordComposite pare = (KeywordComposite)comp.getParent().getParent();
                    pare.deleteWordComposite(comp);
                    WordComposite.this.parent.getParent().getParent().layout();
                }

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }
            });
        }

        protected void handleShellCloseEvent() {
            if (delImage != null) {
                delImage.dispose();
            }
            if (addImage != null) {
                delImage.dispose();
            }
        }

        public void update() {
            super.update();
            this.delcatbtn.redraw();
        }

        public String getXPath() {
            String textval = this.inputText.getText().trim();
            if (textval.length() == 0) {
                return "";
            }
            switch (this.getCondition()) {
                case ALLWORDS: {
                    return this.getAllWordsXPath();
                }
                case PHRASE: {
                    return this.getPhraseXPath();
                }
                case ATLEAST: {
                    return this.getAtLeastXPath();
                }
                case NONE: {
                    return this.getNoneXPath();
                }
            }
            return "";
        }
    }
}

