/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateThread;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.plugin.ProjectBrowserPlugin;
import jp.sourceforge.concierge.plugin.projectbrowser.ProjectUtils;
import jp.sourceforge.concierge.plugin.projectbrowser.actions.EditAction;
import jp.sourceforge.concierge.plugin.projectbrowser.actions.MoveAction;
import jp.sourceforge.concierge.plugin.projectbrowser.actions.RefreshAction;
import jp.sourceforge.concierge.plugin.projectbrowser.actions.RenameAction;
import jp.sourceforge.concierge.util.FileLauncher;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectBrowser
extends ViewPart {
    private TableViewer projectview;
    private TableViewer contentview;
    private Action editAction;
    private Action deleteAction;
    private Action openAction;
    private Action renameAction;
    private Action moveAction;
    private Action refreshAction;
    private ISelectionChangedListener sellistener = null;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        SashForm sf = new SashForm(parent, 256);
        sf.setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectview = new TableViewer((Composite)sf, 774);
        this.projectview.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.projectview.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectview.setInput(ProjectUtils.getProjects());
        this.projectview.getTable().setLinesVisible(true);
        this.projectview.getTable().setHeaderVisible(true);
        Table tbl = this.projectview.getTable();
        TableColumn tc = new TableColumn(tbl, 16384);
        tc.setText("Project");
        tc.setResizable(false);
        tc.setMoveable(false);
        tc.setWidth(1000);
        this.sellistener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel == null) {
                    return;
                }
                Document doc = (Document)sel.getFirstElement();
                ArrayList<Document> docs = ProjectUtils.getProjectFiles(doc);
                ProjectBrowser.this.contentview.setInput(docs);
            }
        };
        this.projectview.addSelectionChangedListener(this.sellistener);
        this.contentview = new TableViewer((Composite)sf, 66306);
        this.contentview.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.contentview.setLabelProvider((IBaseLabelProvider)new ProjectFileLabelProvider());
        this.contentview.getTable().setLinesVisible(true);
        this.contentview.getTable().setHeaderVisible(true);
        sf.setWeights(new int[]{30, 70});
        tbl = this.contentview.getTable();
        tc = new TableColumn(tbl, 16384);
        tc.setText("File");
        tc.setResizable(true);
        tc.setMoveable(false);
        tc.setWidth(100);
        tc = new TableColumn(tbl, 16384);
        tc.setText("Length");
        tc.setResizable(true);
        tc.setMoveable(false);
        tc.setWidth(100);
        tc = new TableColumn(tbl, 16384);
        tc.setText("Last modified date");
        tc.setResizable(true);
        tc.setMoveable(false);
        tc.setWidth(300);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        FrameworkPlugin.addDatabaseListener((String)"data", (ICCGUpdateListener)new CCGUpdateThread(this.projectview.getControl(), new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                if (!ev.collection.equals("data")) {
                    return;
                }
                if (!ev.success.booleanValue()) {
                    return;
                }
                IStructuredSelection psel = (IStructuredSelection)ProjectBrowser.this.projectview.getSelection();
                ProjectBrowser.this.projectview.setInput(ProjectUtils.getProjects());
                if (psel != null && !psel.isEmpty()) {
                    ProjectBrowser.this.projectview.setSelection((ISelection)new StructuredSelection(psel.toList()));
                }
            }
        }));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#ProjectPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProjectBrowser.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.projectview.getControl());
        this.projectview.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.projectview);
        menuMgr = new MenuManager("#FilePopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProjectBrowser.this.fillContextMenu(manager);
            }
        });
        menu = menuMgr.createContextMenu(this.contentview.getControl());
        this.contentview.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.contentview);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.editAction);
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        String name = ((MenuManager)manager).getMenuText();
        manager.add((IAction)this.editAction);
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.renameAction);
        if (name.equals("#ProjectPopupMenu")) {
            manager.add((IAction)this.moveAction);
            manager.add((IAction)this.refreshAction);
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.editAction);
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.renameAction);
        manager.add((IAction)this.moveAction);
        manager.add((IAction)this.refreshAction);
    }

    private void deleteDocuments(ArrayList<Document> docs) {
        Request r = new Request(2, docs, "data");
        ArrayList<Request> rs = new ArrayList<Request>();
        rs.add(r);
        FrameworkPlugin.updateDocuments(rs, (Object)"jp.sourceforge.concierge.plugin.projectbrowser");
    }

    private void makeActions() {
        this.openAction = new Action(){

            public void run() {
                if (ProjectBrowser.this.projectview.getControl().isFocusControl()) {
                    IStructuredSelection sel = (IStructuredSelection)ProjectBrowser.this.projectview.getSelection();
                    if (sel == null) {
                        return;
                    }
                    Document doc = (Document)sel.getFirstElement();
                    FileLauncher.LaunchFile((Document)doc);
                } else {
                    IStructuredSelection sel = (IStructuredSelection)ProjectBrowser.this.contentview.getSelection();
                    if (sel == null) {
                        return;
                    }
                    for (Document doc : sel) {
                        FileLauncher.LaunchFile((Document)doc);
                    }
                }
            }
        };
        this.openAction.setText("Open files");
        this.openAction.setToolTipText("Open selected files");
        this.openAction.setImageDescriptor(ProjectBrowserPlugin.getImageDescriptor("icons/openfile.png"));
        this.deleteAction = new Action(){

            public void run() {
                if (ProjectBrowser.this.projectview.getControl().isFocusControl()) {
                    IStructuredSelection sel = (IStructuredSelection)ProjectBrowser.this.projectview.getSelection();
                    if (sel == null) {
                        return;
                    }
                    if (!MessageDialog.openConfirm((Shell)ProjectBrowser.this.projectview.getTable().getShell(), (String)"Project Browser", (String)"Delete all project items(not delete files). OK?")) {
                        return;
                    }
                    Document doc = (Document)sel.getFirstElement();
                    ArrayList<Document> docs = ProjectUtils.getProjectFiles(doc);
                    docs.add(doc);
                    ProjectBrowser.this.deleteDocuments(docs);
                } else {
                    IStructuredSelection sel = (IStructuredSelection)ProjectBrowser.this.contentview.getSelection();
                    if (sel == null) {
                        return;
                    }
                    if (!MessageDialog.openConfirm((Shell)ProjectBrowser.this.contentview.getTable().getShell(), (String)"Project Browser", (String)"Delete items(not delete files). OK?")) {
                        return;
                    }
                    ArrayList<Document> ndocs = new ArrayList<Document>();
                    Iterator it = sel.iterator();
                    while (it.hasNext()) {
                        ndocs.add((Document)it.next());
                    }
                    ProjectBrowser.this.deleteDocuments(ndocs);
                }
            }
        };
        this.deleteAction.setText("Delete items");
        this.deleteAction.setToolTipText("Delete selected items(not delete file)");
        this.deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.renameAction = new RenameAction(this.projectview, this.contentview);
        this.renameAction.setText("Rename");
        this.renameAction.setToolTipText("Rename project/file");
        this.renameAction.setImageDescriptor(ProjectBrowserPlugin.getImageDescriptor("icons/rename.png"));
        this.moveAction = new MoveAction(this.projectview, this.contentview);
        this.moveAction.setText("Move project");
        this.moveAction.setToolTipText("Move project");
        this.moveAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        this.refreshAction = new RefreshAction(this.projectview, this.contentview);
        this.refreshAction.setText("Refresh project");
        this.refreshAction.setToolTipText("Refresh project");
        this.refreshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
        this.editAction = new EditAction(this.projectview, this.contentview);
        this.editAction.setText("Edit metadata");
        this.editAction.setToolTipText("Edit metadata");
        this.editAction.setImageDescriptor(ProjectBrowserPlugin.getImageDescriptor("icons/editmetadata.png"));
    }

    public void setFocus() {
        this.projectview.getControl().setFocus();
    }

    class ProjectContentProvider
    implements IStructuredContentProvider {
        ProjectContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }

    class ProjectFileLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ProjectFileLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Document doc = (Document)obj;
            Element e = DataDomImpl.getDataOfType((Document)doc, (String)"Project");
            if (e == null) {
                return null;
            }
            TableColumn tc = ProjectBrowser.this.contentview.getTable().getColumn(index);
            String title = tc.getText();
            if (title.equals("File")) {
                return DataDomImpl.getFileName((Document)doc);
            }
            if (title.equals("Length")) {
                String path = DataDomImpl.getFilePath((Document)doc);
                File f = new File(path);
                if (!f.exists()) {
                    return "No file";
                }
                return String.valueOf(f.length());
            }
            if (title.equals("Last modified date")) {
                String path = DataDomImpl.getFilePath((Document)doc);
                File f = new File(path);
                if (!f.exists()) {
                    return null;
                }
                return new Date(f.lastModified()).toString();
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            TableColumn tc = ProjectBrowser.this.contentview.getTable().getColumn(index);
            String title = tc.getText();
            if (title.equals("File")) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    class ProjectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ProjectLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Document doc = (Document)obj;
            Element e = DataDomImpl.getDataOfType((Document)doc, (String)"Project");
            if (e == null) {
                return null;
            }
            return DataDomImpl.getFileName((Document)doc);
        }

        public Image getColumnImage(Object obj, int index) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

