/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.xoonipslink2.preferences.importpreference;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.plugin.XooNIpsConnection;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.MappingField;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.importpreference.ImportMappingData;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.importpreference.ImportMappingDataDomImpl;
import jp.sourceforge.xoonips.XooNIpsException;
import jp.sourceforge.xoonips.XooNIpsItemType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CurrentImportMappingDataList
extends ImportMappingDataDomImpl {
    private Hashtable<String, ImportMappingData> currentMappingDataList = null;
    private XooNIpsConnection xoonipsConnection = null;

    public CurrentImportMappingDataList(XooNIpsConnection xoonipsConnection) {
        this.xoonipsConnection = xoonipsConnection;
    }

    public void clearCurrentMappingDataList() {
        if (this.currentMappingDataList != null) {
            this.currentMappingDataList.clear();
            this.currentMappingDataList = null;
        }
    }

    public void readCurrentMappingDataList() {
        this.clearCurrentMappingDataList();
        this.currentMappingDataList = new Hashtable();
        try {
            XooNIpsItemType[] xnpItemTypes = this.xoonipsConnection.getXooNIpsSession().getItemTypeList();
            int i = 0;
            while (i < xnpItemTypes.length) {
                XooNIpsItemType xnpItemType = xnpItemTypes[i];
                ImportMappingData mappingData = this.readCurrentMappingData(xnpItemType.getTypeName());
                if (mappingData == null) {
                    mappingData = new ImportMappingData(xnpItemType);
                }
                this.currentMappingDataList.put(xnpItemType.getTypeName(), mappingData);
                ++i;
            }
        }
        catch (XooNIpsException xooNIpsException) {
        }
        catch (Exception exception) {}
    }

    private ImportMappingData readCurrentMappingData(String xoonipsItemType) {
        Document doc;
        Element rootElem;
        String selectString;
        String xpath = "/importmappingdata[@xoonipsitemtype='" + xoonipsItemType + "']";
        Request req = new Request(4, (Object)xpath, "xoonipslink");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        if (docs.size() > 0 && (selectString = (rootElem = (doc = (Document)docs.get(0)).getDocumentElement()).getAttribute("select")) != null && selectString.length() > 0) {
            int select = Integer.valueOf(selectString);
            int count = 0;
            Node dataNode = rootElem.getFirstChild();
            while (dataNode != null) {
                if (dataNode.getNodeType() == 1) {
                    if (count == select) {
                        ArrayList<MappingField> fieldsAL = new ArrayList<MappingField>();
                        Hashtable<String, ArrayList<String>> fieldsHT = new Hashtable<String, ArrayList<String>>();
                        Node fieldNode = dataNode.getFirstChild();
                        while (fieldNode != null) {
                            if (fieldNode.getNodeType() == 1) {
                                String dstValue = "";
                                Element fieldElement = (Element)fieldNode;
                                NodeList dstNodeList = fieldElement.getElementsByTagName("dst");
                                if (dstNodeList.getLength() > 0) {
                                    Element dstElem = (Element)dstNodeList.item(0);
                                    NodeList nl = dstElem.getChildNodes();
                                    int k = 0;
                                    while (k < nl.getLength()) {
                                        Node n = nl.item(k);
                                        if (n.getNodeType() == 3) {
                                            dstValue = String.valueOf(dstValue) + n.getNodeValue();
                                        }
                                        ++k;
                                    }
                                }
                                MappingField mappingField = new MappingField(dstValue);
                                NodeList srcNodeList = fieldElement.getElementsByTagName("src");
                                int i = 0;
                                while (i < srcNodeList.getLength()) {
                                    Element srcElem = (Element)srcNodeList.item(i);
                                    String srcValue = "";
                                    NodeList nl = srcElem.getChildNodes();
                                    int k = 0;
                                    while (k < nl.getLength()) {
                                        Node n = nl.item(k);
                                        if (n.getNodeType() == 3) {
                                            srcValue = String.valueOf(srcValue) + n.getNodeValue();
                                        }
                                        ++k;
                                    }
                                    mappingField.addSrc(srcValue);
                                    ++i;
                                }
                                fieldsAL.add(mappingField);
                                fieldsHT.put(mappingField.getDst(), mappingField.getSrc());
                            }
                            fieldNode = fieldNode.getNextSibling();
                        }
                        String dataName = ((Element)dataNode).getAttribute("dataname");
                        ((Element)dataNode).getAttribute("pluginid");
                        String typename = ((Element)dataNode).getAttribute("typename");
                        return new ImportMappingData(dataName, TypeManager.getTypeDocument((String)typename), fieldsAL, fieldsHT);
                    }
                    ++count;
                }
                dataNode = dataNode.getNextSibling();
            }
        }
        return null;
    }

    public ImportMappingData getCurrentMappingData(String xnpItemTypeName) {
        if (this.currentMappingDataList == null) {
            this.readCurrentMappingDataList();
        }
        if (this.currentMappingDataList != null) {
            return this.currentMappingDataList.get(xnpItemTypeName);
        }
        return null;
    }
}

