/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.plugin.XooNIpsConnection;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.MappingField;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.MappingTableDialog;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference.EditExportDatasetListDialog;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference.EditSrcMappingFieldDialog;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference.ExportMappingData;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference.ExportMappingDataList;
import jp.sourceforge.xoonips.XooNIpsItemType;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExportPreferenceDialog
extends MappingTableDialog {
    public ExportPreferenceDialog(Shell parentShell, XooNIpsConnection xoonipsConnection) {
        super(parentShell, xoonipsConnection);
    }

    protected Control createSettingControl(Composite parent) {
        this.getShell().setText("Export Mapping Table");
        SashForm sf = new SashForm(parent, 256);
        sf.setLayoutData((Object)new GridData(1808));
        sf.setLayout((Layout)new FillLayout());
        this.createTypeTableViewer((Composite)sf);
        Composite composite = new Composite((Composite)sf, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createDatasetControls(composite);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        Composite upperComposite = new Composite((Composite)group, 0);
        upperComposite.setLayoutData((Object)new GridData(768));
        upperComposite.setLayout((Layout)new GridLayout(2, false));
        this.createDataNameControls(upperComposite);
        this.createDstTypeNameControls(upperComposite, "XooNIps Type:");
        Label separator = new Label(upperComposite, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        this.createMappingTableViewer((Composite)group, "XooNIps", "Concierge");
        sf.setWeights(new int[]{25, 75});
        return sf;
    }

    private ExportMappingDataList getSelectionTypeTableView() {
        Object obj;
        ISelection selection = this.typeTableView.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof ExportMappingDataList) {
            return (ExportMappingDataList)obj;
        }
        return null;
    }

    protected void initialize() {
        this.typeTableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (obj = selection.getFirstElement()) != null && obj instanceof ExportMappingDataList) {
                    ExportMappingDataList mappingDataList = (ExportMappingDataList)obj;
                    ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
                    ExportPreferenceDialog.this.datasetListCombo.setInput(mappingDataAL);
                    ExportPreferenceDialog.this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
                    ExportMappingData mappingData = null;
                    if (mappingDataList.getCurrentIndex() >= 0) {
                        mappingData = mappingDataAL.get(mappingDataList.getCurrentIndex());
                    }
                    ExportPreferenceDialog.this.setMappingDataToControls(mappingData);
                    return;
                }
                ExportPreferenceDialog.this.setMappingDataToControls(null);
                ExportPreferenceDialog.this.datasetListCombo.setInput(null);
            }
        });
        this.datasetListCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (obj = selection.getFirstElement()) != null && obj instanceof ExportMappingData) {
                    ExportMappingData mappingData = (ExportMappingData)obj;
                    ExportMappingDataList mappingDataList = ExportPreferenceDialog.this.getSelectionTypeTableView();
                    mappingDataList.setCurrentIndex(mappingData);
                    ExportPreferenceDialog.this.setMappingDataToControls(mappingData);
                    return;
                }
                ExportPreferenceDialog.this.mappingTableViewer.setInput(null);
            }
        });
        this.datasetEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                ExportMappingDataList mappingDataList = ExportPreferenceDialog.this.getSelectionTypeTableView();
                ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
                try {
                    XooNIpsItemType[] xnpItemTypes = ExportPreferenceDialog.this.xoonipsConnection.getXooNIpsSession().getItemTypeList();
                    EditExportDatasetListDialog dlg = new EditExportDatasetListDialog(button.getShell(), mappingDataAL, mappingDataList.getSrc(), xnpItemTypes);
                    if (dlg.open() == 0) {
                        ArrayList<ExportMappingData> al = dlg.getMappingDataList();
                        int i = mappingDataAL.size() - 1;
                        while (i >= 0) {
                            ExportMappingData srcObj = mappingDataAL.get(i);
                            if (!al.remove(srcObj)) {
                                mappingDataAL.remove(i);
                            }
                            --i;
                        }
                        if (al.size() > 0) {
                            mappingDataAL.addAll(al);
                            mappingDataList.setCurrentIndex(mappingDataAL.size() - 1);
                            ExportPreferenceDialog.this.datasetListCombo.refresh();
                            ExportPreferenceDialog.this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
                            ExportPreferenceDialog.this.setMappingDataToControls(mappingDataAL.get(mappingDataList.getCurrentIndex()));
                        }
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.mappingTableViewer.setLabelProvider((IBaseLabelProvider)new MappingViewLabelProvider());
        this.mappingTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null) {
                    MappingField mappingField = (MappingField)obj;
                    ExportMappingDataList mappingDataList = ExportPreferenceDialog.this.getSelectionTypeTableView();
                    EditSrcMappingFieldDialog dlg = new EditSrcMappingFieldDialog(ExportPreferenceDialog.this.mappingTableViewer.getControl().getShell(), mappingDataList.getSrc(), mappingField);
                    if (dlg.open() == 0) {
                        ExportPreferenceDialog.this.mappingTableViewer.update(obj, null);
                    }
                }
            }
        });
        ArrayList typedocs = TypeManager.getAllTypeDocuments((boolean)true, (boolean)true, (boolean)true);
        int i = 0;
        while (i < typedocs.size()) {
            ExportMappingDataList mappingDataList = new ExportMappingDataList((Document)typedocs.get(i));
            this.typeTableView.add((Object)mappingDataList);
            this.readDoc(mappingDataList);
            ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
            if (mappingDataAL.size() == 0) {
                try {
                    XooNIpsItemType[] xnpItemTypes = this.xoonipsConnection.getXooNIpsSession().getItemTypeList();
                    ExportMappingData mappingData = null;
                    int j = 0;
                    while (j < xnpItemTypes.length) {
                        if (xnpItemTypes[j].getTitle().equalsIgnoreCase(TypeDomImpl.getTypeName((Document)((Document)typedocs.get(i))))) {
                            mappingData = new ExportMappingData(xnpItemTypes[j], (Document)typedocs.get(i));
                            break;
                        }
                        ++j;
                    }
                    if (mappingData == null) {
                        mappingData = new ExportMappingData(xnpItemTypes[0], (Document)typedocs.get(i));
                    }
                    mappingDataAL.add(mappingData);
                    mappingDataList.setCurrentIndex(0);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        if (this.typeTableView.getTable().getItemCount() > 0) {
            this.typeTableView.getTable().select(0);
            ExportMappingDataList mappingDataList = (ExportMappingDataList)this.typeTableView.getElementAt(0);
            ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
            this.datasetListCombo.setInput(mappingDataAL);
            this.datasetListCombo.getCombo().select(mappingDataList.getCurrentIndex());
            ExportMappingData mappingData = null;
            if (mappingDataList.getCurrentIndex() >= 0) {
                mappingData = mappingDataAL.get(mappingDataList.getCurrentIndex());
            }
            this.setMappingDataToControls(mappingData);
        }
    }

    protected void DoSave() {
        this.typeTableView.getTable().setFocus();
        try {
            this.deleteMappingDataFromDB();
            this.saveMappingDataToDB();
            this.xoonipsConnection.getCurrentExportMappingDataList().readCurrentMappingDataList();
        }
        catch (Exception excp) {
            excp.getStackTrace();
        }
    }

    private void deleteMappingDataFromDB() {
        String xpath = "/exportmappingdata";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, (Object)xpath, "xoonipslink");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            reqs.add(new Request(2, (Object)docs, "xoonipslink"));
            FrameworkPlugin.updateDocuments(reqs, (boolean)true, (Object)"jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference");
            reqs = null;
        }
        docs = null;
    }

    private void saveMappingDataToDB() {
        ArrayList<Document> docs = new ArrayList<Document>();
        int i = 0;
        while (i < this.typeTableView.getTable().getItemCount()) {
            ExportMappingDataList mappingDataList = (ExportMappingDataList)this.typeTableView.getElementAt(i);
            Document doc = this.newDoc(mappingDataList);
            if (doc != null) {
                docs.add(doc);
            }
            ++i;
        }
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            reqs.add(new Request(1, docs, "xoonipslink"));
            FrameworkPlugin.updateDocuments(reqs, (boolean)true, (Object)"jp.sourceforge.concierge.plugin.xoonipslink2.preferences.exportpreference");
            Object var2_3 = null;
        }
        docs = null;
    }

    private Document newDoc(ExportMappingDataList mappingDataList) {
        Document doc = null;
        try {
            doc = DomImpl.createDocument((String)"exportmappingdata");
            Element rootElem = doc.getDocumentElement();
            rootElem.setAttribute("conciergeitemtype", mappingDataList.getSrcID());
            rootElem.setAttribute("select", String.valueOf(mappingDataList.getCurrentIndex()));
            ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
            int j = 0;
            while (j < mappingDataAL.size()) {
                ExportMappingData mappingData = mappingDataAL.get(j);
                Element dataElem = doc.createElement("data");
                rootElem.appendChild(dataElem);
                dataElem.setAttribute("dataname", mappingData.getDataName());
                dataElem.setAttribute("xoonipsversion", "3.4");
                dataElem.setAttribute("typename", mappingData.getDstXooNIpsItemType().getTypeName());
                ArrayList<MappingField> fields = mappingData.getFieldList();
                int k = 0;
                while (k < fields.size()) {
                    MappingField field = fields.get(k);
                    Element fieldElem = doc.createElement("field");
                    dataElem.appendChild(fieldElem);
                    Element dstElem = doc.createElement("dst");
                    fieldElem.appendChild(dstElem);
                    dstElem.setAttribute("type", "xoonips");
                    dstElem.appendChild(doc.createTextNode(field.getDst()));
                    ArrayList<String> srcs = field.getSrc();
                    int l = 0;
                    while (l < srcs.size()) {
                        Element srcElem = doc.createElement("src");
                        fieldElem.appendChild(srcElem);
                        srcElem.setAttribute("type", "concierge");
                        srcElem.appendChild(doc.createTextNode(srcs.get(l)));
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            doc = null;
        }
        return doc;
    }

    private void readDoc(ExportMappingDataList mappingDataList) {
        String xpath = "/exportmappingdata[@conciergeitemtype='" + mappingDataList.getSrcID() + "']";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, (Object)xpath, "xoonipslink");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        System.out.println("Result size = " + docs.size());
        if (docs != null && docs.size() > 0) {
            Document doc = (Document)docs.get(0);
            Element rootElem = doc.getDocumentElement();
            String selectString = rootElem.getAttribute("select");
            if (selectString != null && selectString.length() > 0) {
                mappingDataList.setCurrentIndex(Integer.valueOf(selectString));
            } else {
                mappingDataList.setCurrentIndex(-1);
            }
            Node dataNode = rootElem.getFirstChild();
            while (dataNode != null) {
                if (dataNode.getNodeType() == 1) {
                    ArrayList<MappingField> fieldsAL = new ArrayList<MappingField>();
                    Hashtable<String, ArrayList<String>> fieldsHT = new Hashtable<String, ArrayList<String>>();
                    Node fieldNode = dataNode.getFirstChild();
                    while (fieldNode != null) {
                        if (fieldNode.getNodeType() == 1) {
                            String dstValue = "";
                            Element fieldElement = (Element)fieldNode;
                            NodeList dstNodeList = fieldElement.getElementsByTagName("dst");
                            if (dstNodeList.getLength() > 0) {
                                Element dstElem = (Element)dstNodeList.item(0);
                                NodeList nl = dstElem.getChildNodes();
                                int k = 0;
                                while (k < nl.getLength()) {
                                    Node n = nl.item(k);
                                    if (n.getNodeType() == 3) {
                                        dstValue = String.valueOf(dstValue) + n.getNodeValue();
                                    }
                                    ++k;
                                }
                            }
                            MappingField mappingField = new MappingField(dstValue);
                            NodeList srcNodeList = fieldElement.getElementsByTagName("src");
                            int i = 0;
                            while (i < srcNodeList.getLength()) {
                                Element srcElem = (Element)srcNodeList.item(i);
                                String srcValue = "";
                                NodeList nl = srcElem.getChildNodes();
                                int k = 0;
                                while (k < nl.getLength()) {
                                    Node n = nl.item(k);
                                    if (n.getNodeType() == 3) {
                                        srcValue = String.valueOf(srcValue) + n.getNodeValue();
                                    }
                                    ++k;
                                }
                                mappingField.addSrc(srcValue);
                                ++i;
                            }
                            fieldsAL.add(mappingField);
                            fieldsHT.put(mappingField.getDst(), mappingField.getSrc());
                        }
                        fieldNode = fieldNode.getNextSibling();
                    }
                    String dataName = ((Element)dataNode).getAttribute("dataname");
                    ((Element)dataNode).getAttribute("xoonipsversion");
                    String typename = ((Element)dataNode).getAttribute("typename");
                    try {
                        XooNIpsItemType[] xnpItemTypes = this.xoonipsConnection.getXooNIpsSession().getItemTypeList();
                        ExportMappingData mappingData = null;
                        int j = 0;
                        while (j < xnpItemTypes.length) {
                            if (xnpItemTypes[j].getTypeName().equals(typename)) {
                                mappingData = new ExportMappingData(dataName, xnpItemTypes[j], fieldsAL, fieldsHT);
                                break;
                            }
                            ++j;
                        }
                        if (mappingData != null) {
                            mappingDataList.addMappingData(mappingData);
                        }
                    }
                    catch (Exception exception) {}
                }
                dataNode = dataNode.getNextSibling();
            }
        }
    }

    public static boolean canUseXooNIpsTypeField(String fieldName, XooNIpsItemType xnpItemType) {
        block8: {
            try {
                String fieldType = xnpItemType.getFieldType(fieldName);
                if ("STRING".equals(fieldType) || "DATE".equals(fieldType)) break block8;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (xnpItemType.isReadOnly(fieldName)) {
            return false;
        }
        if (fieldName.equals("item_id") || fieldName.equals("itemtype") || fieldName.equals("indexes") || fieldName.equals("related_to")) {
            return false;
        }
        if (fieldName.equals("lang")) {
            return false;
        }
        if (fieldName.equals("detail_field.book_id") || fieldName.equals("detail_field.conference_id") || fieldName.equals("detail_field.data_id") || fieldName.equals("detail_field.files_id") || fieldName.equals("detail_field.memo_id") || fieldName.equals("detail_field.model_id") || fieldName.equals("detail_field.paper_id") || fieldName.equals("detail_field.presentation_id") || fieldName.equals("detail_field.simulator_id") || fieldName.equals("detail_field.stimulus_id") || fieldName.equals("detail_field.tool_id") || fieldName.equals("detail_field.url_id")) {
            return false;
        }
        if (fieldName.equals("detail_field.use_cc") || fieldName.equals("detail_field.cc_commercial_use") || fieldName.equals("detail_field.cc_modification")) {
            return false;
        }
        return !fieldName.equals("detail_field.attachment_dl_limit") && !fieldName.equals("detail_field.attachment_dl_notify");
    }

    class MappingViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            if (obj instanceof MappingField) {
                MappingField field = (MappingField)obj;
                if (index == 0) {
                    ExportMappingDataList mappingDataList = ExportPreferenceDialog.this.getSelectionTypeTableView();
                    if (mappingDataList != null) {
                        ArrayList<ExportMappingData> mappingDataAL = mappingDataList.getList();
                        if (mappingDataList.getCurrentIndex() >= 0) {
                            ExportMappingData mappingData = mappingDataAL.get(mappingDataList.getCurrentIndex());
                            return mappingData.getDstXooNIpsItemType().getDisplayName(field.getDst());
                        }
                    }
                    return "";
                }
                if (index == 1) {
                    StringBuffer strBuf = new StringBuffer();
                    ArrayList<String> al = field.getSrc();
                    if (al != null) {
                        int i = 0;
                        while (i < al.size()) {
                            if (i > 0) {
                                strBuf.append(", ");
                            }
                            String src = al.get(i);
                            strBuf.append(src);
                            ++i;
                        }
                    }
                    return strBuf.toString();
                }
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

