/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.xoonipslink2.preferences;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.plugin.XooNIpsConnection;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.MappingData;
import jp.sourceforge.concierge.plugin.xoonipslink2.preferences.MappingDataList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.w3c.dom.Document;

public class MappingTableDialog
extends Dialog {
    protected TableViewer typeTableView = null;
    protected ComboViewer datasetListCombo = null;
    protected Button datasetEditButton = null;
    protected Label dataNameLabel = null;
    protected Label dstTypeNameLabel = null;
    protected TableViewer mappingTableViewer = null;
    protected ImageRegistry imageReg = null;
    protected XooNIpsConnection xoonipsConnection = null;

    protected MappingTableDialog(Shell parentShell, XooNIpsConnection xoonipsConnection) {
        super(parentShell);
        this.xoonipsConnection = xoonipsConnection;
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Control control = this.createSettingControl(parent);
        this.initialize();
        return control;
    }

    protected Control createSettingControl(Composite parent) {
        return null;
    }

    protected void createTypeTableViewer(Composite parent) {
        this.typeTableView = new TableViewer(parent, 68356);
        this.typeTableView.setLabelProvider((IBaseLabelProvider)new TypeTableViewLabelProvider());
        new TableColumn(this.typeTableView.getTable(), 16384, 0);
        this.typeTableView.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length > 0) {
                    col[0].setWidth(r.width);
                }
            }
        });
    }

    protected void createDatasetControls(Composite parent) {
        Composite datasetComposite = new Composite(parent, 0);
        datasetComposite.setLayout((Layout)new GridLayout(3, false));
        datasetComposite.setLayoutData((Object)new GridData(768));
        Label datasetLabel = new Label(datasetComposite, 0);
        datasetLabel.setText("Data Set");
        this.datasetListCombo = new ComboViewer(datasetComposite, 8);
        this.datasetListCombo.getControl().setLayoutData((Object)new GridData(768));
        this.datasetListCombo.setLabelProvider((IBaseLabelProvider)new DatasetComboViewLabelProvider());
        this.datasetListCombo.setContentProvider((IContentProvider)new ViewContentProvider());
        this.datasetEditButton = new Button(datasetComposite, 8);
        this.datasetEditButton.setText("...");
    }

    protected void createDataNameControls(Composite parent) {
        Label nameLabel = new Label(parent, 131072);
        nameLabel.setText("Name:");
        this.dataNameLabel = new Label(parent, 0);
        this.dataNameLabel.setLayoutData((Object)new GridData(768));
        this.dataNameLabel.setText("     ");
    }

    protected void createDstTypeNameControls(Composite parent, String bLabelName) {
        Label dstTypeLabel = new Label(parent, 131072);
        dstTypeLabel.setText(bLabelName);
        this.dstTypeNameLabel = new Label(parent, 0);
        this.dstTypeNameLabel.setLayoutData((Object)new GridData(768));
        this.dstTypeNameLabel.setText("     ");
    }

    protected void createMappingTableViewer(Composite parent, String bColumnName, String aColumnName) {
        this.mappingTableViewer = new TableViewer(parent, 66308);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        this.mappingTableViewer.getTable().setLayoutData((Object)gd);
        this.mappingTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.mappingTableViewer.getTable().setLinesVisible(true);
        this.mappingTableViewer.getTable().setHeaderVisible(true);
        TableColumn tcB = new TableColumn(this.mappingTableViewer.getTable(), 16384, 0);
        tcB.setText(bColumnName);
        TableColumn tcA = new TableColumn(this.mappingTableViewer.getTable(), 16384, 1);
        tcA.setText(aColumnName);
        tcA.setResizable(true);
        this.mappingTableViewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length == 2) {
                    col[0].setWidth(r.width / 2);
                    col[1].setWidth(r.width / 2);
                }
            }
        });
    }

    protected void setMappingDataToControls(MappingData data) {
        if (data != null) {
            this.dataNameLabel.setText(data.getDataName());
            this.dstTypeNameLabel.setText(data.getDstTypeName());
            this.mappingTableViewer.setInput(data.getFieldList());
        } else {
            this.dataNameLabel.setText("");
            this.dstTypeNameLabel.setText("");
            this.mappingTableViewer.setInput(null);
        }
    }

    protected void initialize() {
    }

    protected void DoSave() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.DoSave();
        }
        if (this.imageReg != null) {
            this.imageReg.dispose();
            this.imageReg = null;
        }
        this.setReturnCode(buttonId);
        this.close();
        super.buttonPressed(buttonId);
    }

    class DatasetComboViewLabelProvider
    extends LabelProvider {
        DatasetComboViewLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof MappingData) {
                MappingData data = (MappingData)element;
                String value = String.valueOf(data.getDataName()) + " (" + data.getDstTypeName() + ")";
                return value;
            }
            return element.toString();
        }
    }

    class TypeTableViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TypeTableViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Document) {
                Document doc = (Document)obj;
                return TypeDomImpl.getTypeName((Document)doc);
            }
            if (obj instanceof MappingDataList) {
                MappingDataList mappingDataList = (MappingDataList)obj;
                return mappingDataList.getSrcTypeName();
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return this.getImage(obj);
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (obj instanceof MappingDataList) {
                String id;
                Image newImage;
                MappingDataList mappingDataList = (MappingDataList)obj;
                if (MappingTableDialog.this.imageReg == null) {
                    MappingTableDialog.this.imageReg = new ImageRegistry();
                }
                if ((newImage = MappingTableDialog.this.imageReg.get(id = mappingDataList.getSrcID())) == null && (newImage = mappingDataList.getSrcImage(MappingTableDialog.this.getShell().getDisplay())) != null) {
                    MappingTableDialog.this.imageReg.put(id, newImage);
                }
                return newImage;
            }
            return null;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }
}

