/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.XooNIps;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.AccountsDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.XooNIps.Preference.XooNIpsPlatformData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

public class XooNIpsLoginDialog
extends Dialog {
    private Combo pfCombo = null;
    private Text urlText = null;
    private Text userText = null;
    private Text passwdText = null;
    private Group accountGrp = null;
    private Button guestUserCheckButton = null;
    private Button registUserCheckButton = null;
    private String xoonipsVersion = null;
    private static String url = null;
    private static String user = null;
    private static String passwd = null;
    private static boolean guestUser = false;
    private static boolean saveSign = false;
    private static XooNIpsPlatformData xnpPlatformData = null;
    private ArrayList<XooNIpsPlatformData> platformList = null;

    public XooNIpsLoginDialog(Shell parentShell, String xoonipsVersion) {
        super(parentShell);
        if (url == null) {
            url = "";
        }
        if (user == null) {
            user = "";
        }
        if (passwd == null) {
            passwd = "";
        }
        if (this.platformList == null) {
            this.platformList = new ArrayList();
        }
        this.xoonipsVersion = xoonipsVersion;
    }

    public String getURL() {
        return url;
    }

    public String getUser() {
        return user;
    }

    public String getPasswd() {
        return passwd;
    }

    public boolean isGuestUser() {
        return guestUser;
    }

    public boolean isSaveSign() {
        return saveSign;
    }

    protected Point getInitialSize() {
        return new Point(480, 320);
    }

    protected Control createDialogArea(Composite parent) {
        GridData gd = null;
        this.getShell().setText("Login XooNIps Site");
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 8;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("Platform:");
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.pfCombo = new Combo(composite, 8);
        this.pfCombo.setToolTipText("XooNIps Platform");
        ArrayList al = AccountsDomImpl.getAccountDocuments((String)"xoonipsplatform");
        if (al != null) {
            int i = 0;
            while (i < al.size()) {
                Document doc = (Document)al.get(i);
                XooNIpsPlatformData data = new XooNIpsPlatformData(doc);
                if (data.getVersion().equals(this.xoonipsVersion)) {
                    this.platformList.add(data);
                    this.pfCombo.add(data.getPlatformName());
                    if (xnpPlatformData != null) {
                        long srcID = DomImpl.getID((Document)xnpPlatformData.getDoc(false));
                        long dstID = DomImpl.getID((Document)data.getDoc(false));
                        if (srcID != 0L && srcID == dstID) {
                            this.pfCombo.select(i);
                        }
                    }
                }
                ++i;
            }
        }
        if (this.pfCombo.getSelectionIndex() == -1) {
            xnpPlatformData = null;
        }
        this.pfCombo.setLayoutData((Object)new GridData(768));
        this.pfCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                int index = combo.getSelectionIndex();
                if (index >= 0 && index < XooNIpsLoginDialog.this.platformList.size()) {
                    XooNIpsPlatformData data = (XooNIpsPlatformData)XooNIpsLoginDialog.this.platformList.get(index);
                    xnpPlatformData = data;
                    XooNIpsLoginDialog.this.urlText.setText(data.getURL());
                    if (data.isAutoFill()) {
                        XooNIpsLoginDialog.this.userText.setText(data.getUserName());
                        XooNIpsLoginDialog.this.passwdText.setText(data.getPasswd());
                        guestUser = false;
                        XooNIpsLoginDialog.this.guestUserCheckButton.setSelection(guestUser);
                        XooNIpsLoginDialog.this.registUserCheckButton.setSelection(!guestUser);
                        XooNIpsLoginDialog.this.accountGrp.setEnabled(!guestUser);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label0 = new Label(composite, 0);
        label0.setText("URL:");
        this.urlText = new Text(composite, 2048);
        this.urlText.setLayoutData((Object)new GridData(768));
        if (url != null) {
            this.urlText.setText(url);
        }
        Label separator = new Label(composite, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        Label label3 = new Label(composite, 16384);
        label3.setText("Connect as:");
        this.guestUserCheckButton = new Button(composite, 16);
        this.guestUserCheckButton.setText("Guest");
        gd = new GridData(32);
        this.guestUserCheckButton.setLayoutData((Object)gd);
        this.guestUserCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                guestUser = button.getSelection();
                XooNIpsLoginDialog.this.accountGrp.setEnabled(!guestUser);
            }
        });
        this.guestUserCheckButton.setSelection(guestUser);
        Label label4 = new Label(composite, 16384);
        label4.setText("");
        this.registUserCheckButton = new Button(composite, 16);
        this.registUserCheckButton.setText("Registered User");
        gd = new GridData(32);
        this.registUserCheckButton.setLayoutData((Object)gd);
        this.registUserCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                guestUser = !button.getSelection();
                XooNIpsLoginDialog.this.accountGrp.setEnabled(!guestUser);
            }
        });
        this.registUserCheckButton.setSelection(!guestUser);
        this.accountGrp = new Group(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.accountGrp.setLayoutData((Object)gd);
        this.accountGrp.setLayout((Layout)new GridLayout(2, false));
        this.accountGrp.setEnabled(!guestUser);
        Label label1 = new Label((Composite)this.accountGrp, 131072);
        label1.setText("ID:");
        this.userText = new Text((Composite)this.accountGrp, 2048);
        this.userText.setLayoutData((Object)new GridData(768));
        if (user != null) {
            this.userText.setText(user);
        }
        Label label2 = new Label((Composite)this.accountGrp, 131072);
        label2.setText("Password:");
        this.passwdText = new Text((Composite)this.accountGrp, 2048);
        this.passwdText.setLayoutData((Object)new GridData(768));
        this.passwdText.setEchoChar('*');
        if (passwd != null) {
            this.passwdText.setText(passwd);
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Login", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.urlText.getText().length() == 0) {
                this.urlText.setText(url);
                return;
            }
            if (!guestUser) {
                if (this.userText.getText().length() == 0) {
                    this.userText.setText(user);
                    return;
                }
                int index = this.pfCombo.getSelectionIndex();
                if (index >= 0 && index < this.platformList.size()) {
                    XooNIpsPlatformData data;
                    xnpPlatformData = data = this.platformList.get(index);
                }
                url = new String(this.urlText.getText());
                user = new String(this.userText.getText());
                passwd = new String(this.passwdText.getText());
            } else {
                int index = this.pfCombo.getSelectionIndex();
                if (index >= 0 && index < this.platformList.size()) {
                    XooNIpsPlatformData data;
                    xnpPlatformData = data = this.platformList.get(index);
                }
                url = new String(this.urlText.getText());
                user = new String(this.userText.getText());
                passwd = new String(this.passwdText.getText());
            }
        }
        this.setReturnCode(buttonId);
        this.close();
        super.buttonPressed(buttonId);
    }
}

