/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.widget;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextInputDialog
extends Dialog {
    protected Composite base = null;
    protected Text textBox = null;
    protected String title = "";
    protected String message = "";
    protected String text = "";
    protected ModifyListener modlistener = null;

    public TextInputDialog(Shell shell, String t, String m) {
        super(shell);
        this.title = t;
        this.message = m;
        this.base = null;
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.base = null;
        this.textBox = null;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.title != null) {
            this.getShell().setText(this.title);
        }
        this.base = (Composite)super.createDialogArea(parent);
        this.base.setLayout((Layout)new GridLayout(1, false));
        this.base.setLayoutData((Object)new GridData(1808));
        Composite comp = new Composite(this.base, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(768));
        Label titleLabel = new Label(comp, 16384);
        titleLabel.setLayoutData((Object)new GridData());
        if (this.message != null) {
            titleLabel.setText(this.message);
        }
        this.textBox = new Text(comp, 2052);
        this.textBox.setLayoutData((Object)new GridData(768));
        if (this.text != null) {
            this.textBox.setText(this.text);
            this.textBox.selectAll();
        }
        if (this.modlistener != null) {
            this.textBox.addModifyListener(this.modlistener);
        }
        return this.base;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.getShell().setSize(320, 160);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        this.text = buttonId == 0 ? this.textBox.getText() : null;
        this.setReturnCode(buttonId);
        this.close();
    }

    public void setValue(String val) {
        this.text = val;
    }

    public String getValue() {
        return this.text;
    }

    public void setModifyListener(ModifyListener ml) {
        this.modlistener = ml;
    }

    public Text getTextField() {
        return this.textBox;
    }
}

