/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.widget;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.ImageToolTip;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageListDialog
extends Dialog {
    private Composite imgcomp = null;
    private Label imglabel = null;
    private Image selimage = null;
    private ArrayList<Image> imagelist = null;

    public ImageListDialog(Shell parentShell) {
        super(new Shell(parentShell));
    }

    private Image getResizedImage(Image img, int maxx, int maxy) {
        ImageData id = img.getImageData();
        double ratiox = (double)maxx / (double)id.width;
        double ratioy = (double)maxy / (double)id.height;
        double ratio = ratiox > ratioy ? ratioy : ratiox;
        ImageData nid = id.scaledTo((int)((double)id.width * ratio), (int)((double)id.height * ratio));
        Image nimg = new Image(img.getDevice(), nid);
        return nimg;
    }

    private void disposeImage(Label l) {
        Image oi;
        Image li = l.getImage();
        if (li != null && !li.isDisposed()) {
            li.dispose();
        }
        if ((oi = (Image)l.getData("OImage")) != null && !oi.isDisposed()) {
            oi.dispose();
        }
    }

    protected void initializeBounds() {
        this.getShell().setSize(480, 320);
    }

    protected Control createDialogArea(Composite parent) {
        Composite base = (Composite)super.createDialogArea(parent);
        base.setLayout((Layout)new GridLayout(4, true));
        ScrolledComposite scomp = new ScrolledComposite(base, 768);
        GridData gl = new GridData(1808);
        gl.horizontalSpan = 3;
        scomp.setLayoutData((Object)gl);
        this.imgcomp = new Composite((Composite)scomp, 0);
        this.imgcomp.setBackground(this.imgcomp.getDisplay().getSystemColor(16));
        scomp.setContent((Control)this.imgcomp);
        scomp.setExpandHorizontal(true);
        scomp.setExpandVertical(true);
        RowLayout rl = new RowLayout();
        rl.fill = true;
        rl.wrap = true;
        this.imgcomp.setLayout((Layout)rl);
        Group btncomp = new Group(base, 0);
        btncomp.setLayout((Layout)new GridLayout(1, true));
        btncomp.setLayoutData((Object)new GridData(4, 4, true, true));
        btncomp.setText("Selected Image");
        this.imglabel = new Label((Composite)btncomp, 0);
        this.imglabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        if (this.selimage != null) {
            this.imglabel.setImage(this.getResizedImage(this.selimage, 80, 80));
            this.imglabel.setData("OImage", (Object)this.getResizedImage(this.selimage, 200, 200));
        }
        int i = 0;
        while (i < this.imagelist.size()) {
            Label l = new Label(this.imgcomp, 2048);
            l.setLayoutData((Object)new RowData(80, 80));
            l.setData("OImage", (Object)this.getResizedImage(this.imagelist.get(i), 200, 200));
            l.setBackground(l.getDisplay().getSystemColor(16));
            l.setImage(this.getResizedImage(this.imagelist.get(i), 80, 80));
            ImageToolTip itt = new ImageToolTip((Control)l, 0, true);
            l.setData("ToolTip", (Object)itt);
            l.addMouseTrackListener(new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseEnter(MouseEvent e) {
                    Label ll = (Label)e.widget;
                    ImageToolTip itt = (ImageToolTip)ll.getData("ToolTip");
                    Image img = (Image)ll.getData("OImage");
                    itt.setImage(img);
                    Point p = ll.getSize();
                    itt.show(new Point(p.x / 2, p.y / 2));
                }

                public void mouseExit(MouseEvent e) {
                    Label ll = (Label)e.widget;
                    ImageToolTip itt = (ImageToolTip)ll.getData("ToolTip");
                    if (itt == null) {
                        return;
                    }
                }
            });
            l.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    Label el = (Label)e.widget;
                    Image nimg = (Image)el.getData("OImage");
                    Image oldimg = ImageListDialog.this.imglabel.getImage();
                    if (oldimg != null && !oldimg.isDisposed()) {
                        oldimg.dispose();
                    }
                    ImageListDialog.this.imglabel.setImage(ImageListDialog.this.getResizedImage(nimg, 80, 80));
                    ImageListDialog.this.imglabel.setData("OImage", (Object)nimg);
                    ImageListDialog.this.imglabel.pack();
                }
            });
            ++i;
        }
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        if (this.selimage != null && !this.selimage.isDisposed()) {
            this.selimage.dispose();
        }
        this.selimage = buttonId == 0 ? this.getResizedImage((Image)this.imglabel.getData("OImage"), 200, 200) : null;
        this.setReturnCode(buttonId);
        this.dispose();
        this.close();
    }

    public void setImages(ArrayList<Image> imgs) {
        this.imagelist = imgs;
    }

    public void setSelectedImage(Image img) {
        this.selimage = this.getResizedImage(img, 200, 200);
    }

    public Image getImage() {
        return this.selimage;
    }

    public void dispose() {
        Control[] ctrls = this.imgcomp.getChildren();
        int i = 0;
        while (i < ctrls.length) {
            if (ctrls[i] instanceof Label) {
                this.disposeImage((Label)ctrls[i]);
            }
            ++i;
        }
        this.disposeImage(this.imglabel);
    }
}

