/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.editor;

import java.util.ArrayList;
import jp.sourceforge.concierge.editor.DataEditorInput;
import jp.sourceforge.concierge.editor.EditorDelegate;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.w3c.dom.Document;

public class EditorManager {
    public static ArrayList<IEditorPart> editors = new ArrayList();

    public static IEditorPart openEditor(Document doc, boolean isnewdoc, Object sender) {
        String type = DataDomImpl.getDefaultType(doc);
        Document tdoc = TypeManager.getTypeDocument(type);
        String pid = TypeDomImpl.getPluginID(tdoc);
        EditorDelegate ed = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("jp.sourceforge.concierge.framework.ConciergeEditorArea");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals("ConciergeEditorArea") && pid.equals(elements[j].getAttribute("pluginid"))) {
                        try {
                            ed = (EditorDelegate)elements[j].createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (ed == null) {
            return null;
        }
        ed.setDocument(doc, isnewdoc, sender);
        IWorkbenchWindow window = FrameworkPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            int i = 0;
            while (i < editors.size()) {
                DataEditorInput dei = (DataEditorInput)editors.get(i).getEditorInput();
                if (DomImpl.equalsByID(dei.getDocument(), doc)) {
                    IWorkbenchPage ep = editors.get(i).getSite().getPage();
                    ep.activate((IWorkbenchPart)editors.get(i));
                    return editors.get(i);
                }
                ++i;
            }
            IEditorPart ie = page.openEditor((IEditorInput)new DataEditorInput(doc, ed, isnewdoc, sender), "jp.sourceforge.concierge.ccgeditor");
            page.addPartListener(new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    IWorkbenchPage page = part.getSite().getPage();
                    IEditorReference[] ref = page.getEditorReferences();
                    if (ref.length == 0) {
                        page.setEditorAreaVisible(false);
                    }
                    if (part instanceof IEditorPart) {
                        editors.remove(part);
                    }
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partOpened(IWorkbenchPart part) {
                }
            });
            editors.add(ie);
            return ie;
        }
        catch (PartInitException e) {
            System.out.println((Object)e);
            return null;
        }
    }

    public static void deleteEditor(Document doc) {
        int i = 0;
        while (i < editors.size()) {
            DataEditorInput dei = (DataEditorInput)editors.get(i).getEditorInput();
            if (DomImpl.equalsByID(dei.getDocument(), doc)) {
                IWorkbenchPage page = editors.get(i).getSite().getPage();
                page.closeEditor(editors.get(i), false);
                break;
            }
            ++i;
        }
    }

    public static void updateEditor(CCGUpdateEvent parameter) {
        int i = 0;
        while (i < editors.size()) {
            DataEditorInput dei = (DataEditorInput)editors.get(i).getEditorInput();
            dei.getDelegate().update(parameter);
            ++i;
        }
    }

    public static void initialize() {
    }
}

