/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.view.PaperListener;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaperList {
    private static final PaperList singleton = new PaperList();
    private final List<Paper> paperList = new ArrayList<Paper>();
    private final ListenerList listenerList = new ListenerList();

    public static PaperList getInstance() {
        return singleton;
    }

    public List<Paper> getArticleList() {
        return this.paperList;
    }

    public void addPaper(Paper paper) {
        this.paperList.add(paper);
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            PaperListener listener = (PaperListener)listeners[i];
            listener.paperAdded(paper);
            ++i;
        }
    }

    public void addPapers(ArrayList<Paper> papers) {
        int j = 0;
        while (j < papers.size()) {
            this.addPaper(papers.get(j));
            ++j;
        }
    }

    public void addPaperListener(PaperListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removePaperListener(PaperListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public int size() {
        return this.paperList.size();
    }

    public void clear() {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            PaperListener listener = (PaperListener)listeners[i];
            listener.paperCleared();
            ++i;
        }
        this.paperList.clear();
    }

    public void removePaper(Paper article) {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            PaperListener listener = (PaperListener)listeners[i];
            listener.paperRemoved(article);
            ++i;
        }
        this.paperList.remove(article);
    }
}

